<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 陈风任 <491085389@qq.com>
 * Date: 2018-12-11
 */

namespace weapp\PictureCleaning\controller;

use think\Page;
use think\Db;
use think\Config;
use app\common\controller\Weapp;

/**
 * 插件的控制器
 */
class PictureCleaning extends Weapp
{
    /**
     * 实例化对象
     */
    private $db;

    /**
     * 插件基本信息
     */
    private $weappInfo;

    /**
     * 构造方法
     */
    public function __construct(){
        parent::__construct();
        $this->db = Db::name('WeappPictureCleaning');

        /*插件基本信息*/
        $this->weappInfo = $this->getWeappInfo();
        $this->assign('weappInfo', $this->weappInfo);
        /*--end*/
    }

    /**
     * 插件使用说明
     */
    public function doc(){
        return $this->fetch('doc');
    }

    /**
     * 
     */
    public function lists()
    {
        $list = array();
        $keywords = input('keywords/s');

        $map = array();
        if (!empty($keywords)) {
            $map['table_of_ontents'] = array('LIKE', "%{$keywords}%");
        }

        $map['status'] = 1; // status=1为被清理数据

        $count = $this->db->where($map)
            ->group('table_of_ontents')
            ->count('id');// 查询满足要求的总记录数
        $pageObj = new Page($count, config('paginate.list_rows'));// 实例化分页类 传入总记录数和每页显示的记录数
        $result = $this->db->field('*, count(id) AS count')
            ->where($map)
            ->group('table_of_ontents')
            ->order('id desc')
            ->limit($pageObj->firstRow.','.$pageObj->listRows)
            ->select();
        $pageStr = $pageObj->show(); // 分页显示输出
        $this->assign('result', $result); // 赋值数据集
        $this->assign('pageStr', $pageStr); // 赋值分页输出
        $this->assign('pageObj', $pageObj); // 赋值分页对象

        return $this->fetch('lists');
    }

    /**
     * 首页
     */
    public function index()
    {
        return $this->fetch('index');
    }

    /**
     * 获取未使用文件个数并存入数据库记录
     */
    public function picture_query()
    {
        // 获取项目文件中的图片
        $file_image  = $this->get_file_image();

        // 获取数据库中的所有图片路径
        $mysql_image = $this->get_mysql_image();

        // 对比处理图片，返回差集
        $result = array_diff($file_image,$mysql_image);

        // 图片数据处理
        if (is_array($result) && !empty($result)) {
            foreach ($result as $value) {
                $data['url'] = $value;
                $nowData = array(
                    'add_time'    => getTime(),
                    'update_time' => getTime(),
                );
                $saveData = array_merge($data, $nowData);

                // 查询并判断数据是否存在
                $where = [
                    'status' => 0,
                    'url'    => $data['url'],
                ];
                $CountNum = $this->db->where($where)->count();
                if (empty($CountNum)) {
                    // 添加数据
                    $insertId = $this->db->insert($saveData);
                }
            }
        }

        // 返回结果
        $count['count']  = count($result);
        echo json_encode($count);
    }

    // 获取项目文件中的图片
    public function get_file_image(){
        $filenames   = [];
        $public_path = 'public/upload/';
        if (is_dir($public_path)) {
            $upload    = $this->getDirFile($public_path, '/public/upload');
            $filenames = $upload;
        }

        $uploads_path = 'uploads/';
        if (is_dir($uploads_path)) {
            $uploads   = $this->getDirFile($uploads_path, '/uploads');
            $filenames = $uploads;
        }

        if (!empty($upload) && !empty($uploads)) {
            $filenames = array_merge($upload, $uploads);
        }
        
        if (!empty($filenames)) {
            $ImagesArray = array('.gif','.jpeg','.png','.bmp','.jpg','.ico','.webp');
            foreach ($filenames as $key => $value) {
                $type = strtolower(substr($value,-4));
                if(in_array($type,$ImagesArray)){
                    $filenames_new[] = $value;
                }
            }
            return $filenames_new;
        }else{
            return $filenames;
        }
    }

    // 递归读取文件夹文件
    function getDirFile($directory, $dir_name='', &$arr_file = array()) {
        if (!file_exists($directory) ) {
            return false;
        }

        $mydir = dir($directory);
        while($file = $mydir->read())
        {
            if ('weapp' != $file && 'thumb' != $file) {
                if((is_dir("$directory/$file")) AND ($file != ".") AND ($file != ".."))
                {
                    if ($dir_name) {
                        getDirFile("$directory/$file", "$dir_name/$file", $arr_file);
                    } else {
                        getDirFile("$directory/$file", "$file", $arr_file);
                    }
                    
                }
                else if(($file != ".") AND ($file != ".."))
                {
                    if ($dir_name) {
                        $arr_file[] = "$dir_name/$file";
                    } else {
                        $arr_file[] = "$file";
                    }
                }
            }
        }
        $mydir->close();
        return $arr_file;
    }

    // 获取数据库中的所有图片路径
    public function get_mysql_image(){
        // 获取数据库表名和字段
        $array = $this->get_array();
        $database_data = GetDatabaseData($array);
        return $database_data;
    }

    /**
     * 拼装数据库表和字段
     */
    public function get_array()
    {
        // 自定义字段获取逻辑
        $where  = 'a.ifsystem=0 and (a.dtype="img" || a.dtype="imgs")';
        $result = Db::name('channelfield')->field('a.channel_id,a.name as field,a.dtype,b.table')
            ->alias('a')
            ->join('__CHANNELTYPE__ b', 'a.channel_id = b.id', 'LEFT')
            ->order('a.channel_id desc')
            ->where($where)
            ->select();

        foreach ($result as $key => $value) {
            if (Config::get('global.arctype_channel_id') == $value['channel_id']) { 
                $result[$key]['table'] = 'arctype'; 
            } else {
                $result[$key]['table'] = $value['table'].'_content';
            }
        }
        // 获取内置的config配置中的数据表和字段
        $array = Config::get('global.get_tablearray');
        // 合并两个数组
        $data_new = array_merge($result,$array);
        // 返回结果集
        return $data_new;
    }

    /**
     * 查看文件-未清理
     */
    public function picture_list()
    {
        $result = $this->db->field('url')->where('status','0')->select();
        $array = array('.gif','.jpeg','.png','.bmp','.jpg','.ico','.webp');
        
        foreach ($result as $key => $value) {
            $types = strtolower(substr($value['url'],-4));
            if(in_array($types,$array)){
                $result[$key]['type'] = '1';
            }else{
                $result[$key]['type'] = '2';
            }
        }
        $times = date('Ymd');
        $this->assign('times',$times);
        $this->assign('result',$result);
        return $this->fetch('picture_list');
    }

    /**
     * 查看文件-已清理
     */
    public function clean_up_list()
    {
        $table_of_ontents = (int)input('param.table_of_ontents');
        $result = [];
        if(!empty($table_of_ontents)){
            $where = [
                'status' => 1,
                'table_of_ontents' => $table_of_ontents,
            ];
            $result = $this->db->field('url')->where($where)->select();
            $array = array('.gif','.jpeg','.png','.bmp','.jpg','.ico','.webp');
            
            foreach ($result as $key => $value) {
                $types = strtolower(substr($value['url'],-4));
                if(in_array($types,$array)){
                    $result[$key]['type'] = '1';
                }else{
                    $result[$key]['type'] = '2';
                }
            }
        }

        $path = 'data/tempimg/'.$table_of_ontents;
        $this->assign('path',$path);
        $this->assign('result',$result);
        return $this->fetch('clean_up_list');
    }

    /**
     * 清理文件
     */
    public function image_deal_with(){
        if (IS_AJAV_POST) {
            $post = input('post.');
            if (empty($post)) {
                $this->error("参数错误，请重新扫描~~");
            }
            // 查询图片清理查询数据表数据，已扫描但未处理文件
            $result = $this->db->field('id,url')->where('status','0')->select();
            $i = '0';

            if ('Delete' == $post['type']) {
                if (is_array($result) && !empty($result)) {
                    foreach ($result as $value) {
                        $id = $this->db->where('id',$value['id'])->delete();
                        if (!empty($id)) {
                            // 处理文件的路径
                            $url = substr($value['url'],strlen(ROOT_DIR));
                            $url = iconv('UTF-8', 'GB2312', ROOT_PATH.$url);
                            @unlink($url);
                            $i++;
                        }
                    }
                    if ($i > 0) {
                        $this->success('成功删除'.$i.'个文件');
                    }
                }else{
                    $this->error("没有需要删除的文件~~");
                }
            }else if ('CleanUp' == $post['type']) {
                if (is_array($result) && !empty($result)) {
                    // 处理文件移动
                    foreach ($result as $value) {
                        // 处理文件的路径
                        $url = substr($value['url'],strlen(ROOT_DIR));
                        $url = iconv('UTF-8', 'GB2312', ROOT_PATH.$url);

                        // 获取需要创建的文件夹路径
                        $path  = substr($value['url'],0,strrpos($value['url'],"/"));
                        $times = date('Ymd');
                        $datapath = DATA_PATH.'tempimg/'.$times.$path;
                        // 创建文件夹，权限0777，true表示创建多级文件夹
                        @mkdir($datapath,0777,true);

                        // 移动文件夹
                        if (@rename($url, DATA_PATH.'tempimg/'.$times.$value['url'])) {
                            $saveData = [
                                'table_of_ontents' => $times,
                                'status' => '1',
                                'update_time' => getTime(),
                            ];
                            $id = $this->db->where('id',$value['id'])->update($saveData);
                            if (!empty($id)) {
                                $i++;
                            }
                        }
                    }
                    if ($i > 0) {
                        $this->success('成功清理'.$i.'个文件');
                    }
                }else{
                    $this->error("没有需要清理的文件~~");
                }
            }
        }
    }

    /**
     * 还原文件
     */
    public function recovery(){
        $table_of_ontents = input('param.table_of_ontents');
        if(!empty($table_of_ontents)){
            $result = $this->db->where("table_of_ontents",$table_of_ontents)->select();
            $url    = get_arr_column($result['0'], 'url');
           
            $id = $this->db->where("table_of_ontents",$table_of_ontents)->delete();
            if($id){
                recurse_copy(DATA_PATH.'tempimg/'.$table_of_ontents.ROOT_DIR, ROOT_PATH);
                delFile(DATA_PATH.'tempimg/'.$table_of_ontents.ROOT_DIR, true);

                adminLog('还原'.$this->weappInfo['name'].'：'.implode(',', $url));
                $this->success('还原成功！');
            }else{
                $this->error('还原失败！');
            }
        }else{
            $this->error('参数错误！');
        }
    }
    
    /**
     * 删除文件
     */
    public function del()
    {
        $table_of_ontents = input('param.table_of_ontents');
        if(!empty($table_of_ontents)){
            $result = $this->db->where("table_of_ontents",$table_of_ontents)->select();
            $url    = get_arr_column($result['0'], 'url');

            $id = $this->db->where("table_of_ontents",$table_of_ontents)->delete();
            if($id){
                delFile(DATA_PATH.'tempimg'.DS.$table_of_ontents, true);
                adminLog('删除'.$this->weappInfo['name'].'：'.implode(',', $url));
                $this->success('删除成功！');
            }else{
                $this->error('删除失败！');
            }
        }else{
            $this->error('参数错误！');
        }
    }

    /**
     * 批量删除文件
     */
    public function batch_del()
    {
        $table_arr = input('param.table_of_ontents/a');
        $table_arr = eyIntval($table_arr);
        if(!empty($table_arr)){
            $result = $this->db->where("table_of_ontents",'IN',$table_arr)->select();
            $url = get_arr_column($result['0'], 'url');

            $r = $this->db->where("table_of_ontents",'IN',$table_arr)->delete();
            if($r){
                foreach ($table_arr as $value) {
                    delFile(DATA_PATH.'tempimg'.DS.$value, true);
                }
                adminLog('删除'.$this->weappInfo['name'].'：'.implode(',', $url));
                $this->success("操作成功!");
            }else{
                $this->error("操作失败!");
            }
        }else{
            $this->error("参数有误!");
        }
    }
}