<?php
 namespace Module\News\Util; use Illuminate\Support\Facades\Cache; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\HtmlUtil; use ModStart\Core\Util\TimeUtil; class NewsUtil { public static function clearCache() { Cache::forget('NewsLatest'); } public static function buildRecord($record) { $item = ArrayUtil::keepKeys($record, ['id', 'cover', 'title', 'updated_at', 'summary']); $item['day'] = date('Y-m-d', strtotime($record['created_at'])); if (empty($record['cover'])) { $info = HtmlUtil::extractTextAndImages($record['content']); if (!empty($info['images'])) { $item['cover'] = $info['images'][0]; } } return $item; } public static function buildRecords($records) { foreach ($records as $k => $record) { $records[$k] = self::buildRecord($record); } return $records; } public static function listLatest($limit = 5) { return Cache::remember('NewsLatest', TimeUtil::MINUTE_PERIOD_DAY, function () use ($limit) { $records = ModelUtil::model('news') ->orderBy('id', 'desc') ->limit($limit)->get()->toArray(); return self::buildRecords($records); }); } public static function get($id) { return ModelUtil::get('news', ['id' => $id]); } public static function listCategories() { return ModelUtil::model('news_category')->orderBy('sort', 'asc')->get()->toArray(); } }