@extends($_viewFrame)

@section('pageTitleMain','新闻资讯')

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-nav-header">
            新闻资讯
        </div>

        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            @if($categoryId)
                                @foreach($categories as $category)
                                    @if($category['id']==$categoryId)
                                        {{$category['title']}}
                                    @endif
                                @endforeach
                            @else
                                全部
                            @endif
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-list-items" style="padding:0.5rem;">
                            @foreach($news as $new)
                                <div class="item-d">
                                    <a class="title" href="/news/{{$new['id']}}">{{$new['title']}}</a>
                                    <div class="attr">
                                        <i class="iconfont icon-time"></i>
                                        <span>{{($new['updated_at'])}}</span>
                                    </div>
                                    <div class="summary">
                                        {{\ModStart\Core\Util\HtmlUtil::text($new['summary'],200)}}
                                    </div>
                                    <div class="action ub-text-right">
                                        <a class="more" href="/news/{{$new['id']}}">
                                            [阅读全文]
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                            @if(empty($news))
                                <div class="ub-empty">暂无记录</div>
                            @endif
                        </div>
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">

                <div class="ub-menu simple">
                    <a class="title @if(!$categoryId) active @endif" href="/news">全部</a>
                    @foreach($categories as $category)
                        <a class="title @if($category['id']==$categoryId) active @endif" href="/news?categoryId={{$category['id']}}">{{$category['title']}}</a>
                    @endforeach
                </div>

                @if(!empty($ads))
                    <div class="ub-panel" style="margin-top:1rem;">
                        <div class="body">
                            @foreach($ads as $ad)
                                @if($ad['link'])
                                    <a class="item" href="{{$ad['link']}}" target="_blank">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </a>
                                @else
                                    <div class="item">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
        </div>

    </div>

@endsection





