<?php
 namespace Module\Product\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\HtmlUtil; use Module\Product\Util\ProductUtil; class ProductController extends Controller { public function latest() { $input = InputPackage::buildFromInput(); $limit = $input->getInteger('limit', 5); $records = ProductUtil::listLatest($limit); return Response::generateSuccessPaginateData(1, count($records), $records, count($records)); } public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = $input->getPageSize(); $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $categoryId = $input->getInteger('categoryId'); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('product', $page, $pageSize, $option); $records = ProductUtil::buildRecords($paginateData['records']); return Response::generateSuccessData([ 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'records' => $records, ]); } public function get() { $id = InputPackage::buildFromInput()->getInteger('id'); $record = ProductUtil::get($id); $item = ProductUtil::buildRecord($record); $item['cover'] = $record['cover']; $item['content'] = $record['content']; return Response::generateSuccessData($item); } }