<?php
 namespace Module\Vendor\Web\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Artisan; use Illuminate\Support\Facades\DB; use Illuminate\Support\Str; use ModStart\Admin\Auth\Admin; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\CurlUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Module\ModuleManager; use PDO; class InstallController extends Controller { public function lock() { $installLockFile = storage_path('install.lock'); if (file_exists($installLockFile)) { return Response::send(0, 'install lock error -_-'); } file_put_contents($installLockFile, 'lock'); return Response::send(0, 'install lock ok ^_^'); } public function ping() { try { $exitCode = Artisan::call("env"); $output = trim(Artisan::output()); if (0 == $exitCode && Str::contains($output, 'Current application environment')) { return 'ok'; } return 'ERROR: code=' . $exitCode . ', msg:' . $output; } catch (\Exception $e) { return 'ERROR:' . $e->getMessage(); } } public function prepare() { if (file_exists(storage_path('install.lock'))) { return Response::jsonError("系统不能重复安装（请删除install.lock文件后重试）"); } $input = InputPackage::buildFromInput(); $dbHost = $input->getTrimString('db_host'); $dbDatabase = $input->getTrimString('db_database'); $dbUsername = $input->getTrimString('db_username'); $dbPassword = $input->getTrimString('db_password', ''); $dbPrefix = $input->getTrimString('db_prefix', ''); $username = $input->getTrimString('username'); $password = $input->getTrimString('password'); $installDemo = $input->getBoolean('installDemo'); $installLicense = $input->getBoolean('installLicense'); if (empty($dbHost)) { return Response::jsonError("数据库主机名不能为空"); } if (empty($dbDatabase)) { return Response::jsonError("数据库数据库不能为空"); } if (empty($dbUsername)) { return Response::jsonError("数据库用户明不能为空"); } if (empty($username)) { return Response::jsonError("管理用户不能为空"); } if (empty($password)) { return Response::jsonError("管理用户密码不能为空"); } if (file_exists(base_path('license.txt')) && !$installLicense) { return Response::jsonError("请先同意《软件安装许可协议》"); } try { new PDO("mysql:host=$dbHost;dbname=$dbDatabase", $dbUsername, $dbPassword); } catch (\Exception $e) { return Response::jsonError('连接数据信息 ' . $dbHost . '.' . $dbDatabase . ' 失败!'); } $envContent = file_get_contents(base_path('env.example')); $envContent = preg_replace("/DB_HOST=(.*?)\\n/", "DB_HOST=" . $dbHost . "\n", $envContent); $envContent = preg_replace("/DB_DATABASE=(.*?)\\n/", "DB_DATABASE=" . $dbDatabase . "\n", $envContent); $envContent = preg_replace("/DB_USERNAME=(.*?)\\n/", "DB_USERNAME=" . $dbUsername . "\n", $envContent); $envContent = preg_replace("/DB_PASSWORD=(.*?)\\n/", "DB_PASSWORD=" . $dbPassword . "\n", $envContent); $envContent = preg_replace("/DB_PREFIX=(.*?)\\n/", "DB_PREFIX=" . $dbPrefix . "\n", $envContent); $envContent = preg_replace("/APP_KEY=(.*?)\\n/", "APP_KEY=" . RandomUtil::string(32) . "\n", $envContent); file_put_contents(base_path('.env'), $envContent); return Response::jsonSuccess(); } public function execute() { if (file_exists(storage_path('install.lock'))) { return Response::jsonError("系统不能重复安装（请删除install.lock文件后重试）"); } $input = InputPackage::buildFromInput(); $username = $input->getTrimString("username"); $password = $input->getTrimString("password"); $installDemo = $input->getBoolean('installDemo'); if (empty($username)) { return Response::jsonError("管理用户名为空"); } if (empty($password)) { return Response::jsonError("管理用户密码为空"); } $exitCode = Artisan::call("migrate"); if (0 != $exitCode) { return Response::jsonError("安装错误 exitCode($exitCode)"); } $adminUserCount = ModelUtil::count('admin_user'); if ($adminUserCount === 0) { Admin::add($username, $password); } foreach (ModuleManager::listAllInstalledModulesInRequiredOrder() as $module) { if (!ModuleManager::isExists($module)) { continue; } $ret = ModuleManager::install($module); if (Response::isError($ret)) { return Response::generateError($ret['msg']); } } if ($installDemo && file_exists($file = public_path('data_demo/data.php'))) { $data = include($file); if (!empty($data['inserts'])) { foreach ($data['inserts'] as $table => $records) { ModelUtil::insertAll($table, $records); } } if (!empty($data['updates'])) { foreach ($data['updates'] as $record) { DB::table($record['table'])->where($record['where'])->update($record['update']); } } } file_put_contents(storage_path('install.lock'), 'lock'); return Response::json(0, '安装成功，点击即将跳转到管理后台', null, '/admin'); } }