<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace app\admin\controller;
use think\Db;
use think\Cache;
use think\Request;
use think\Page;

class System extends Base
{
    // 选项卡是否显示
    public $tabase = '';
    
    public function _initialize() {
        parent::_initialize();
        $this->tabase = input('param.tabase/d');
    }

    public function index()
    {
        $this->redirect(url('System/web'));
    }

    /**
     * 网站设置
     */
    public function web()
    {
        $inc_type =  'web';

        if (IS_POST) {
            $param = input('post.');
            $param['web_keywords'] = str_replace('，', ',', $param['web_keywords']);
            $param['web_description'] = filter_line_return($param['web_description']);
            
            if (1 == $param['web_status']) {
                /*多语言*/
                if (is_language()) {
                    $langRow = \think\Db::name('language')->order('id asc')
                        ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                        ->select();
                    foreach ($langRow as $key => $val) {
                        tpCache('seo',['seo_pseudo'=>1],$val['mark']);
                    }
                } else {
                    tpCache('seo',['seo_pseudo'=>1]);
                }
                /*--end*/
                @unlink('./index.html');
            }

            // 网站根网址
            $web_basehost = rtrim($param['web_basehost'], '/');
            if (!is_http_url($web_basehost) && !empty($web_basehost)) {
                $web_basehost = $this->request->scheme().'://'.$web_basehost;
            }
            $param['web_basehost'] = $web_basehost;

            // 网站logo
            $web_logo_is_remote = !empty($param['web_logo_is_remote']) ? $param['web_logo_is_remote'] : 0;
            $web_logo = '';
            if ($web_logo_is_remote == 1) {
                $web_logo = $param['web_logo_remote'];
            } else {
                $web_logo = $param['web_logo_local'];
            }
            $param['web_logo'] = $web_logo;
            unset($param['web_logo_is_remote']);
            unset($param['web_logo_remote']);
            unset($param['web_logo_local']);

            // 浏览器地址图标
            if (!empty($param['web_ico']) && !is_http_url($param['web_ico'])) {
                $source = realpath(preg_replace('#^'.$this->root_dir.'/#i', '', $param['web_ico']));
                $destination = realpath('favicon.ico');
                if (file_exists($source) && @copy($source, $destination)) {
                    $param['web_ico'] = $this->root_dir.'/favicon.ico';
                }
            }

            tpCache($inc_type, $param);
            write_global_params($this->admin_lang); // 写入全局内置参数
            $this->success('操作成功', url('System/web'));
            exit;
        }

        $config = tpCache($inc_type);
        // 网站logo
        if (is_http_url($config['web_logo'])) {
            $config['web_logo_is_remote'] = 1;
            $config['web_logo_remote'] = handle_subdir_pic($config['web_logo']);
        } else {
            $config['web_logo_is_remote'] = 0;
            $config['web_logo_local'] = handle_subdir_pic($config['web_logo']);
        }

        $config['web_ico'] = preg_replace('#^(/[/\w]+)?(/)#i', $this->root_dir.'$2', $config['web_ico']); // 支持子目录
        
        /*系统模式*/
        $web_cmsmode = isset($config['web_cmsmode']) ? $config['web_cmsmode'] : 2;
        $this->assign('web_cmsmode', $web_cmsmode);
        /*--end*/

        /*自定义变量*/
        $eyou_row = M('config_attribute')->field('a.attr_id, a.attr_name, a.attr_var_name, a.attr_input_type, b.value, b.id, b.name')
            ->alias('a')
            ->join('__CONFIG__ b', 'b.name = a.attr_var_name AND b.lang = a.lang', 'LEFT')
            ->where([
                'b.lang'    => $this->admin_lang,
                'a.inc_type'    => $inc_type,
                'b.is_del'  => 0,
            ])
            ->order('a.attr_id asc')
            ->select();
        foreach ($eyou_row as $key => $val) {
            $val['value'] = handle_subdir_pic($val['value'], 'html'); // 支持子目录
            $val['value'] = handle_subdir_pic($val['value']); // 支持子目录
            $eyou_row[$key] = $val;
        }
        $this->assign('eyou_row',$eyou_row);
        /*--end*/

        $this->assign('config',$config);//当前配置项
        $this->assign('seo_pseudo', tpCache('seo.seo_pseudo')); // URL模式
        return $this->fetch();
    }

    /**
     * 核心设置
     */
    public function web2()
    {
        $this->language_access(); // 多语言功能操作权限

        $inc_type = 'web';

        if (IS_POST) {
            $param = input('post.');

            if (1 == $param['web_mobile_domain_open']) {
                $web_mobile_domain = trim($param['web_mobile_domain']);
                if (!empty($web_mobile_domain) && ($web_mobile_domain == 'www' || $web_mobile_domain == $this->request->subDomain())) {
                    $this->error("手机站域名配置不能与主站域名一致！");
                }
            } else {
                unset($param['web_mobile_domain']);
            }

            /*EyouCMS安装目录*/
            empty($param['web_cmspath']) && $param['web_cmspath'] = $this->root_dir; // 支持子目录
            $web_cmspath = trim($param['web_cmspath'], '/');
            $web_cmspath = !empty($web_cmspath) ? '/'.$web_cmspath : '';
            $param['web_cmspath'] = $web_cmspath;
            /*--end*/
            /*插件入口*/
            $web_weapp_switch = $param['web_weapp_switch'];
            $web_weapp_switch_old = tpCache('web.web_weapp_switch');
            /*--end*/
            /*自定义后台路径名*/
            $adminbasefile = trim($param['adminbasefile']).'.php'; // 新的文件名
            $param['web_adminbasefile'] = $this->root_dir.'/'.$adminbasefile; // 支持子目录
            $adminbasefile_old = trim($param['adminbasefile_old']).'.php'; // 旧的文件名
            unset($param['adminbasefile']);
            unset($param['adminbasefile_old']);
            if ('index.php' == $adminbasefile) {
                $this->error("后台路径禁止使用index", null, '', 1);
            }
            /*--end*/
            $param['web_sqldatapath'] = '/'.trim($param['web_sqldatapath'], '/'); // 数据库备份目录
            $param['web_htmlcache_expires_in'] = intval($param['web_htmlcache_expires_in']); // 页面缓存有效期

            /*后台LOGO*/
            $web_adminlogo = $param['web_adminlogo'];
            $web_adminlogo_old = tpCache('web.web_adminlogo');
            if ($web_adminlogo != $web_adminlogo_old && !empty($web_adminlogo)) {
                $source = preg_replace('#^'.$this->root_dir.'#i', '', $web_adminlogo); // 支持子目录
                $web_is_authortoken = tpCache('web.web_is_authortoken');
                if (-1 == $web_is_authortoken) {
                    $destination = '/public/static/admin/images/logo_ey.png';
                } else {
                    $destination = '/public/static/admin/images/logo.png';
                }

                if (@copy('.'.$source, '.'.$destination)) {
                    $param['web_adminlogo'] = $this->root_dir.$destination;
                }
            }
            /*--end*/

            /*后台登录超时*/
            $web_login_expiretime = $param['web_login_expiretime'];
            $web_login_expiretime = preg_replace('/^(\d{0,})(.*)$/i', '${1}', $web_login_expiretime);
            empty($web_login_expiretime) && $web_login_expiretime = config('login_expire');
            $param['web_login_expiretime'] = $web_login_expiretime;
            /*--end*/

            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type,$param,$val['mark']);
                    write_global_params($val['mark']); // 写入全局内置参数
                }
            } else {
                tpCache($inc_type,$param);
                write_global_params(); // 写入全局内置参数
            }
            /*--end*/

            $refresh = false;
            $gourl = request()->domain().$this->root_dir.'/'.$adminbasefile; // 支持子目录
            /*更改自定义后台路径名*/
            if ($adminbasefile_old != $adminbasefile && eyPreventShell($adminbasefile_old)) {
                if (file_exists($adminbasefile_old)) {
                    if(rename($adminbasefile_old, $adminbasefile)) {
                        $refresh = true;
                    }
                } else {
                    $this->error("根目录{$adminbasefile_old}文件不存在！", null, '', 2);
                }
            }
            /*--end*/

            /*更改之后，需要刷新后台的参数*/
            if (false && $web_weapp_switch_old != $web_weapp_switch) {
                $refresh = true;
            }
            /*--end*/
            
            /*刷新整个后台*/
            if ($refresh) {
                $this->success('操作成功', $gourl, '', 1, [], '_parent');
            }
            /*--end*/

            $this->success('操作成功', url('System/web2'));
        }

        $config = tpCache($inc_type);
        // 当前主域名
        $this->assign('subDomain', $this->request->subDomain());
        //自定义后台路径名
        $baseFile = explode('/', $this->request->baseFile());
        $web_adminbasefile = end($baseFile);
        $adminbasefile = preg_replace('/^(.*)\.([^\.]+)$/i', '$1', $web_adminbasefile);
        $this->assign('adminbasefile', $adminbasefile);
        // 数据库备份目录
        $sqlbackuppath = config('DATA_BACKUP_PATH');
        $this->assign('sqlbackuppath', $sqlbackuppath);
        // 后台logo
        if (-1 == $config['web_is_authortoken']) {
            $config['web_adminlogo'] = $this->root_dir.'/public/static/admin/images/logo_ey.png';
        } else {
            $config['web_adminlogo'] = $this->root_dir.'/public/static/admin/images/logo.png';
        }
        // 当前域名是否IP或者localhost本地
        $is_localhost = 0;
        if (preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/i', $this->request->host(true)) || 'localhost' == $this->request->host(true)) {
            $is_localhost = 1;
        }
        $this->assign('is_localhost',$is_localhost);

        $this->assign('config',$config);//当前配置项
        return $this->fetch();
    }

    /**
     * 附件设置
     */
    public function basic()
    {
        $inc_type =  'basic';

        // 文件上传最大限制
        $maxFileupload = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 0;
        if (0 !== $maxFileupload) {
            $max_filesize = unformat_bytes($maxFileupload);
            $max_filesize = $max_filesize / 1024 / 1024; // 单位是MB的大小
        } else {
            $max_filesize = 500;
        }
        $max_sizeunit = 'MB';
        $maxFileupload = $max_filesize.$max_sizeunit;

        if (IS_POST) {
            $param = input('post.');
            $param['file_size'] = intval($param['file_size']);

            if (0 < $max_filesize && $max_filesize < $param['file_size']) {
                $this->error("附件上传大小超过空间的最大限制".$maxFileupload);
            }

            // 过滤php扩展名的附件类型
            $image_type = explode('|', $param['image_type']);
            foreach ($image_type as $key => $val) {
                $val = trim($val);
                if (stristr($val, 'php') || empty($val)) {
                    unset($image_type[$key]);
                }
            }
            $param['image_type'] = implode('|', $image_type);

            $file_type = explode('|', $param['file_type']);
            foreach ($file_type as $key => $val) {
                $val = trim($val);
                if (stristr($val, 'php') || empty($val)) {
                    unset($file_type[$key]);
                }
            }
            $param['file_type'] = implode('|', $file_type);

            $media_type = explode('|', $param['media_type']);
            foreach ($media_type as $key => $val) {
                $val = trim($val);
                if (stristr($val, 'php') || empty($val)) {
                    unset($media_type[$key]);
                }
            }
            $param['media_type'] = implode('|', $media_type);
            /*end*/

            /*多语言*/
            if (is_language()) {
                $newParam['basic_indexname'] = $param['basic_indexname'];
                tpCache($inc_type,$newParam);

                $synLangParam = $param; // 同步更新多语言的数据
                unset($synLangParam['basic_indexname']);
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $synLangParam, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            /*--end*/
            $this->success('操作成功', url('System/basic'));
        }

        $config = tpCache($inc_type);
        $this->assign('config',$config);//当前配置项
        $this->assign('max_filesize',$max_filesize);// 文件上传最大字节数
        $this->assign('max_sizeunit',$max_sizeunit);// 文件上传最大字节的单位
        return $this->fetch();
    }

    /**
     * 图片水印
     */
    public function water()
    {
        $this->language_access(); // 多语言功能操作权限

        $inc_type =  'water';

        if (IS_POST) {
            $param = input('post.');
            $tabase = input('post.tabase/d');
            unset($param['tabase']);

            $mark_img_is_remote = !empty($param['mark_img_is_remote']) ? $param['mark_img_is_remote'] : 0;
            $mark_img = '';
            if ($mark_img_is_remote == 1) {
                $mark_img = $param['mark_img_remote'];
            } else {
                $mark_img = $param['mark_img_local'];
            }
            $param['mark_img'] = $mark_img;
            unset($param['mark_img_is_remote']);
            unset($param['mark_img_remote']);
            unset($param['mark_img_local']);

            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $param, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            /*--end*/
            $this->success('操作成功', url('System/'.$inc_type, ['tabase'=>$tabase]));
        }

        $config = tpCache($inc_type);
        if (is_http_url($config['mark_img'])) {
            $config['mark_img_is_remote'] = 1;
            $config['mark_img_remote'] = handle_subdir_pic($config['mark_img']);
        } else {
            $config['mark_img_is_remote'] = 0;
            $config['mark_img_local'] = handle_subdir_pic($config['mark_img']);
        }

        $this->assign('config',$config);//当前配置项
        return $this->fetch();
    }

    /**
     * 缩略图配置
     */
    public function thumb()
    {
        $this->language_access(); // 多语言功能操作权限

        $inc_type =  'thumb';

        if (IS_POST) {
            $param = input('post.');
            $tabase = input('post.tabase/d');
            unset($param['tabase']);
            isset($param['thumb_width']) && $param['thumb_width'] = preg_replace('/[^0-9]/', '', $param['thumb_width']);
            isset($param['thumb_height']) && $param['thumb_height'] = preg_replace('/[^0-9]/', '', $param['thumb_height']);

            $thumbConfig = tpCache('thumb'); // 旧数据

            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $param, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            /*--end*/

            /*校验配置是否改动，若改动将会清空缩略图目录*/
            unset($param['__token__']);
            if (md5(serialize($param)) != md5(serialize($thumbConfig))) {
                delFile(RUNTIME_PATH.'html'); // 清空缓存页面
                delFile(UPLOAD_PATH.'thumb'); // 清空缩略图
            }
            /*--end*/

            $this->success('操作成功', url('System/'.$inc_type, ['tabase'=>$tabase]));
        }

        $config = tpCache($inc_type);

        // 设置缩略图默认配置
        if (!isset($config['thumb_open'])) {
            /*多语言*/
            $thumbextra = config('global.thumb');
            $param = [
                'thumb_open'    => $thumbextra['open'],
                'thumb_mode'    => $thumbextra['mode'],
                'thumb_color'   => $thumbextra['color'],
                'thumb_width'   => $thumbextra['width'],
                'thumb_height'  => $thumbextra['height'],
            ];
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $param, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            $config = tpCache($inc_type);
            /*--end*/
        }

        $this->assign('config',$config);//当前配置项
        return $this->fetch();
    }

    /**
     * 短信配置
     */
    public function sms()
    {
        $inc_type =  'sms';

        if (IS_POST) {
            $param = input('post.');
            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $param, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            /*--end*/
            $this->success('操作成功', url('System/sms'));
        }

        $config = tpCache($inc_type);
        $this->assign('config',$config);//当前配置项
        return $this->fetch();
    }

    /**
     * 邮件配置
     */
    public function smtp()
    {
        $inc_type =  'smtp';

        if (IS_POST) {
            $param = input('post.');
            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache($inc_type, $param, $val['mark']);
                }
            } else {
                tpCache($inc_type,$param);
            }
            /*--end*/
            $iframes = input('param.iframes/d');
            $this->success('操作成功', url('System/smtp', ['iframes'=>$iframes]));
        }

        $config = tpCache($inc_type);
        $this->assign('config',$config);//当前配置项
        /*是否弹窗显示*/
        $iframes = input('param.iframes/d');
        $this->assign('iframes',$iframes);
        /*end*/
        return $this->fetch();
    }

    /**
     * 邮件模板列表
     */
    public function smtp_tpl()
    {
        $list = array();
        $keywords = input('keywords/s');

        $map = array();
        if (!empty($keywords)) {
            $map['tpl_name'] = array('LIKE', "%{$keywords}%");
        }

        // 多语言
        $map['lang'] = array('eq', $this->admin_lang);

        $count = Db::name('smtp_tpl')->where($map)->count('tpl_id');// 查询满足要求的总记录数
        $pageObj = new Page($count, config('paginate.list_rows'));// 实例化分页类 传入总记录数和每页显示的记录数
        $list = Db::name('smtp_tpl')->where($map)
            ->order('tpl_id asc')
            ->limit($pageObj->firstRow.','.$pageObj->listRows)
            ->select();
        $pageStr = $pageObj->show(); // 分页显示输出
        $this->assign('list', $list); // 赋值数据集
        $this->assign('pageStr', $pageStr); // 赋值分页输出
        $this->assign('pageObj', $pageObj); // 赋值分页对象
        
        return $this->fetch();
    }
    
    /**
     * 邮件模板列表 - 编辑
     */
    public function smtp_tpl_edit()
    {
        if (IS_POST) {
            $post = input('post.');
            $post['tpl_id'] = eyIntval($post['tpl_id']);
            if(!empty($post['tpl_id'])){
                $post['tpl_title'] = trim($post['tpl_title']);

                /*组装存储数据*/
                $nowData = array(
                    'update_time'   => getTime(),
                );
                $saveData = array_merge($post, $nowData);
                /*--end*/
                
                $r = Db::name('smtp_tpl')->where([
                        'tpl_id'    => $post['tpl_id'],
                        'lang'      => $this->admin_lang,
                    ])->update($saveData);
                if ($r) {
                    $tpl_name = Db::name('smtp_tpl')->where([
                            'tpl_id'    => $post['tpl_id'],
                            'lang'      => $this->admin_lang,
                        ])->getField('tpl_name');
                    adminLog('编辑邮件模板：'.$tpl_name); // 写入操作日志
                    $this->success("操作成功", url('System/smtp_tpl'));
                }
            }
            $this->error("操作失败");
        }

        $id = input('id/d', 0);
        $row = Db::name('smtp_tpl')->where([
                'tpl_id'    => $id,
                'lang'      => $this->admin_lang,
            ])->find();
        if (empty($row)) {
            $this->error('数据不存在，请联系管理员！');
            exit;
        }

        $this->assign('row',$row);
        return $this->fetch();
    }

    /**
     * 清空缓存 - 兼容升级没刷新后台，点击报错404，过1.2.5版本之后清除掉代码
     */
    public function clearCache()
    {
        return $this->clear_cache();
    }

    /**
     * 清空缓存
     */
    public function clear_cache()
    {
        if (IS_POST) {
            if (!function_exists('unlink')) {
                $this->error('php.ini未开启unlink函数，请联系空间商处理！');
            }

            $post = input('post.');

            if (!empty($post['clearHtml'])) { // 清除页面缓存
                $this->clearHtmlCache($post['clearHtml']);
            }

            if (!empty($post['clearCache'])) { // 清除数据缓存
                $this->clearSystemCache($post['clearCache']);
            }

            // 清除其他临时文件
            $this->clearOtherCache();

            /*兼容每个用户的自定义字段，重新生成数据表字段缓存文件*/
            $systemTables = ['arctype'];
            $data = Db::name('channeltype')
                ->where('nid','NEQ','guestbook')
                ->column('table');
            $tables = array_merge($systemTables, $data);
            foreach ($tables as $key => $table) {
                if ('arctype' != $table) {
                    $table = $table.'_content';
                }
                try {
                    schemaTable($table);
                } catch (\Exception $e) {}
            }
            /*--end*/

            /*清除旧升级备份包，保留最后一个备份文件*/
            $backupArr = glob(DATA_PATH.'backup/v*_www');
            for ($i=0; $i < count($backupArr) - 1; $i++) { 
                delFile($backupArr[$i], true);
            }

            $backupArr = glob(DATA_PATH.'backup/*');
            foreach ($backupArr as $key => $filepath) {
                if (file_exists($filepath) && !stristr($filepath, '.htaccess') && !stristr($filepath, '_www')) {
                    if (is_dir($filepath)) {
                        delFile($filepath, true);
                    } else if (is_file($filepath)) {
                        @unlink($filepath);
                    }
                }
            }
            /*--end*/

            // cache('admin_ModuleInitBehavior_isset_checkInlet', 1); // 配合ModuleInitBehavior.php行为的checkInlet方法，进行自动隐藏index.php

            $request = Request::instance();
            $gourl = $request->baseFile();
            $lang = $request->param('lang/s');
            if (!empty($lang) && $lang != get_main_lang()) {
                $gourl .= "?lang={$lang}";
            }
            $this->success('操作成功', $gourl, '', 1, [], '_parent');
        }
        
        return $this->fetch();
    }

    /**
     * 清空数据缓存
     */
    public function fastClearCache($arr = array())
    {
        $this->clearSystemCache();
        $script = "<script>parent.layer.msg('操作成功', {time:3000,icon: 1});window.location='".url('Index/welcome')."';</script>";
        echo $script;
    }

    /**
     * 清空数据缓存
     */
    public function clearSystemCache($arr = array())
    {
        if (empty($arr)) {
            delFile(rtrim(RUNTIME_PATH, '/'), true);
        } else {
            foreach ($arr as $key => $val) {
                delFile(RUNTIME_PATH.$val, true);
            }
        }

        /*多语言*/
        if (is_language()) {
            $langRow = Db::name('language')->order('id asc')
                ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                ->select();
            foreach ($langRow as $key => $val) {
                tpCache('global', '', $val['mark']);
            }
        } else { // 单语言
            tpCache('global');
        }
        /*--end*/

        return true;
    }

    /**
     * 清空页面缓存
     */
    public function clearHtmlCache($arr = array())
    {
        if (empty($arr)) {
            delFile(rtrim(HTML_ROOT, '/'), true);
        } else {
            $seo_pseudo = tpCache('seo.seo_pseudo');
            foreach ($arr as $key => $val) {
                $fileList = glob(HTML_ROOT.'http*/'.$val.'*');
                if (!empty($fileList)) {
                    foreach ($fileList as $k2 => $v2) {
                        if (file_exists($v2) && is_dir($v2)) {
                            delFile($v2, true);
                        } else if (file_exists($v2) && is_file($v2)) {
                            @unlink($v2);
                        }
                    }
                }
                if ($val == 'index' && 2 != $seo_pseudo) {
                    foreach (['index.html','indexs.html'] as $sk1 => $sv1) {
                        $filename = ROOT_PATH.$sv1;
                        if (file_exists($filename)) {
                            @unlink($filename);
                        }
                    }
                }
            }
        }
    }

    /**
     * 清除其他临时文件
     */
    private function clearOtherCache()
    {
        $arr = [
            'template',
        ];
        foreach ($arr as $key => $val) {
            delFile(RUNTIME_PATH.$val, true);
        }

        return true;
    }
      
    /**
     * 发送测试邮件
     */
    public function send_email()
    {
        $param = $smtp_config = input('post.');
        $title = '演示标题';
        $content = '演示一串随机数字：' . mt_rand(100000,999999);
        $res = send_email($param['smtp_from_eamil'], $title, $content, 0, $smtp_config);
        if (intval($res['code']) == 1) {
            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache('smtp', $smtp_config, $val['mark']);
                }
            } else {
                tpCache('smtp',$smtp_config);
            }
            /*--end*/
            $this->success($res['msg']);
        } else {
            $this->error($res['msg']);
        }
    }
      
    /**
     * 发送测试短信
     */
    public function send_mobile()
    {
        $param = $sms_config = input('post.');
        $res = sendSms(4,$param['sms_test_mobile'],array('content'=>mt_rand(1000,9999)));
        if (intval($res['code']) == 1) {
            /*多语言*/
            if (is_language()) {
                $langRow = \think\Db::name('language')->order('id asc')
                    ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                    ->select();
                foreach ($langRow as $key => $val) {
                    tpCache('sms', $sms_config, $val['mark']);
                }
            } else {
                tpCache('sms',$sms_config);
            }
            /*--end*/
            $this->success($res['msg']);
        } else {
            $this->error($res['msg']);
        }
    }

    /**
     * 自定义变量列表
     */
    public function customvar_index()
    {
        $list = array();
        $keywords = input('keywords/s');

        $condition = array();
        // 应用搜索条件
        if (!empty($keywords)) {
            $condition['a.attr_name'] = array('LIKE', "%{$keywords}%");
        }
        // 多语言
        $condition['a.lang'] = array('eq', $this->admin_lang);

        $attr_var_names = M('config')->field('name')
            ->where([
                'name'  => ['LIKE', "web_attr_%"],
                'lang'  => $this->admin_lang,
                'is_del'    => 0,
            ])->getAllWithIndex('name');
        $condition['a.attr_var_name'] = array('IN', array_keys($attr_var_names));

        $count = M('config_attribute')->alias('a')->where($condition)->count();// 查询满足要求的总记录数
        $pageObj = new Page($count, 100);// 实例化分页类 传入总记录数和每页显示的记录数
        $list = M('config_attribute')->alias('a')
            ->field('a.*, b.id')
            ->join('__CONFIG__ b', 'b.name = a.attr_var_name AND b.lang = a.lang', 'LEFT')
            ->where($condition)
            ->order('a.attr_id asc')
            ->limit($pageObj->firstRow.','.$pageObj->listRows)
            ->select();

        $pageStr = $pageObj->show();// 分页显示输出
        $this->assign('pageStr',$pageStr);// 赋值分页输出
        $this->assign('list',$list);// 赋值数据集
        $this->assign('pageObj',$pageObj);// 赋值分页对象

        return $this->fetch();
    }

    /**
     * 保存自定义变量
     */
    public function customvar_save()
    {
        if (IS_AJAX_POST) {
            $post = input('post.');

            if (empty($post['attr_name'])) {
                $this->error('至少新增一个自定义变量！');
            }

            // 数据拼装
            $addData = $editData = [];
            foreach ($post['attr_name'] as $key => $val) {
                $attr_name  = trim($val);
                $attr_input_type = intval($post['attr_input_type'][$key]);
                if (empty($post['attr_id'][$key])) {
                    if ($this->admin_lang == $this->main_lang) {
                        $addData[] = [
                            'inc_type'  => 'web',
                            'attr_name'  => $attr_name,
                            'attr_input_type' => $attr_input_type,
                            'lang'  => $this->admin_lang,
                            'add_time' => getTime(),
                        ];
                    }
                } else {
                    $attr_id = intval($post['attr_id'][$key]);
                    $editData[] = [
                        'attr_id'  => $attr_id,
                        'inc_type'  => 'web',
                        'attr_name'  => $attr_name,
                        'attr_input_type' => $attr_input_type,
                        'lang'  => $this->admin_lang,
                        'update_time' => getTime(),
                    ];
                }
            }
            if (!empty($addData)) {
                $rdata = model('ConfigAttribute')->saveAll($addData);
                if ($rdata) {
                    foreach ($rdata as $k1 => $v1) {
                        $attr_id = $v1->getData('attr_id');
                        $addData[$k1]['attr_id'] = $attr_id;
                        $addData[$k1]['attr_var_name'] = 'web_attr_'.$attr_id;
                        $addData[$k1]['update_time'] = getTime();
                        unset($addData[$k1]['add_time']);
                    }
                    $editData = array_merge($editData, $addData);
                }

                /*多语言*/
                $langRow = [];
                if (is_language()) {
                    $langAddData = [];
                    $langRow = Db::name('language')->order('id asc')
                        ->cache(true, EYOUCMS_CACHE_TIME, 'language')
                        ->select();
                    foreach ($langRow as $key => $val) {
                        if ($this->admin_lang == $val['mark']) {
                            continue;
                        }

                        foreach ($rdata as $k1 => $v1) {
                            $attr_data = $v1->getData();
                            $attr_data['lang'] = $val['mark'];
                            $attr_data['attr_var_name'] = 'web_attr_'.$attr_data['attr_id'];
                            unset($attr_data['attr_id']);
                            $langAddData[] = $attr_data;
                        }
                    }
                    !empty($langAddData) && model('ConfigAttribute')->saveAll($langAddData);
                }
                /*end*/
            }
            if (!empty($editData)) {
                $r = model('ConfigAttribute')->saveAll($editData);
                if ($r) {
                    // 新增到config表，更新缓存
                    if (!empty($addData)) {
                        $configData = [];
                        foreach ($addData as $key => $val) {
                            $configData[$val['attr_var_name']] = '';
                        }
                        // 多语言
                        if (is_language()) {
                            foreach ($langRow as $key => $val) {
                                tpCache('web', $configData, $val['mark']);
                            }
                        } else { // 单语言
                            tpCache('web', $configData);
                        }
                    }
                    // end

                    adminLog('保存自定义变量：'.implode(',', $post['attr_name']));
                    $this->success('操作成功', url('System/web'));
                } else {
                    $this->error('操作失败');
                }
            } 
        }
        $this->error('非法访问！');
    }

    /**
     * 删除自定义变量
     */
    public function customvar_del()
    {
        $this->language_access(); // 多语言功能操作权限

        $id = input('del_id/d');
        if(!empty($id)){
            $attr_var_name = M('config')->where([
                    'id'    => $id,
                    'lang'  => $this->admin_lang,
                ])->getField('name');

            $r = M('config')->where('name', $attr_var_name)->update(array('is_del'=>1, 'update_time'=>getTime()));
            if($r){
                M('config_attribute')->where('attr_var_name', $attr_var_name)->update(array('update_time'=>getTime()));
                adminLog('删除自定义变量：'.$attr_var_name);
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }else{
            $this->error('参数有误');
        }
    }

    /**
     * 标签调用的弹窗说明
     */
    public function ajax_tag_call()
    {
        $space = "&nbsp;&nbsp;&nbsp;&nbsp;";
        if (IS_AJAX_POST) {
            $name = input('post.name/s');
            $msg = '';
            switch ($name) {
                case 'web_users_switch': // 会员功能入口标签
                    {
$msg_code = <<<EOF
{eyou:user type='open'}  <br>
{$space}{eyou:user type='cart'} <br>
{$space}{$space}&lt;a href="{\$field.url}" id="{\$field.id}" &gt;购物车&lt;/a&gt; <br>
{$space}{$space}{\$field.hidden} <br>
{$space}{/eyou:user} <br>
     <br>
{$space}{eyou:user type='login'} <br>
{$space}{$space}&lt;a href="{\$field.url}" id="{\$field.id}" &gt;登录&lt;/a&gt; <br>
{$space}{$space}{\$field.hidden} <br>
{$space}{/eyou:user} <br>
     <br>
{$space}{eyou:user type='reg'} <br>
{$space}{$space}&lt;a href="{\$field.url}" id="{\$field.id}" &gt;注册&lt;/a&gt; <br>
{$space}{$space}{\$field.hidden} <br>
{$space}{/eyou:user} <br>
     <br>
{$space}{eyou:user type='logout'} <br>
{$space}{$space}&lt;a href="{\$field.url}" id="{\$field.id}" &gt;退出&lt;/a&gt; <br>
{$space}{$space}{\$field.hidden} <br>
{$space}{/eyou:user}   <br>
{/eyou:user}
EOF;

$msg = <<<EOF
<strong>前台会员登录注册标签调用</strong><br>
比如需要在PC通用头部加入会员入口，复制下方代码在/template/pc/header.htm模板文件里找到合适位置粘贴
<br/><br/>
<div style="color:red">
{$msg_code}
</div>
EOF;
                    }
                    break;

                case 'web_language_switch': // 多语言入口标签
                    {
$msg = <<<EOF
<strong>前台多语言切换入口标签调用</strong><br>
比如需要在PC通用头部加入多语言切换，复制下方代码在/template/pc/header.htm模板文件里找到合适位置粘贴
<br/><br/>
<div style="color:red">
{eyou:language type='default'}<br/>
{$space}&lt;a href="{\$field.url}"&gt;&lt;img src="{\$field.logo}" alt="{\$field.title}"&gt;{\$field.title}&lt;/a&gt;<br/>
{/eyou:language}
</div>
EOF;
                    }
                    break;

                case 'thumb_open':
                    {
$msg = <<<EOF
<span style="color:red">（温馨提示：高级调用不会受缩略图功能的开关影响！）</span><br/>
【标签方法的格式】<br/>
{$space}thumb_img=###,宽度,高度,生成方式<br/>
<br/>
【指定宽高度的调用】<br/>
{$space}列表页/内容页：{\$eyou.field.litpic<span style="color:red">|thumb_img=###,500,500</span>}<br/>
{$space}标签arclist/list里：{\$field.litpic<span style="color:red">|thumb_img=###,500,500</span>}<br/>
<br/>
【指定生成方式的调用】<br/>
{$space}生成方式：1 = 拉伸；2 = 留白；3 = 截减；<br/>
{$space}以标签arclist为例：<br/>
{$space}{$space}缩略图拉伸：{\$field.litpic<span style="color:red">|thumb_img=###,500,500,1</span>}<br/>
{$space}{$space}缩略图留白：{\$field.litpic<span style="color:red">|thumb_img=###,500,500,2</span>}<br/>
{$space}{$space}缩略图截减：{\$field.litpic<span style="color:red">|thumb_img=###,500,500,3</span>}<br/>
{$space}{$space}默&nbsp;认&nbsp;生&nbsp;成：{\$field.litpic<span style="color:red">|thumb_img=###,500,500</span>}{$space}(以默认全局配置的生成方式)<br/>
EOF;
                    }
                    break;
                
                case 'shop_open':
                    {
$msg_code = <<<EOF
&lt;!--购物车组件start--&gt; <br/>
{eyou:sppurchase id='field' currentstyle='btn-danger'} <br/>
{$space}&lt;!-- 价格 标签开始 --&gt;  <br/>
{$space}&lt;div class="ey-price"&gt;&lt;span&gt;￥{\$field.users_price}&lt;/span&gt; &lt;/div&gt;  <br/>
{$space}&lt;!-- 价格 标签结束 --&gt;  <br/>
     <br/>
{$space}&lt;!-- 规格 标签开始 --&gt; <br/>
{$space}&lt;div class="ey-spec"&gt; <br/>
{$space}{eyou:volist name="\$field.ReturnData" id='field2'} <br/>
{$space}{$space}&lt;div class="row m-t-15"&gt; <br/>
{$space}{$space}{$space}&lt;label class="form-control-label col-sm-7"&gt;{\$field2.spec_name}&lt;/label&gt; <br/>
{$space}{$space}{$space}&lt;div class="col-sm-10"&gt; <br/>
{$space}{$space}{$space}{eyou:volist name="\$field2.spec_value" id='field3'} <br/>
{$space}{$space}{$space}{$space}&lt;a href="JavaScript:void(0);" {\$field3.SpecData} class="btn btn-default btn-selected {\$field3.SpecClass}"&gt;{\$field3.spec_value}&lt;/a&gt; <br/>
{$space}{$space}{$space}{/eyou:volist} <br/>
{$space}{$space}{$space}&lt;/div&gt; <br/>
{$space}{$space}&lt;/div&gt; <br/>
{$space}{/eyou:volist} <br/>
{$space}&lt;/div&gt; <br/>
{$space}&lt;!-- 规格 标签结束 --&gt; <br/>
     <br/>
{$space}&lt;!-- 数量操作 标签开始 --&gt;  <br/>
{$space}&lt;div class="ey-number"&gt;  <br/>
{$space}{$space}&lt;label&gt;数量&lt;/label&gt;  <br/>
{$space}{$space}&lt;div class="btn-input"&gt;  <br/>
{$space}{$space}{$space}&lt;button class="layui-btn" {\$field.ReduceQuantity}&gt;-&lt;/button&gt;  <br/>
{$space}{$space}{$space}&lt;input type="text" class="layui-input" {\$field.UpdateQuantity}&gt;  <br/>
{$space}{$space}{$space}&lt;button class="layui-btn" {\$field.IncreaseQuantity}&gt;+&lt;/button&gt;  <br/>
{$space}{$space}&lt;/div&gt;  <br/>
{$space}&lt;/div&gt;  <br/>
{$space}&lt;!-- 数量操作 标签结束 --&gt;  <br/>
     <br/>
{$space}&lt;!-- 库存量 标签开始 --&gt;  <br/>
{$space}&lt;span {\$field.stock_show}&gt;库存量：{\$field.stock_count} 件&lt;/span&gt;  <br/>
{$space}&lt;!-- 库存量 标签结束 --&gt;  <br/>
     <br/>
{$space}&lt;!-- 购买按钮 标签开始 --&gt;  <br/>
{$space}&lt;div class="ey-buyaction"&gt;  <br/>
{$space}{$space}&lt;a class="ey-joinin" href="JavaScript:void(0);" {\$field.ShopAddCart}&gt;加入购物车&lt;/a&gt;  <br/>
{$space}{$space}&lt;a class="ey-joinbuy" href="JavaScript:void(0);" {\$field.BuyNow}&gt;立即购买&lt;/a&gt; <br/>
{$space}&lt;/div&gt;  <br/>
{$space}&lt;!-- 购买按钮 标签结束 --&gt;  <br/>
     <br/>
{$space}{\$field.hidden}  <br/>
{/eyou:sppurchase}  <br/>
&lt;!--购物车组件end--&gt;
EOF;

// $msg_code = "<pre>".htmlspecialchars($msg_code)."</pre>";

$msg = <<<EOF
<div style="color:red"> 
请手工调用最新版的购买行为入口标签，代码验证通过便可启用
<br/>
复制下方代码在/template/pc/view_product.htm模板文件里找到合适位置粘贴
</div>
<br/>
<div id='ShopOpenCode'>
{$msg_code}
</div>
EOF;
                    }
                    break;

                default:
                    # code...
                    break;
            }
            $this->success('请求成功', null, ['msg'=>$msg]);
        }
        $this->error('非法访问！');
    }
}