<?
class Check
{
		// 参 数：$checkstr，要检测的字符串，$echostr，为空时输出的字符
	  static function CheckEmpty($checkstr,$echostr)
	   {
		  if(empty($checkstr))
		  {
			echo_str($echostr);
		  }
		  else
		  {
			  return replace($checkstr);
		  }
	   }
  // 函数名：CheckMoney($C_Money) 
	// 作 用：检查数据是否是99999.99格式 
	// 参 数：$C_Money（待检测的数字） 
	// 返回值：布尔值 
	static function CheckMoney($C_Money) 
	{ 
	  if (!ereg("^[0-9][.][0-9]$", $C_Money)) return false; 
	  return true; 
	} 


     // 函数名：Money($num) 
	// 作 用：返回两位小数的金额 
	// 参 数：$num（待检测的数字） 
	// 返回值：金额 
    static function Money($num)
	{
	  if(!is_numeric($num))
	  {
		return 0;  
	  }
	  else
	  {
		return number_format($num,2);  
	  }
	}
	// 函数名：CheckEmailAddr($C_mailaddr) 
	// 作 用：判断是否为有效邮件地址 
	// 参 数：$C_mailaddr（待检测的邮件地址） 
	// 返回值：布尔值 
	static function CheckEmail($C_mailaddr) 
	{ 
	  if (!ereg("^[_a-z0-9-]+(.[_a-z0-9-]+)*@[a-z0-9-]+\.([\.a-z0-9-]+)*$",$C_mailaddr)) 
	  { 
	  return false; 
	  } 
	  return true;
	} 
	
	// 函数名：CheckWebAddr($C_weburl) 
	// 作 用：判断是否为有效网址 
	// 参 数：$C_weburl（待检测的网址） 
	// 返回值：布尔值 
	static function CheckWebAddr($C_weburl) 
	{ 
	  if (!ereg("^http://[_a-zA-Z0-9-]+(.[_a-zA-Z0-9-]+)*$", $C_weburl)) 
	  { 
	    return false; 
	  } 
	   return true; 
	} 
	
	// 函数名：CheckLengthBetween($C_char, $I_len1, $I_len2=100) 
	// 作 用：判断是否为指定长度内字符串 
	// 参 数：$C_char（待检测的字符串） 
	// $I_len1 （目标字符串长度的下限） 
	// $I_len2 （目标字符串长度的上限） 
	// 返回值：布尔值 
	static function CheckLength($C_cahr, $I_len1, $I_len2=100) 
	{ 
	  $C_cahr = trim($C_cahr); 
	  if (strlen($C_cahr) < $I_len1) return false; 
	  if (strlen($C_cahr) > $I_len2) return false; 
	  return true; 
	} 
	
	// 函数名：CheckUser($C_user) 
	// 作 用：判断是否为合法用户名 
	// 参 数：$C_user（待检测的用户名） 
	// 返回值：布尔值 
	// 备 注：无 
	//----------------------------------------------------------------------------------- 
	static function CheckUserName($C_user,$min_num=6,$max_num=16) 
	{ 
	  if (!Check::CheckLength($C_user, $min_num, $max_num)) return false; //宽度检验 
	  if (!preg_match("/^[a-zA-Z0-9_]*$/", $C_user)) return false; //特殊字符检验 
	  return true; 
	} 
	// 函数名：CheckUserName($C_user) 
	// 作 用：判断是否为合法用户名 
	// 参 数：$C_user（待检测的用户名） 
	// 返回值：布尔值 
	// 备 注：无 
	//----------------------------------------------------------------------------------- 
	static function CheckUserName_CN($C_user) 
	{ 
		 if (!preg_match("/^[".chr(0xa1)."-".chr(0xff)."a-za-z0-9_]+$/",$C_user)) 
		 {
			return false;
		 } 
		 else
		 { 
			return true; 
		 } 
	} 
	
	
	// 函数名：CheckTelephone($C_telephone) 
	// 作 用：判断是否为合法电话号码 
	// 参 数：$C_telephone（待检测的电话号码） 
	// 返回值：布尔值 
	static function CheckTelephone($C_telephone) 
	{ 
	  if (!ereg("^[+]?[0-9]+([xX-][0-9]+)*$", $C_telephone)) return false; 
	  return true; 
	} 
	
	// 函数名：CheckPost($C_post) 
	// 作 用：判断是否为合法邮编（固定长度） 
	// 参 数：$C_post（待check的邮政编码） 
	// 返回值：布尔值 
	static function CheckPost($C_post)
	{ 
		$C_post=trim($C_post); 
		if (strlen($C_post) == 6) 
		{ 
		  if(!ereg("^[+]?[_0-9]*$",$C_post)) 
		  { 
		    return true;; 
		  }
		  else 
		  { 
		    return false; 
		  } 
		}
		else 
		{ 
		  return false;; 
		} 
	} 	
}
?>