<?
class File
{
  
  static function File_Write($filepath,$cont,$cover=true)
  {
    File::CreateFolder(YangYong.dirname($filepath));
	$x=true;
	if($cover==false)
	{
		if(!file_exists(YangYong.$filepath))
		{
		   $fo=fopen(YangYong.$filepath,'w+');
		   $x=(fwrite($fo,$cont)==false)?false:true;
		   fclose($fo);
		}
	}
	else
	{
      $fo=fopen(YangYong.$filepath,'w+');
	  $x=(fwrite($fo,$cont)==false)?false:true;
	  fclose($fo);
	}
	return $x;
  }
 static function File_Html($filepath,$htmlpath)
  {
    ob_start();
	@readfile("http://".$_SERVER['HTTP_HOST']."/".$filepath);
	$cont=ob_get_contents();
	$x=File::File_Write($htmlpath,$cont);
	ob_end_clean();
	return $x;
  }
  static function CreateFolder($path) 
  { 
    $arr=explode(".",$path);
	if(count($arr)>1)
	{
		 if(!file_exists(dirname($path))){mkdir(dirname($path),0777,true);}
	}
	else
	{
	  	 if(!file_exists($path)){mkdir($path,0777,true);}
	}
  }
  static function CopyDir($oldDir, $aimDir, $overWrite = false) {
       $aimDir = str_replace('', '/', $aimDir);
       $aimDir = substr($aimDir, -1) == '/' ? $aimDir : $aimDir.'/';
       $oldDir = str_replace('', '/', $oldDir);
       $oldDir = substr($oldDir, -1) == '/' ? $oldDir : $oldDir.'/';
       if (!is_dir($oldDir)) {
         return false;
       }
       if (!file_exists($aimDir)) {
         File::CreateFolder($aimDir);
       }
       $dirHandle = opendir($oldDir);
       while(false !== ($file = readdir($dirHandle))) {
         if ($file == '.' || $file == '..') {
            continue;
         }
         if (!is_dir($oldDir . $file)) {
            File::CopyFile($oldDir . $file, $aimDir . $file, $overWrite);
         } else {
            File::CopyDir($oldDir . $file, $aimDir . $file, $overWrite);
         }
       }
       return closedir($dirHandle);
}

  static function CopyFile($fileUrl, $aimUrl, $overWrite = false)
  {
       if (!file_exists($fileUrl))
	   {
         return false;
       }
       if (file_exists($aimUrl) && $overWrite == false) 
	   {
         return false;
       }
	   elseif (file_exists($aimUrl) && $overWrite == true) 
	   {
         File::File_Del($aimUrl);
       }
       $aimDir = dirname($aimUrl);
       File::CreateFolder($aimDir);
       copy($fileUrl, $aimUrl);
       return true;
  }
	// 作 用：删除文件
	// 参 数：$path 要删除的文件路径
  static function File_Del($path)
  {
	  if(!empty($path))
	  {
        if(file_exists($path)){@unlink($path);}
	  }
  }
  
  
  // 函数名：GetFileCont($path) 
	// 作 用：取得文件内容
	// 参 数：$path 文件路径
  static function GetFileCont($path)
  {
	  if(!empty($path))
	  {
        if(file_exists(YangYong.$path))
	    {
	      return file_get_contents(YangYong.$path);
	    }
		else
		{
		  return "";	
		}
	  }
  }
    //生成静态文件
    function Save_Html($class_id,$id)
	 {
		$db=new DB();
		if($class_id>0 and $id>0)
		{
		  $rows=$db->GetRow("select folder,content_tpl,data_table from yang_class where id=$class_id and static=2");
		  if($rows)
		  {
			  if(strlen($rows["content_tpl"])>0 and strlen($rows["data_table"])>0)
			  {
				$x=explode('_',$rows['data_table']);
				File::File_Html($x[1]."_content.php?id=".$id,'html/'.$rows["folder"].$id.'.html');  
			  }
		  }
		}
	 } 
    // 函数名：Folder_Del($path) 
	// 作 用：删除文件夹
	// 参 数：$path 要删除的文件夹路径
	static function Folder_Del($dirName) 
	{ 
		  if(!is_dir($dirName)) 
		  { 
			  @unlink($dirName);
			  return false; 
		  } 
		  $handle = @opendir($dirName); 
		  while(($file = @readdir($handle)) !== false) 
		  { 
			  if($file != '.' && $file != '..') 
			  { 
				  $dir = $dirName . '/' . $file; 
				  is_dir($dir) ? File::Folder_Del($dir) : @unlink($dir); 
			  } 
		  } 
		  closedir($handle); 
		  return rmdir($dirName) ; 
	 } 
	// 作 用：取得文件后缀名
	// 参 数：$filename 完整文件名
	static function GetExt($filename)
	{
	  $filetype=explode(".",$filename);
	  $ext=strtolower($filetype[count($filetype)-1]);
	  return $ext;
	}
	static function GetPicExt($file)
	{
	    $fp = fopen($file, "rb");
        $bin = fread($fp, 2); //只读2字节
        fclose($fp);
        $str_info  = @unpack("C2chars", $bin);
        $type_code = intval($str_info['chars1'].$str_info['chars2']);
        $file_type = '';
        switch ($type_code) {
            case 7790:
                $file_type = 'exe';
                break;
            case 7784:
                $file_type = 'midi';
                break;
            case 8075:
                $file_type = 'zip';
                break;
            case 8297:
                $file_type = 'rar';
                break;
            case 255216:
                $file_type = 'jpg';
                break;
            case 7173:
                $file_type = 'gif';
                break;
            case 6677:
                $file_type = 'bmp';
                break;
            case 13780:
                $file_type = 'png';
                break;
            default:
                $file_type = 'unknown';
                break;	
		}
		return $file_type;
	}
	// 作 用：上传文件 
	static function File_Pic($pic)
	{
		if($pic['size']>0)
		{
			$ext=File::GetExt($pic["name"]);
			$fileext=array("gif","png","bmp","jpg","avi","wmv","asf","mov","rm","ra","ram","flv","rar","zip","doc","mp3");
			if(!in_array($ext,$fileext))
			{
			  echo_str("对不起，请上传合法文件");
			}
			if($pic["size"]>30000000)
			{
			  echo_str("对不起，上传文件大小限制为30M");
			}
			$folder="uploads/day_".date("ymd");
			File::CreateFolder(YangYong.$folder);
			$path=$folder."/".date('U').rand(1000,9999).".".$ext;
			move_uploaded_file($pic["tmp_name"],YangYong.$path);
			return $path;
		}
		else
		{
		  return '';	
		}
	}
  
  static function Small_Pic($srcFile,$dstFile,$max_width,$max_height) 
  {
	  if(!file_exists($srcFile))
	  {
		exit;
	  }
	  File::CreateFolder($dstFile);
	  $ext = File::GetPicExt($srcFile);
	  $arr=array("jpg","jpeg","gif","png");
	  if(!in_array($ext,$arr))
	  {
		exit;
	  }
	  if($ext=="jpg" || $ext=="jpeg")
	  {
		$img=imagecreatefromjpeg($srcFile);
	  }
	  if($ext=="gif")
	  {
		$img=imagecreatefromgif($srcFile);
	  }
	  if($ext=="png")
	  {
		$img=imagecreatefrompng($srcFile);
	  }
	  if($img)
	  {
		$width=imagesx($img);
		$height=imagesy($img);
		$scale=min($max_width/$width,$max_height/$height);
		if($scale<1)
		{
		  $new_width=floor($width*$scale);
		  $new_height=floor($height*$scale);
		  $tmp=imagecreatetruecolor($new_width,$new_height);
		  imagecopyresampled($tmp,$img,0,0,0,0,$new_width,$new_height,$width,$height);
		  imagejpeg($tmp,$dstFile,85);
		  imagedestroy($img);
		}
	  }
   }
}
?>