<?php
class Page_Html{

	var $currentPage;//当前页
	var $pageSize;//每页显示条数
	var $recordCount;//数据库里的总记录数
	var $totalPage;//总页数
	var $pageUrl;//后面的参数部分 如:pageUrl="?page=",
	function Page_Html($_currentpage=1,$_pagesize=10,$_recordcount=0,$_pageurl="")
	{
		$this->pageSize=$_pagesize;
		$this->currentPage=($_currentpage>0)?$_currentpage:1;
		$this->recordCount=($_recordcount>=0)?$_recordcount:0;
		$this->pageUrl=(empty($_pageurl))?"http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']:$_pageurl;
		$this->totalPage=ceil($this->recordCount / $this->pageSize);
		if($this->currentPage > $this->totalPage){$this->currentPage=$this->totalPage;}
		if($this->currentPage <=0){$this->currentPage=1;}
	}
	function re($p,$text)
	{
		return str_replace('{page}',$p,"<a href=\"".$this->pageUrl."\">$text</a>");
	}
	function GetPage()
	{
	    if($this->currentPage==1)
		{
		   $firstpage="<span>首页</span>";
		   $prevpage="<span>上页</span>";
		}
		else
		{
		  $firstpage=$this->re(1,'首页');
		  $prevpage=$this->re($this->currentPage-1,'上页');
		}
		if($this->currentPage==$this->totalPage or $this->totalPage==0)
		{
		   $lastpage="<span>末页</span>";
		   $nextpage="<span>下页</span>";
		}
		else
		{
		   $lastpage=$this->re($this->totalPage,'末页');
		   $nextpage=$this->re($this->currentPage+1,'下页');
		}
		$pagetext='共'.$this->recordCount.'条记录，当前页['.$this->currentPage.'/'.$this->totalPage.']';
		$startpage=1;
		$endpage=$this->totalPage;
		if($this->currentPage>4)
		{
		    if($this->totalPage<$this->currentPage+3)
			{
			   $startpage=($this->totalPage-6<1)?1:$this->totalPage-6;
			}
			else
			{
			   $startpage=$this->currentPage-3;
			   $endpage=$this->currentPage+3;
			}
		}
		else
		{
		   $endpage=($this->totalPage>=7)?7:$this->totalPage;	
		}
		$p='';
		for($i=$startpage;$i<=$endpage;$i++)
		{
		   	$p.=($i==$this->currentPage)?'<font>'.$i.'</font>':$this->re($i,$i);
		}
		return $pagetext.'&nbsp;&nbsp;&nbsp;&nbsp;'.$firstpage.$prevpage.$p.$nextpage.$lastpage;
	}
	
	function GetLimit()
	{
	   return ' limit '.($this->currentPage-1)*$this->pageSize.','.$this->pageSize;	
	}
	function GetCurrentPage()
	{
	  return $this->currentPage;	
	}
	function GetPageCount()
	{
	  return $this->totalPage;	
	}
}