<?
  class String
  {
	  // 作 用：将内容中的空格、回车替换为空
	  static function Replace_Chr($str)
	  {
		if(strlen($str)>0)
		{
		  $s=str_replace("\r\n","",$str);
		  $s=str_replace(chr(32),"",$s);
		}
		else
		{
		  $s="";
		}
		return $s;
	  }
	  static function Replace_IP($ip)
	  {
		if(!empty($ip))
		{
			$ip_str=explode('.',$ip);
			if(count($ip_str)==4)
			{
			  return $ip_str[0].'.'.$ip_str[1].'.'.$ip_str[2].'.*';	
			}
			else
			{
			  return '';	
			}
		}
		else
		{
		  return '';	
		}
	  }  
	  
	  
		// 作 用：将多行文本框内容转换为html内容
	   static function Chr_Html($str)
	   {
		  if(strlen($str)>0)
		  {
			 $str=str_replace("\r\n","<br>",$str);
			 $str=str_replace("\n","<br>",$str);
			 $str=str_replace(chr(32),"&nbsp;",$str);
		  }
		  else
		  {
			$str='';
		  }
		  return $str;
	   }
		// 作 用：将HTML内容转换为多行文本框内容
	   static function Html_Chr($str)
	   {
		  if(strlen($str)>0)
		  {
			 $str=str_replace('<br>',"\r\n",$str);
			 $str=str_replace('&nbsp;',chr(32),$str);
		  }
		  else
		  {
			$str='';
		  }
		  return $str;
	   }
	   
	   // 作 用：过滤HTML代码
		// 参 数：$str 要过滤的内容
	  static function RemoveHtml($str)
	  {
		$c=preg_replace("'<[\/\!]*?[^<>]*?>'si","",$str);
		$c=str_replace("&nbsp;","",$c);
		$c=str_replace(" ",'',$c);
		$c=str_replace("\r",'',$c);
		$c=str_replace("\n",'',$c);
		$c=str_replace("\r\n",'',$c);
		return $c;
	  }
		// 作 用：将数组转化为字符串
		static function Array_Str($str)
		{
		  if(!empty($str))
		  {
			  $str=str_replace('，',',',$str);
			  $s=join(",",$str);
		  }
		  else
		  {
			  $s='';
		  }
		  return $s;
		}
		static function Array_Str_Sql($str)
		{
		  if(!empty($str))
		  {
			  $str=str_replace('，',',',$str);
			  $s=join(",",$str);
			  $s=str_replace(",","','",$s);
			  $s="'".$s."'";
		  }
		  else
		  {
			  $s='';
		  }
		  return $s;
		}
		// 作 用：将以逗号分隔的字符串转化为数组
		static function Str_Array($str)
		{
		  $arr=array();
		  if(strlen($str)>0)
		  {
			  $str_arr=explode(",",$str);
			  $str_arr2=array();
			  foreach($str_arr as $v)
			  {
				if(!empty($v))
				{
				  $str_arr2[]=$v;	
				}
			  }
			  return $str_arr2;
		  }
		  else
		  {
			  $arr='';
		  }
		  return $arr;
		}
		
		static function Escape($str)
	  {
	   preg_match_all("/[\xC0-\xE0].|[\xE0-\xF0]..|[\x01-\x7f]+/",$str,$r);
	    $ar = $r[0];
	    foreach($ar as $k=>$v) 
		{
	      $ord = ord($v[0]);
		  if( $ord<=0x7F)
		   $ar[$k] = rawurlencode($v);
		  elseif ($ord<0xE0) 
		   { //双字节utf8码
		      $ar[$k] = "%u".String::utf2ucs($v);
		   }
	       elseif ($ord<0xF0) 
	       { 
		      $ar[$k] = "%u".String::utf2ucs($v);
	       }
	    }
	    return join("",$ar);	
	}
	static function utf2ucs($str)
	{
		 $n=strlen($str);
		 if ($n=3) 
		 {
		    $highCode = ord($str[0]);     
		    $midCode = ord($str[1]);
			$lowCode = ord($str[2]);
		    $a   = 0x1F & $highCode;
		    $b   = 0x7F & $midCode;
		    $c   = 0x7F & $lowCode;
		    $ucsCode = (64*$a + $b)*64 + $c;  
		 }
		 elseif ($n==2) 
		 {
			$highCode = ord($str[0]);     
			$lowCode = ord($str[1]);
		    $a   = 0x3F & $highCode;  //0x3F是0xC0的补数
		    $b   = 0x7F & $lowCode;  //0x7F是0x80的补数
		    $ucsCode = 64*$a + $b;  
		 }
		 elseif($n==1) {
			 $ucscode = ord($str);
		 }
		 return dechex($ucsCode);
	}
	 static function UnEscape($escstr)
	{
		  preg_match_all("/%u[0-9A-Za-z]{4}|%.{2}|[0-9a-zA-Z.+-_]+/",$escstr,$matches); //prt($matches);
		  $ar = &$matches[0];
		  $c = "";
		  foreach($ar as $val){
		 if (substr($val,0,1)!="%") { //如果是字母数字+-_.的ascii码
			 $c .=$val;
		 }
		 elseif (substr($val,1,1)!="u") { //如果是非字母数字+-_.的ascii码
		  $x = hexdec(substr($val,1,2));
			 $c .=chr($x);
		 }
		 else { //如果是大于0xFF的码
		  $val = intval(substr($val,2),16);
		  if($val < 0x7F){        // 0000-007F
		   $c .= chr($val);
		  }elseif($val < 0x800) { // 0080-0800
		   $c .= chr(0xC0 | ($val / 64));
		   $c .= chr(0x80 | ($val % 64));
		  }else{                // 0800-FFFF
		   $c .= chr(0xE0 | (($val / 64) / 64));
		   $c .= chr(0x80 | (($val / 64) % 64));
		   $c .= chr(0x80 | ($val % 64));
		  }
		 }
		  }
		  return $c;
       }
	   
	   static function Focus_Key($key,$str)
	  {
		if(!empty($key) and !empty($str))
		{
		  return str_replace($key,"<strong><font color='#ff0000'>$key</font></strong>",$str);
		}
	  }
	  
	  static function un_utf8($str) 
	  { 
		 $str = rawurldecode($str); 
		 preg_match_all("/%u.{4}|&#x.{4};|&#d+;|.+/U",$str,$r); 
		 $ar = $r[0]; 
		 foreach($ar as $k=>$v) 
		 { 
			  if(substr($v,0,2) == "%u") 
			   $ar[$k] = mb_convert_encoding(pack("H4",substr($v,-4)),"gb2312","UCS-2");
			  elseif(substr($v,0,3) == "&#x") 
			   $ar[$k] = mb_convert_encoding(pack("H4",substr($v,3,-1)),"gb2312","UCS-2");
			  elseif(substr($v,0,2) == "&#") { 
			   $ar[$k] = mb_convert_encoding(pack("H4",substr($v,2,-1)),"gb2312","UCS-2");
				 } 
		  } 
		  return join("",$ar); 
	   }
  }
?>