<?php
 namespace Module\Paper\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextLink; use Module\Paper\Util\PaperUtil; use Module\Question\Type\QuestionType; use Module\Question\Util\QuestionUtil; class PaperController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('paper') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->select('categoryId', '分类')->optionModelTree('paper_category', 'id', 'pid', 'name'); $builder->text('title', '标题'); $builder->switch('isPublic', '公开'); $builder->number('passScore', '及格分数'); $builder->number('totalScore', '总分数'); $builder->display('created_at', L('Created At')); $builder->display('updated_at', L('Updated At')); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->like('title', '标题'); }) ->hookItemOperateRendering(function (ItemOperate $itemOperate) { $itemOperate->push(TextLink::primary('PDF', action('\\' . __CLASS__ . '@download', ['_id' => $itemOperate->item()->id, 'hasAnswer' => 0]), 'target="_blank"')); $itemOperate->push(TextLink::primary('PDF(有答案)', action('\\' . __CLASS__ . '@download', ['_id' => $itemOperate->item()->id, 'hasAnswer' => 1]), 'target="_blank"')); $itemOperate->getField()->width(300); }) ->addBlankPage(true)->editBlankPage(true) ->title('试卷'); } public function delete() { AdminPermission::demoCheck(); ModelUtil::transactionBegin(); foreach (CRUDUtil::ids() as $id) { if (ModelUtil::exists('paper_exam', ['paperId' => $id])) { return Response::jsonError('请在“考试管理”中删除所有与该试卷有关的考试'); } ModelUtil::delete('paper_question', ['paperId' => $id]); ModelUtil::delete('paper', ['id' => $id]); } ModelUtil::transactionCommit(); return Response::jsonSuccess(); } public function add() { return $this->addOrEdit(0); } public function edit() { return $this->addOrEdit(CRUDUtil::id()); } private function addOrEdit($id) { $canEdit = true; if ($id) { $paper = ModelUtil::get('paper', ['id' => $id]); if (empty($paper)) { return Response::send(-1, 'paper not found'); } if (ModelUtil::exists('paper_exam', ['paperId' => $id])) { $canEdit = false; } } else { $paper = null; } if (Request::isPost()) { AdminPermission::demoCheck(); $input = InputPackage::buildFromInputJson('data'); $savePaper = []; $savePaper['title'] = $input->getTrimString('title'); $savePaper['isPublic'] = $input->getBoolean('isPublic'); $savePaper['categoryId'] = $input->getInteger('categoryId'); BizException::throwsIf('试卷标题为空', empty($savePaper['title'])); if (!$canEdit) { ModelUtil::update('paper', ['id' => $paper['id']], $savePaper); return Response::send(0, null, null, action('\\' . __CLASS__ . '@index')); } $savePaper['totalScore'] = $input->getInteger('totalScore'); $savePaper['passScore'] = $input->getInteger('passScore'); $savePaper['timeLimitEnable'] = $input->getBoolean('timeLimitEnable'); $savePaper['timeLimitValue'] = $input->getInteger('timeLimitValue'); BizException::throwsIf('试卷总分为空', empty($savePaper['totalScore'])); BizException::throwsIf('及格分数大于总分数', $savePaper['passScore'] > $savePaper['totalScore']); BizException::throwsIf('答题时间设置错误', $savePaper['timeLimitEnable'] && empty($savePaper['timeLimitValue'])); $totalScore = 0; $questionCount = 0; $savePaperQuestions = []; $savePaperQuestionMap = []; $saveQuestions = $input->getArray('questions'); foreach ($saveQuestions as $index => $question) { $paperQuestion = []; BizException::throwsIf('第' . ($index + 1) . '题不存在', empty($question['id'])); $questionData = QuestionUtil::getQuestionData($question['id']); BizException::throwsIf('第' . ($index + 1) . '题不存在', empty($questionData)); $paperQuestion['questionId'] = $questionData['question']['id']; $paperQuestion['score'] = $question['score']; if (isset($savePaperQuestionMap[$paperQuestion['questionId']])) { BizException::throwsIf('第' . ($index + 1) . '题与第' . $savePaperQuestionMap[$paperQuestion['questionId']] . '大题重复'); } $savePaperQuestionMap[$paperQuestion['questionId']] = $index + 1; switch ($questionData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: case QuestionType::TEXT: BizException::throwsIf('第' . ($index + 1) . '题分值设置错误', !is_array($paperQuestion['score']) || count($paperQuestion['score']) != 1); break; case QuestionType::FILL: BizException::throwsIf('第' . ($index + 1) . '题分值设置错误', !is_array($paperQuestion['score']) || count($paperQuestion['score']) != count($questionData['answers'])); break; case QuestionType::GROUP: $scoreCount = 0; foreach ($questionData['items'] as $item) { switch ($item['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: case QuestionType::TEXT: $scoreCount += 1; break; case QuestionType::FILL: $scoreCount += count($item['answers']); break; } } BizException::throwsIf('第' . ($index + 1) . '题分值设置错误', !is_array($paperQuestion['score']) || count($paperQuestion['score']) != $scoreCount); break; } $questionCount += count($paperQuestion['score']); $totalScore += array_sum($paperQuestion['score']); $savePaperQuestions[] = $paperQuestion; } BizException::throwsIf('总分设置' . $savePaper['totalScore'] . '和计算' . $totalScore . '不相等', $totalScore != $savePaper['totalScore']); try { ModelUtil::transactionBegin(); $savePaper['questionCount'] = $questionCount; if ($paper) { ModelUtil::update('paper', ['id' => $paper['id']], $savePaper); } else { $savePaper['alias'] = strtolower(RandomUtil::lowerString(16)); $paper = ModelUtil::insert('paper', $savePaper); } ModelUtil::delete('paper_question', ['paperId' => $paper['id']]); foreach ($savePaperQuestions as $savePaperQuestion) { $savePaperQuestion['paperId'] = $paper['id']; $savePaperQuestion['score'] = json_encode($savePaperQuestion['score']); ModelUtil::insert('paper_question', $savePaperQuestion); } ModelUtil::transactionCommit(); return Response::send(0, null, null, action('\\' . __CLASS__ . '@index')); } catch (\Exception $e) { ModelUtil::transactionRollback(); throw $e; } } $paperInput = InputPackage::build($paper); $data = [ 'id' => $id, 'title' => $paperInput->getTrimString('title'), 'isPublic' => $paperInput->getBoolean('isPublic'), 'categoryId' => $paperInput->getInteger('categoryId', null), 'totalScore' => $paperInput->getInteger('totalScore'), 'passScore' => $paperInput->getInteger('passScore'), 'timeLimitEnable' => $paperInput->getBoolean('timeLimitEnable'), 'timeLimitValue' => $paperInput->getInteger('timeLimitValue'), 'questions' => [], ]; return view('module::Paper.View.admin.paper.edit', [ 'pageTitle' => '试卷编辑', 'data' => $data, 'canEdit' => $canEdit, 'paperQuestions' => $paper ? PaperUtil::listQuestions($paper['id']) : [], ]); } public function download() { $id = CRUDUtil::id(); $input = InputPackage::buildFromInput(); $paper = PaperUtil::getPaper($id); $paperQuestions = PaperUtil::listQuestions($id); foreach ($paperQuestions as &$paperQuestion) { $paperQuestion['_questionData'] = QuestionUtil::getQuestionData($paperQuestion['questionId']); $paperQuestion['_questionCount'] = count($paperQuestion['score']); } return view('module::Paper.View.admin.paper.download', [ 'paper' => $paper, 'hasAnswer' => $input->getInteger('hasAnswer'), 'paperQuestions' => $paperQuestions, ]); } }