<?php
 namespace Module\Paper\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextLink; use Module\Member\Util\MemberCmsUtil; use Module\Paper\Type\PaperExamStatus; use Module\Paper\Util\PaperUtil; class PaperExamController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('paper_exam') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->display('paperId', '试卷')->hookRendering(function (AbstractField $field, $item, $index) { $paper = ModelUtil::getWithCache('paper', ['id' => $item->paperId]); return AutoRenderedFieldValue::make('<a target="_blank" href="/paper/view/' . $paper['alias'] . '">' . htmlspecialchars($paper['title']) . '</a>'); }); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return AutoRenderedFieldValue::make(MemberCmsUtil::showFromId($item->memberUserId)); }); $builder->type('status', '状态')->type(PaperExamStatus::class); $builder->switch('isJudge', '已经阅卷')->hookRendering(function (AbstractField $field, $item, $index) { return AutoRenderedFieldValue::make($item->isJudge ? '<span class="ub-text-success">是</span>' : '<span class="ub-text-danger">否</span>'); })->width(100); $builder->datetime('startTime', '开始时间'); $builder->number('score', '得分'); $builder->display('created_at', L('Created At')); $builder->display('updated_at', L('Updated At'))->listable(false); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->eq('status', '状态')->select(PaperExamStatus::class); }) ->hookItemOperateRendering(function (ItemOperate $itemOperate) { if ($itemOperate->item()->status == PaperExamStatus::SUBMITTED) { if (!$itemOperate->item()->isJudge) { $itemOperate->push(TextLink::primary('阅卷', action('\\' . __CLASS__ . '@judge', ['_id' => $itemOperate->item()->id]))); } else { $itemOperate->push(TextLink::primary('重新阅卷', action('\\' . __CLASS__ . '@judge', ['_id' => $itemOperate->item()->id]))); } } }) ->disableCUD() ->title('阅卷管理'); } public function judge() { $id = CRUDUtil::id(); $paperExam = ModelUtil::get('paper_exam', ['id' => $id]); $paperExamQuestions = PaperUtil::listPaperExamQuestions($paperExam['id']); if (Request::isPost()) { AdminPermission::demoCheck(); $input = InputPackage::buildFromInput('data'); $totalScore = 0; $paperExamQuestions = $input->getJson('data'); foreach ($paperExamQuestions as $paperExamQuestion) { ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']) ]); foreach ($paperExamQuestion['score'] as $item) { $totalScore += $item; } } ModelUtil::update('paper_exam', $paperExam['id'], [ 'score' => $totalScore, 'isJudge' => true, ]); return Response::json(0, '提交成功', null, action('\\' . __CLASS__ . '@index')); } $paper = PaperUtil::getPaper($paperExam['paperId']); $paperQuestions = PaperUtil::listQuestions($paperExam['paperId']); return view('module::Paper.View.admin.paperExam.judge', [ 'pageTitle' => '阅卷', 'id' => $id, 'paper' => $paper, 'paperQuestions' => $paperQuestions, 'paperExamQuestions' => $paperExamQuestions, ]); } }