<?php
 namespace Module\Paper\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use Module\Paper\Util\PaperExamUtil; use Module\Paper\Util\PaperUtil; use Module\Question\Type\QuestionType; use Module\Question\Util\QuestionUtil; class PaperController extends Controller { public function listPublic() { if (!PaperExamUtil::isEnable()) { return PaperExamUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $searchInput = $input->getJsonAsInput('search'); $page = $input->getPage(); $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $option['where']['isPublic'] = true; $categoryId = $searchInput->getInteger('categoryId'); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('paper', $page, $pageSize, $option); $papers = $paginateData['records']; ModelUtil::join($papers, 'categoryId', '_category', 'paper_category', 'id'); return Response::generateSuccessData([ 'page' => $page, 'pageSize' => $pageSize, 'records' => $papers, 'total' => $paginateData['total'], ]); } public function questions() { $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::generateError('试卷不存在'); } $paperQuestions = PaperUtil::listQuestions($paper['id']); foreach ($paperQuestions as $k => $paperQuestion) { $paperQuestions[$k]['_questionData'] = QuestionUtil::getQuestionData($paperQuestion['questionId']); } $paperQuestionList = []; $number = 1; foreach ($paperQuestions as $paperQuestion) { $paperQuestionListItem = []; $paperQuestionListItem['score'] = $paperQuestion['score']; $paperQuestionListItem['questionNumber'] = $number; $questionCount = 0; $paperQuestionListItem['question'] = ArrayUtil::keepKeys($paperQuestion['_questionData']['question'], [ 'id', 'type', 'question', 'alias', ]); switch ($paperQuestionListItem['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $paperQuestionListItem['options'] = []; foreach ($paperQuestion['_questionData']['options'] as $option) { $paperQuestionListItem['options'][] = [ 'isAnswer' => false, 'option' => $option['option'], '_key' => $option['_key'], ]; } $questionCount = 1; break; case QuestionType::FILL: $paperQuestionListItem['answers'] = []; foreach ($paperQuestion['_questionData']['answers'] as $answer) { $paperQuestionListItem['answers'][] = [ 'answer' => '', ]; } $questionCount = count($paperQuestionListItem['answers']); break; case QuestionType::TEXT: $paperQuestionListItem['answer'] = [ 'answer' => '', ]; $questionCount = 1; break; case QuestionType::GROUP: $paperQuestionListItem['items'] = []; $questionCount = 0; foreach ($paperQuestion['_questionData']['items'] as $item) { $questionItem = []; $questionItem['question'] = ArrayUtil::keepKeys($item['question'], ['type', 'question', 'alias']); $questionItem['itemNumber'] = $item['itemNumber']; $questionItem['itemCount'] = $item['itemCount']; switch ($questionItem['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $questionItem['options'] = []; foreach ($item['options'] as $option) { $questionItem['options'][] = [ 'isAnswer' => false, 'option' => $option['option'], '_key' => $option['_key'], ]; } $questionCount++; break; case QuestionType::FILL: $questionItem['answers'] = []; foreach ($item['answers'] as $answer) { $questionItem['answers'][] = [ 'answer' => '', ]; } $questionCount += count($questionItem['answers']); break; case QuestionType::TEXT: $questionItem['answer'] = [ 'answer' => '', ]; $questionCount++; break; } $paperQuestionListItem['items'][] = $questionItem; } break; } $paperQuestionListItem['questionCount'] = $questionCount; $number += $questionCount; $paperQuestionList[] = $paperQuestionListItem; } return Response::generateSuccessData($paperQuestionList); } public function listQuestions() { $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::generateError('试卷不存在'); } $paperQuestions = PaperUtil::listQuestions($paper['id']); foreach ($paperQuestions as $k => $paperQuestion) { $questionData = QuestionUtil::getQuestionData($paperQuestion['questionId']); list($questionData, $questionDataOriginal) = QuestionUtil::filterQuestionData($questionData); $paperQuestions[$k]['_questionData'] = $questionData; } $paperQuestions = array_filter(array_map(function ($item) use ($paper) { if (empty($item['_questionData'])) { PaperUtil::deleteQuestion($paper['id'], $item['questionId']); return null; } return $item; }, $paperQuestions)); return Response::generateSuccessData($paperQuestions); } public function get() { $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::generateError('试卷不存在'); } return Response::generateSuccessData($paper); } public function search() { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); $page = $input->getInteger('page', 1); $pageSize = 10; $maxPage = modstart_config()->getInteger('moduleExamSearchPaperMaxPage', 20); $page = min($page, $maxPage); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['title', 'like', '%' . $keywords . '%']; $paginateData = ModelUtil::paginate('paper', $page, $pageSize, $option); $records = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); ModelUtil::join($records, 'categoryId', '_category', 'paper_category', 'id'); $viewData = []; $viewData['pageTitle'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['page'] = $page; $viewData['pageSize'] = $pageSize; $viewData['total'] = $paginateData['total']; return Response::generateSuccessData($viewData); } }