<?php
 namespace Module\Paper\Api\Controller; use Carbon\Carbon; use Illuminate\Foundation\Bus\DispatchesJobs; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use Module\Member\Auth\MemberUser; use Module\Paper\Constant\ResponseCodes; use Module\Paper\Job\PaperExamAutoJudgeJob; use Module\Paper\Type\PaperExamStatus; use Module\Paper\Util\PaperUtil; use Module\Question\Type\QuestionType; use Module\Question\Util\QuestionUtil; class PaperExamController extends Controller { use DispatchesJobs; private $paperApi; public function __construct() { $this->paperApi = app(PaperController::class); } public function start($alias) { $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::generateError('试卷不存在'); } InputPackage::mergeToInput('alias', $alias); $paperQuestionList = Response::tryGetData($this->paperApi->questions()); $paperExam = ModelUtil::get('paper_exam', [ 'memberUserId' => MemberUser::id(), 'paperId' => $paper['id'], 'status' => PaperExamStatus::EXAMING, ]); if (empty($paperExam)) { $paperExam = ModelUtil::insert('paper_exam', [ 'memberUserId' => MemberUser::id(), 'paperId' => $paper['id'], 'status' => PaperExamStatus::EXAMING, 'startTime' => Carbon::now(), 'isAutoJudge' => false, 'isJudge' => false, ]); $msg = null; } else { $msg = '即将继续上次未完成的考试'; } $startTime = Carbon::parse($paperExam['startTime'])->format('Y-m-d H:i:s'); $timeLimitEnable = ($paper['timeLimitEnable'] ? true : false); $timeLeftSecond = 0; if ($timeLimitEnable) { $timeLeftSecond = $paper['timeLimitValue'] * 60 - (time() - strtotime($startTime)); $timeLeftSecond = max($timeLeftSecond, 0); } return Response::generate(0, $msg, [ 'startTime' => $startTime, 'timeLimitEnable' => $timeLimitEnable, 'timeLeftSecond' => $timeLeftSecond, 'paperQuestionList' => $paperQuestionList, ]); } public function save($alias) { $input = InputPackage::buildFromInput(); $data = $input->getJson('data'); $isSubmit = $input->getBoolean('isSubmit'); $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::generateError('试卷不存在'); } $paperExam = ModelUtil::model('paper_exam')->where([ 'memberUserId' => MemberUser::id(), 'paperId' => $paper['id'], ])->orderBy('id', 'desc')->limit(1)->first(); if (empty($paperExam)) { return Response::generateError('试卷考试不存在'); } $paperExam = $paperExam->toArray(); if ($paperExam['status'] != PaperExamStatus::EXAMING) { return Response::generate(ResponseCodes::PAPER_EXAM_HAS_SUBMITED, '试卷已提交'); } if ($paper['timeLimitEnable']) { $timeLeftSecond = $paper['timeLimitValue'] * 60 - (time() - strtotime($paperExam['startTime'])); if ($timeLeftSecond <= 0) { ModelUtil::update('paper_exam', ['id' => $paperExam['id']], [ 'status' => PaperExamStatus::SUBMITTED, ]); $job = new PaperExamAutoJudgeJob(); $job->paperExamId = $paperExam['id']; $this->dispatch($job); return Response::generate(ResponseCodes::PAPER_EXAM_HAS_SUBMITED, '考试时间到,试卷已强制提交'); } } $paperQuestions = PaperUtil::listQuestions($paper['id']); foreach ($paperQuestions as $k => $questionData) { $paperQuestions[$k]['_questionData'] = QuestionUtil::getQuestionData($questionData['questionId']); } if (empty($data) || !is_array($data)) { return Response::generateError('考试数据提交错误'); } $examQuestionList = []; foreach ($paperQuestions as $questionIndex => $questionData) { if (empty($data[$questionIndex])) { return Response::generateError('考试数据提交错误'); } $questionDataSubmitted = $data[$questionIndex]; $questionData = $questionData['_questionData']; $examQuestion = []; $examQuestion['examId'] = $paperExam['id']; $examQuestion['questionId'] = $questionData['question']['id']; $examQuestion['answer'] = []; switch ($questionData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: foreach ($questionDataSubmitted['options'] as $optionIndex => $option) { if ($option['isAnswer']) { $examQuestion['answer'][] = $optionIndex; } } break; case QuestionType::FILL: foreach ($questionDataSubmitted['answers'] as $answer) { $examQuestion['answer'][] = $answer['answer']; } break; case QuestionType::TEXT: $examQuestion['answer'] [] = $questionDataSubmitted['answer']['answer']; break; case QuestionType::GROUP: foreach ($questionData['items'] as $questionItemIndex => $questionItemData) { $questionItemDataSubmitted = $questionDataSubmitted['items'][$questionItemIndex]; $answer = []; switch ($questionItemData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: foreach ($questionItemDataSubmitted['options'] as $optionIndex => $option) { if ($option['isAnswer']) { $answer[] = $optionIndex; } } break; case QuestionType::FILL: foreach ($questionItemDataSubmitted['answers'] as $answerItem) { $answer[] = $answerItem['answer']; } break; case QuestionType::TEXT: $answer[] = $questionItemDataSubmitted['answer']['answer']; break; } $examQuestion['answer'] [] = $answer; } break; } $examQuestionList[] = $examQuestion; } foreach ($examQuestionList as $examQuestion) { $exists = ModelUtil::get('paper_exam_question', [ 'examId' => $examQuestion['examId'], 'questionId' => $examQuestion['questionId'], ]); if ($exists) { ModelUtil::update('paper_exam_question', ['id' => $exists['id']], [ 'answer' => @json_encode($examQuestion['answer']), 'isJudge' => false, ]); } else { ModelUtil::insert('paper_exam_question', [ 'examId' => $examQuestion['examId'], 'questionId' => $examQuestion['questionId'], 'answer' => @json_encode($examQuestion['answer']), 'isJudge' => false, ]); } } if (!$isSubmit) { $startTime = Carbon::parse($paperExam['startTime'])->format('Y-m-d H:i:s'); $timeLimitEnable = ($paper['timeLimitEnable'] ? true : false); $timeLeftSecond = 0; if ($timeLimitEnable) { $timeLeftSecond = $paper['timeLimitValue'] * 60 - (time() - strtotime($startTime)); $timeLeftSecond = max($timeLeftSecond, 0); } return Response::generateSuccessData([ 'timeLeftSecond' => $timeLeftSecond, ]); } ModelUtil::update('paper_exam', ['id' => $paperExam['id']], [ 'status' => PaperExamStatus::SUBMITTED, ]); $job = new PaperExamAutoJudgeJob(); $job->paperExamId = $paperExam['id']; $this->dispatch($job); return Response::generateSuccess(); } }