<?php
 namespace Module\Paper\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; use Module\Paper\Util\PaperUtil; use Module\Question\Type\QuestionType; use Module\Question\Util\QuestionUtil; class PaperExamMemberController extends Controller implements MemberLoginCheck { public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = $input->getPageSize(); $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $option['where']['memberUserId'] = MemberUser::id(); $paginateData = ModelUtil::paginate('paper_exam', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'paperId', '_paper', 'paper', 'id'); return Response::generateSuccessData([ 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'records' => $paginateData['records'], ]); } public function get() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $paperExam = PaperUtil::getPaperExam($id); if (empty($paperExam) || $paperExam['memberUserId'] != MemberUser::id()) { return Response::generateError('考试不存在'); } if (!$paperExam['isJudge']) { return Response::generateError('正在阅卷,请稍后查看'); } $paperExamQuestions = PaperUtil::listPaperExamQuestions($paperExam['id']); $paper = PaperUtil::getPaper($paperExam['paperId']); if (empty($paper)) { return Response::generateError('试卷不存在'); } $paperQuestions = PaperUtil::listQuestions($paper['id']); $number = 1; foreach ($paperQuestions as $i => $paperQuestion) { $paperQuestions[$i]['_questionData'] = QuestionUtil::getQuestionData($paperQuestion['questionId']); $paperQuestions[$i]['_questionData']['questionNumber'] = $number; $questionCount = 0; $paperQuestionItem = $paperQuestions[$i]['_questionData']; switch ($paperQuestionItem['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $questionCount = 1; break; case QuestionType::FILL: $questionCount = count($paperQuestionItem['answers']); break; case QuestionType::TEXT: $questionCount = 1; break; case QuestionType::GROUP: $questionCount = 0; foreach ($paperQuestionItem['items'] as $itemIndex => $item) { switch ($item['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $questionCount++; break; case QuestionType::FILL: $questionCount += count($item['answers']); break; case QuestionType::TEXT: $questionCount++; break; } } break; } $paperQuestions[$i]['_questionData']['questionCount'] = $questionCount; $number += $questionCount; } return Response::generateSuccessData([ 'paper' => $paper, 'paperExam' => $paperExam, 'paperQuestions' => $paperQuestions, 'paperExamQuestions' => $paperExamQuestions, ]); } }