<?php
 namespace Module\Paper\Job; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Job\BaseJob; use ModStart\Core\Util\HtmlUtil; use Module\Paper\Type\PaperExamStatus; use Module\Paper\Util\PaperUtil; use Module\Question\Type\QuestionType; use Module\Question\Util\QuestionUtil; class PaperExamAutoJudgeJob extends BaseJob { public $paperExamId = 0; public function handle() { $paperExam = PaperUtil::getPaperExam($this->paperExamId); if (empty($paperExam)) { return; } if ($paperExam['isAutoJudge']) { return; } if ($paperExam['status'] != PaperExamStatus::SUBMITTED) { return; } $paperExamQuestions = PaperUtil::listPaperExamQuestions($paperExam['id']); $isAllJudged = true; $paperQuestions = PaperUtil::listQuestions($paperExam['paperId']); foreach ($paperQuestions as $paperQuestionIndex => $paperQuestion) { $paperExamQuestion = &$paperExamQuestions[$paperQuestionIndex]; if (empty($paperExamQuestion)) { continue; } $questionData = QuestionUtil::getQuestionData($paperQuestion['questionId']); switch ($questionData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $answer = []; foreach ($questionData['options'] as $index => $option) { if ($option['isAnswer']) { $answer[] = $index; } } if (json_encode($answer) == json_encode($paperExamQuestion['answer'])) { $paperExamQuestion['score'] = [$paperQuestion['score'][0]]; } else { $paperExamQuestion['score'] = [0]; } ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']), 'isJudge' => true, ]); break; case QuestionType::FILL: $paperExamQuestion['score'] = []; $isJudge = true; foreach ($questionData['answers'] as $index => $questionDataAnswer) { if (trim(HtmlUtil::text($questionDataAnswer['answer'])) == trim($paperExamQuestion['answer'][$index])) { $paperExamQuestion['score'][] = $paperQuestion['score'][$index]; } else { $paperExamQuestion['score'][] = 0; $isJudge = false; $isAllJudged = false; } } ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']), 'isJudge' => $isJudge, ]); break; case QuestionType::TEXT: $isJudge = false; if (trim($paperExamQuestion['answer'][0]) == trim(HtmlUtil::text($questionData['answer']['answer']))) { $paperExamQuestion['score'] = [$paperQuestion['score'][0]]; $isJudge = true; } else { $paperExamQuestion['score'] = [0]; $isAllJudged = false; } ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']), 'isJudge' => $isJudge, ]); break; case QuestionType::GROUP: $isJudge = true; $paperExamQuestion['score'] = []; $scoreIndex = 0; foreach ($questionData['items'] as $questionDataItemIndex => $questionDataItem) { switch ($questionDataItem['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: case QuestionType::MULTI_CHOICES: $answer = []; foreach ($questionDataItem['options'] as $index => $option) { if ($option['isAnswer']) { $answer[] = $index; } } if (json_encode($answer) == json_encode($paperExamQuestion['answer'][$questionDataItemIndex])) { $paperExamQuestion['score'][] = $paperQuestion['score'][$scoreIndex]; } else { $paperExamQuestion['score'][] = 0; } $scoreIndex++; break; case QuestionType::FILL: foreach ($questionDataItem['answers'] as $index => $questionDataItemAnswer) { if (trim(HtmlUtil::text($questionDataItemAnswer['answer'])) == trim($paperExamQuestion['answer'][$questionDataItemIndex][$index])) { $paperExamQuestion['score'][] = $paperQuestion['score'][$scoreIndex]; } else { $paperExamQuestion['score'][] = 0; $isJudge = false; $isAllJudged = false; } $scoreIndex++; } break; case QuestionType::TEXT: if (trim($paperExamQuestion['answer'][$questionDataItemIndex][0]) == trim(HtmlUtil::text($questionDataItem['answer']['answer']))) { $paperExamQuestion['score'][] = $paperQuestion['score'][$scoreIndex]; } else { $paperExamQuestion['score'][] = 0; $isJudge = false; $isAllJudged = false; } $scoreIndex++; break; } } ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']), 'isJudge' => $isJudge, ]); break; } } $totalScore = null; if ($isAllJudged) { $totalScore = 0; foreach ($paperExamQuestions as $paperExamQuestion) { $totalScore += array_sum($paperExamQuestion['score']); } } ModelUtil::update('paper_exam', ['id' => $paperExam['id']], [ 'isAutoJudge' => true, 'isJudge' => $isAllJudged, 'score' => $totalScore, ]); } }