@extends('modstart::admin.frame')

{!! \ModStart\ModStart::style("
body,html{background:#FFF;}
body {margin:0;padding:0;font-family: 'Helvetica Neue',Arial,'Hiragino Sans GB',STHeiti,'Microsoft YaHei','WenQuanYi Micro Hei',SimSun,Song,sans-serif;background: #F6F6F6;-webkit-print-color-adjust: exact;}
body .body-container{max-width:800px;padding:2em;margin:0 auto;background:#FFF;}
body .print-page-breaker{page-break-after:always;}
#print_box{text-align:center;padding:20px 0;}
@media print {
    #print_box{display:none;}
}
@page{
    size:A4;
    margin:15mm;
}
") !!}
{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}
@section('pageTitle',$hasAnswer?$paper['title'].'-附答案':$paper['title'] )

@section('body')
    <div id="print_box">
        <button class="btn btn-large btn-primary" onclick="window.print();">点击打印 <i class="uk-icon-print"></i> 或 另存为PDF <i class="uk-icon-file"></i></button>
    </div>
    <div class="body-container ub-html">
        <div class="title">
            <h1 style="padding:20px 0;text-align:center;font-size:20px;">{{$paper['title']}}</h1>
        </div>
        <div class="attr">
            <div style="text-align:center;">
                题目总数：{{$paper['questionCount']}}
                &nbsp;&nbsp;
                总分数：{{$paper['totalScore']}}
                &nbsp;&nbsp;
                @if($paper['timeLimitEnable'])
                    时间：{{$paper['timeLimitValue']}}分钟
                @else
                    时间：不限时
                @endif
            </div>
        </div>
        <div style="border-top:2px solid #CCC;margin:1em 0;"></div>
        <?php
        if(!empty($paperQuestions)){
            $paperQuestionNumber = 1;
            foreach($paperQuestions as $paperQuestion){
                echo \Module\Question\Util\QuestionRenderUtil::render($paperQuestion['_questionData'],$paperQuestionNumber,['hasAnswer'=>$hasAnswer]);
                $paperQuestionNumber += $paperQuestion['_questionCount'];
            }
        }
        ?>
    </div>
@endsection
