@extends($_viewMemberFrame)

@section('pageTitleMain','我的考试')

@section('memberBodyContent')

    <div class="ub-panel">
        <div class="head">
            <div class="title">我的考试</div>
        </div>
        <div class="body">

            <table class="ub-lister-table">
                <thead>
                <tr>
                    <th>考试</th>
                    <th width="80">状态</th>
                    <th width="80">成绩</th>
                    <th width="160">时间</th>
                </tr>
                </thead>
                <tbody>
                @if(empty($paperExams))
                    <tr>
                        <td colspan="3">
                            <div class="empty">
                                还没有任何考试~
                            </div>
                        </td>
                    </tr>
                @else
                    @foreach($paperExams as $paperExam)
                        <tr class="unread">
                            <td>
                                <a href="/paper_exam_member/{{$paperExam['id']}}">{{$paperExam['_paper']['title']}}</a>
                            </td>
                            <td>
                                @if($paperExam['status']==\Module\Paper\Type\PaperExamStatus::EXAMING)
                                    <div class="ub-text-danger">正在考试</div>
                                @endif
                                @if($paperExam['status']==\Module\Paper\Type\PaperExamStatus::SUBMITTED)
                                    <div class="ub-text-success">考试完成</div>
                                @endif
                            </td>
                            <td>
                                @if($paperExam['isJudge'])
                                    {{$paperExam['score']}}
                                    /
                                    {{$paperExam['_paper']['totalScore']}}
                                @else
                                    <div class="ub-text-muted">正在阅卷</div>
                                @endif
                            </td>
                            <td>
                                <div class="ub-text-muted">{{$paperExam['created_at']}}</div>
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
            <div class="ub-page">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>

@endsection