@extends($_viewMemberFrame)

@section('pageTitleMain',htmlspecialchars($paper['title']))

{!! \ModStart\ModStart::css('vendor/Paper/style/paper.css') !!}
{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}

@section('memberBodyContent')

    <div>
        <div class="ub-panel">
            <div class="head">
                <div class="title">
                    我的成绩
                </div>
            </div>
            <div class="body">
                <div class="ub-pair">
                    <div class="name">分数</div>
                    <div class="value">{{$paperExam['score']}}</div>
                </div>
                <div class="ub-pair">
                    <div class="name">考试时间</div>
                    <div class="value">{{$paperExam['created_at']}}</div>
                </div>
                <div class="ub-pair">
                    <div class="name">限时</div>
                    <div class="value">
                        @if($paper['timeLimitEnable'])
                            {{$paper['timeLimitValue']}}分钟
                        @else
                            不限时
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="ub-panel">
            <div class="head">
                <div class="title">
                    {{$paper['title']}}
                </div>
            </div>
            <div class="body">
                <div class="ub-pair">
                    <div class="name">题目总数</div>
                    <div class="value">{{$paper['questionCount']}}</div>
                </div>
                <div class="ub-pair">
                    <div class="name">总分数</div>
                    <div class="value">{{$paper['totalScore']}}</div>
                </div>
            </div>
        </div>
        <div class="pb-member-paper-exam-question-list">
            @if(!empty($paperQuestions))
                <?php $paperQuestionNumber = 1; ?>
                @foreach($paperQuestions as $paperQuestionIndex=>$paperQuestion)
                    <?php $questionData = &$paperQuestion['_questionData']; ?>
                    <?php $paperQuestionNumberCount = count($paperQuestion['score']); ?>
                    @if($questionData['question']['type']==\Module\Question\Type\QuestionType::SINGLE_CHOICE)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewSingleChoice')
                    @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::MULTI_CHOICES)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewMultiChoices')
                    @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TRUE_FALSE)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewTrueFalse')
                    @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::FILL)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewFill')
                    @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TEXT)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewText')
                    @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::GROUP)
                        @include('module::Paper.View.pc.memberPaperExam.question.viewGroup')
                    @endif
                    <?php $paperQuestionNumber += $paperQuestionNumberCount; ?>
                @endforeach
            @endif
        </div>
    </div>

@endsection