@extends($_viewFrame)

@section('pageTitleMain','考试')

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a class="active" href="javascript:;">试卷</a>
        </div>

        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            试卷
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-list-items" style="padding:0.5rem;">
                            @if(!empty($papers))
                                @foreach($papers as $paper)
                                    <div class="item-d">
                                        <a class="title" href="/paper/view/{{$paper['alias']}}">{{$paper['title']}}</a>
                                        <div class="attr">
                                            <div class="ub-pair">
                                                <div class="name">题目总数：</div>
                                                <div class="value">{{$paper['questionCount']}}</div>
                                            </div>
                                            <div class="ub-pair">
                                                <div class="name">总分数：</div>
                                                <div class="value">{{$paper['totalScore']}}</div>
                                            </div>
                                            <div class="ub-pair">
                                                <div class="name">答题时间：</div>
                                                <div class="value">
                                                    @if($paper['timeLimitEnable'])
                                                        {{$paper['timeLimitValue']}}分钟
                                                    @else
                                                        不限时
                                                    @endif
                                                </div>
                                            </div>
                                            @if($paper['_category'])
                                                <div class="ub-pair">
                                                    <div class="name">分类：</div>
                                                    <div class="value">{{$paper['_category']['name']}}</div>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="action ub-text-right">
                                            <a class="btn" href="/paper/view/{{$paper['alias']}}">进入练习</a>
                                            @if($_memberUserId)
                                                <a class="btn" href="/paper_exam/view/{{$paper['alias']}}">参加考试</a>
                                            @else
                                                <a class="btn" href="/login?redirect={{urlencode('/paper_exam/view/'.$paper['alias'].'')}}">登录并参加考试</a>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                            @if(empty($papers))
                                <div class="ub-empty">暂无记录</div>
                            @endif
                        </div>
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">

                <div class="ub-panel margin-top">
                    <div class="body">
                        <div class="ub-search-block-a mini">
                            <input class="input" type="text" placeholder="搜索 试卷" id="keyword" onkeypress="if(event.keyCode===13){window.location.href='/paper/search?keywords='+window.api.util.urlencode($(this).val());}" />
                            <a class="search-btn" href="javascript:;" onclick="window.location.href='/paper/search?keywords='+window.api.util.urlencode($(this).prev().val());"><span class="uk-icon-search"></span> 搜索</a>
                        </div>
                    </div>
                </div>

                <div class="ub-menu simple">
                    <a class="title @if(!$categoryId) active @endif" href="/news">全部</a>
                    @foreach($paperCategories as $category)
                        <a class="title @if($category['id']==$categoryId) active @endif" href="/paper?categoryId={{$category['id']}}">{{$category['name']}}</a>
                    @endforeach
                </div>


                @if(!empty($ads))
                    <div class="ub-panel" style="margin-top:1rem;">
                        <div class="body">
                            @foreach($ads as $ad)
                                @if($ad['link'])
                                    <a class="item" href="{{$ad['link']}}" target="_blank">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </a>
                                @else
                                    <div class="item">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
        </div>

    </div>


@endsection