@extends($_viewFrame)

@section('pageTitleMain',htmlspecialchars($paper['title']))

{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}
{!! \ModStart\ModStart::css('vendor/Paper/style/paper.css') !!}
{!! \ModStart\ModStart::js('vendor/Paper/entry/paperView.js') !!}

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/paper">试卷</a>
            <a class="active" href="javascript:;">{{$paper['title']}}</a>
        </div>

        <div class="row">
            <div class="col-md-9">

                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            {{$paper['title']}}
                        </div>
                    </div>
                </div>

                @if(!empty($paperQuestions))
                    <?php $paperQuestionNumber = 1; ?>
                    @foreach($paperQuestions as $paperQuestionIndex=>$paperQuestion)
                        <?php $questionData = &$paperQuestion['_questionData']; ?>
                        <?php $paperQuestionNumberCount = count($paperQuestion['score']); ?>
                        @if($questionData['question']['type']==\Module\Question\Type\QuestionType::SINGLE_CHOICE)
                            @include('module::Question.View.public.questionWebView.viewSingleChoice')
                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::MULTI_CHOICES)
                            @include('module::Question.View.public.questionWebView.viewMultiChoices')
                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TRUE_FALSE)
                            @include('module::Question.View.public.questionWebView.viewTrueFalse')
                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::FILL)
                            @include('module::Question.View.public.questionWebView.viewFill')
                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TEXT)
                            @include('module::Question.View.public.questionWebView.viewText')
                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::GROUP)
                            @include('module::Question.View.public.questionWebView.viewGroup')
                        @else
                            @include('module::Question.View.public.questionWebView.viewDeleted')
                        @endif
                        <?php $paperQuestionNumber += $paperQuestionNumberCount; ?>
                    @endforeach
                @endif

            </div>
            <div class="col-md-3">

                <div class="pb-paper-exam-sticky">

                    <div class="pb-paper-exam-panel" >
                        <div class="body">

                            <div class="questions">
                                <div class="label">
                                    <i class="uk-icon-list-alt"></i>
                                    答题卡
                                </div>
                                <div class="list">
                                    <?php $paperQuestionNumber = 1; ?>
                                    @foreach($paperQuestions as $paperQuestionIndex=>$paperQuestion)
                                        <?php $questionData = &$paperQuestion['_questionData']; ?>
                                        <?php $paperQuestionNumberCount = count($paperQuestion['score']); ?>
                                        @if($questionData['question']['type']==\Module\Question\Type\QuestionType::SINGLE_CHOICE)
                                            <a href="javascript:;" data-alias="{{$questionData['question']['alias']}}">{{$paperQuestionNumber}}</a>
                                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::MULTI_CHOICES)
                                            <a href="javascript:;" data-alias="{{$questionData['question']['alias']}}">{{$paperQuestionNumber}}</a>
                                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TRUE_FALSE)
                                            <a href="javascript:;" data-alias="{{$questionData['question']['alias']}}">{{$paperQuestionNumber}}</a>
                                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::FILL)
                                            @foreach($paperQuestion['score'] as $i=>$score)
                                                <a href="javascript:;" data-alias="{{$questionData['question']['alias']}}-{{$i}}">{{$paperQuestionNumber+$i}}</a>
                                            @endforeach
                                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TEXT)
                                            @foreach($paperQuestion['score'] as $i=>$score)
                                                <a href="javascript:;" data-alias="{{$questionData['question']['alias']}}-{{$i}}">{{$paperQuestionNumber+$i}}</a>
                                            @endforeach
                                        @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::GROUP)
                                            <?php $num = 0; $questionItemNumber = 1; ?>
                                            @foreach($questionData['items'] as $i=>$questionItem)
                                                @if($questionItem['question']['type']==\Module\Question\Type\QuestionType::SINGLE_CHOICE)
                                                    <a href="javascript:;" data-alias="{{$questionItem['question']['alias']}}">{{$paperQuestionNumber+($num++)}}</a>
                                                @elseif($questionItem['question']['type']==\Module\Question\Type\QuestionType::MULTI_CHOICES)
                                                    <a href="javascript:;" data-alias="{{$questionItem['question']['alias']}}">{{$paperQuestionNumber+($num++)}}</a>
                                                @elseif($questionItem['question']['type']==\Module\Question\Type\QuestionType::TRUE_FALSE)
                                                    <a href="javascript:;" data-alias="{{$questionItem['question']['alias']}}">{{$paperQuestionNumber+($num++)}}</a>
                                                @elseif($questionItem['question']['type']==\Module\Question\Type\QuestionType::FILL)
                                                    @foreach($questionItem['answers'] as $j=>$answer)
                                                        <a href="javascript:;" data-alias="{{$questionItem['question']['alias']}}">{{$paperQuestionNumber+($num++)}}</a>
                                                    @endforeach
                                                @elseif($questionItem['question']['type']==\Module\Question\Type\QuestionType::TEXT)
                                                    <a href="javascript:;" data-alias="{{$questionItem['question']['alias']}}">{{$paperQuestionNumber+($num++)}}</a>
                                                @endif
                                                <?php $questionItemNumber++; ?>
                                            @endforeach
                                        @else
                                            {{json_encode($paperQuestion['score'])}}
                                        @endif
                                        <?php $paperQuestionNumber += $paperQuestionNumberCount; ?>
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>


                    <div class="pb-paper-exam-summary">
                        <div class="body">

                            <div class="attr">
                                <div class="line">
                                    <i class="uk-icon-certificate"></i> 题目总数：{{$paper['questionCount']}}
                                </div>
                                <div class="line">
                                    <i class="uk-icon-check-circle-o"></i> 总分数：{{$paper['totalScore']}}
                                </div>
                                <div class="line">
                                    @if($paper['timeLimitEnable'])
                                        <i class="iconfont icon-time"></i> 时间：{{$paper['timeLimitValue']}}分钟
                                    @else
                                        <i class="iconfont icon-time"></i> 时间：不限时
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>

    </div>


@endsection