<?php
 namespace Module\Paper\Web\Controller; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\PageHtmlUtil; use ModStart\Module\ModuleBaseController; use Module\Ad\Util\AdUtil; use Module\Paper\Util\PaperUtil; class PaperController extends ModuleBaseController { private $api; public function __construct() { $this->api = app(\Module\Paper\Api\Controller\PaperController::class); } public function index() { $input = InputPackage::buildFromInput(); $categoryId = $input->getInteger('categoryId'); InputPackage::mergeToInput('search', json_encode([ 'categoryId' => $categoryId, ])); $paginateData = Response::tryGetData($this->api->listPublic()); $pageHtml = PageHtmlUtil::render($paginateData['total'], $paginateData['pageSize'], $paginateData['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); return $this->view('paper.list', [ 'pageHtml' => $pageHtml, 'papers' => $paginateData['records'], 'paperCategories' => PaperUtil::listCategories(), 'categoryId' => $categoryId, 'ads' => AdUtil::listByPositionWithCache('pcPaperListRight') ]); } public function search() { $result = Response::tryGetData($this->api->search()); $result['pageHtml'] = PageHtmlUtil::render($result['total'], $result['pageSize'], $result['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); return $this->view('paper.search', $result); } public function views($alias) { InputPackage::mergeToInput('alias', $alias); $paper = Response::tryGetData($this->api->get()); if (!$paper['isPublic']) { return Response::send(-1, '试卷未公开'); } $paperQuestions = Response::tryGetData($this->api->listQuestions()); return $this->view('paper.view', [ 'paper' => $paper, 'paperQuestions' => $paperQuestions ]); } }