<?php
 namespace Module\Question\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Core\Input\Response; use ModStart\Form\Form; use ModStart\Repository\RepositoryUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\ES\ESBaseUtil; class ConfigController extends Controller { public function setting(AdminConfigBuilder $builder) { $builder->pageTitle('题库设置'); $builder->switch('moduleQuestionEnable', '题库功能开启')->help('开启后，用户可不登录查看题目内容，方便搜索引擎收录'); $builder->number('moduleQuestionMaxPage', '题目列表最大显示页数')->help('默认为20'); $builder->number('moduleQuestionSearchQuestionMaxPage', '题目搜索最大显示页数')->help('默认为20'); $builder->formClass('wide'); return $builder->perform(); } public function es(AdminConfigBuilder $builder) { $builder->pageTitle('全文搜索功能设置'); $builder->switch('moduleESEnable', '开启全文索引')->help('需要配置ElasticSearch'); $builder->text('moduleESHost', 'ElasticSearch地址')->help(''); $builder->number('moduleESPort', 'ElasticSearch端口')->help(''); $builder->text('moduleESUser', 'ElasticSearch用户')->help(''); $builder->text('moduleESPass', 'ElasticSearch密码')->help(''); $builder->formClass('wide'); $builder->hookSaving(function (Form $form) { $data = $form->dataForming(); try { $client = ESBaseUtil::client([ 'host' => $data['moduleESHost'], 'port' => $data['moduleESPort'], 'scheme' => 'http', 'user' => $data['moduleESUser'], 'pass' => $data['moduleESPass'] ]); $info = $client->info(); } catch (\Exception $e) { return Response::generateError('配置信息错误（' . $e->getMessage() . '）'); } }); return $builder->perform(); } public function vip(AdminConfigBuilder $builder) { $builder->pageTitle('VIP配额'); $map = MemberVipUtil::map(); $value = []; foreach (MemberVipUtil::all() as $item) { $builder->number("X$item[id]", $item['title'] . ' - ' . $item['flag'] . ' 每天看题数'); $value["X$item[id]"] = $map[$item['id']]['quotaQuestionViewDaily']; } $builder->formClass('wide-2'); return $builder->perform(RepositoryUtil::itemFromArray($value), function (Form $form) { $data = $form->dataForming(); foreach ($data as $k => $v) { MemberVipUtil::update(intval(trim($k, 'X')), ['quotaQuestionViewDaily' => intval($v)]); } }); } }