<?php
 namespace Module\Question\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Field\AbstractField; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Member\Util\MemberCmsUtil; class QuestionCommentController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('question_comment') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->display('questionId', '题目')->hookRendering(function (AbstractField $field, $item, $index) { $question = ModelUtil::getWithCache('question', ['id' => $item['questionId']]); if (!empty($question)) { return "<a href='/question/view/{$question['alias']}' target='_blank'>{$question['question']}</a>"; } return '-'; }); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return MemberCmsUtil::showFromId($item->memberUserId); }); $builder->richHtml('content', '内容')->listable(true); $builder->display('created_at', L('Created At')); $builder->display('updated_at', L('Updated At'))->listable(false); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->like('content', '内容'); }) ->canShow(false)->canEdit(false) ->title('评论管理'); } }