<?php
 namespace Module\Question\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Str; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\HtmlUtil; use ModStart\Core\Util\TagUtil; use ModStart\Field\AbstractField; use ModStart\Field\Tags; use ModStart\Field\Type\FieldRenderMode; use ModStart\Grid\Filter\AbstractFilter; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Support\Concern\HasFields; use Module\Question\Type\QuestionType; use Module\Question\Util\ESUtil; use Module\Question\Util\QuestionUtil; class QuestionController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('question') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->type('type', '类型')->type(QuestionType::class); $builder->richHtml('question', '题目')->listable(true)->hookRendering(function (AbstractField $field, $item, $index) { switch ($field->renderMode()) { case FieldRenderMode::DETAIL: return view('module::Question.View.admin.question.questionView', QuestionUtil::getQuestionData($item->id)); default: return "<a href='/question/view/{$item->alias}' target='_blank'>{$item->question}</a>"; } }); $builder->tags('tag', '标签')->tagModel('question_tag')->serializeType(Tags::SERIALIZE_TYPE_COLON_SEPARATED); $builder->display('_status', '点击/测试/通过')->hookRendering(function (AbstractField $field, $item, $index) { return join(' / ', [intval($item->clickCount), intval($item->testCount), intval($item->passCount)]); })->addable(false)->editable(false)->showable(false); $builder->display('created_at', L('Created At'))->listable(false); $builder->display('updated_at', L('Updated At'))->listable(false); }) ->gridFilder(function (GridFilter $filter) { $filter->fixScope()->where('parentId', 0); $filter->eq('id', L('ID')); $filter->eq('type', '类型')->select(QuestionType::class); $filter->like('question', '题目'); $filter->likes('tag', '标签')->groupTags(QuestionUtil::getTags(), Tags::SERIALIZE_TYPE_COLON_SEPARATED); }) ->canBatchDelete(true) ->addBlankPage(true)->editBlankPage(true) ->title('题目管理'); } public function delete() { AdminPermission::demoCheck(); ModelUtil::transactionBegin(); foreach (CRUDUtil::ids() as $questionId) { $ret = QuestionUtil::isQuestionDeletable($questionId); if ($ret['code']) { ModelUtil::transactionRollback(); return Response::send(-1, $ret['msg']); } QuestionUtil::deleteQuestion($questionId); } ModelUtil::transactionCommit(); return Response::jsonSuccess(); } public function add() { return $this->addOrEdit(0); } public function edit() { return $this->addOrEdit(CRUDUtil::id()); } private function addOrEdit($id) { if (Request::isPost()) { AdminPermission::demoCheck(); $input = InputPackage::buildFromInputJson('data'); $question = []; $question['question'] = trim($input->getTrimString('question')); $question['source'] = trim($input->getTrimString('source')); $question['type'] = $input->getType('type', QuestionType::class); $question['tag'] = TagUtil::array2String($input->getArray('tag')); $question['itemCount'] = 0; $question['questionText'] = HtmlUtil::text($question['question']); $questionAnalysis = []; $questionAnalysis ['analysis'] = trim($input->getTrimString('analysis')); $questionOptions = []; $questionAnswers = []; $questionItems = []; BizException::throwsIf('题目不能为空', empty($question['question'])); BizException::throwsIf('题目标签为空', empty($question['tag'])); switch ($question['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $optionMap = [ QuestionType::SINGLE_CHOICE => 'singleChoiceOption', QuestionType::MULTI_CHOICES => 'multiChoicesOption', QuestionType::TRUE_FALSE => 'trueFalseOption', ]; $options = $input->getArray($optionMap[$question['type']]); $questionOptions = []; foreach ($options as $option) { $op = trim($option['option']); if (empty($op)) { continue; } $questionOption = []; $questionOption['isAnswer'] = ($option['isAnswer'] ? true : false); $questionOption['option'] = $op; $questionOptions[] = $questionOption; } BizException::throwsIf('题目选项为空', empty($questionOptions)); $answerExists = false; foreach ($questionOptions as $questionOption) { if ($questionOption['isAnswer']) { $answerExists = true; break; } } BizException::throwsIf('题目未设置答案', !$answerExists); $question['itemCount'] = 1; break; case QuestionType::FILL: foreach ($input->getArray('fillAnswer', []) as $answer) { $questionAnswers[] = [ 'answer' => $answer['answer'], ]; } BizException::throwsIf('题目答案为空', empty($questionAnswers)); $question['itemCount'] = count($questionAnswers); break; case QuestionType::TEXT: $answers = $input->getArray('textAnswer', []); BizException::throwsIf('题目答案为空', empty($answers[0]['answer'])); $questionAnswers[] = [ 'answer' => $answers[0]['answer'], ]; $question['itemCount'] = 1; break; case QuestionType::GROUP: $itemCount = 0; foreach ($input->getArray('items', []) as $index => $questionItem) { $item = []; $item['question'] = $questionItem['question']; $item['type'] = $questionItem['type']; switch ($item['type']) { case QuestionType::SINGLE_CHOICE: $item['singleChoiceOption'] = $questionItem['singleChoiceOption']; $item['itemCount'] = 1; $itemCount++; break; case QuestionType::MULTI_CHOICES: $item['multiChoicesOption'] = $questionItem['multiChoicesOption']; $item['itemCount'] = 1; $itemCount++; break; case QuestionType::TRUE_FALSE: $item['trueFalseOption'] = $questionItem['trueFalseOption']; $item['itemCount'] = 1; $itemCount++; break; case QuestionType::FILL: $item['fillAnswer'] = $questionItem['fillAnswer']; $item['itemCount'] = count($item['fillAnswer']); $itemCount += count($item['fillAnswer']); break; case QuestionType::TEXT: $item['textAnswer'] = $questionItem['textAnswer']; $item['itemCount'] = 1; $itemCount++; break; } $questionItems [] = $item; } BizException::throwsIf('题目为空', empty($questionItems)); $question['itemCount'] = $itemCount; break; default: return Response::send(-1, '题目类型未能识别'); } $debugData = [ 'id' => $id, 'question' => $question, 'analysis' => $questionAnalysis, 'questionOptions' => $questionOptions, 'questionAnswers' => $questionAnswers, 'questionItems' => $questionItems, ]; BizException::throwsIf('题目重复', !$id && ModelUtil::exists('question', ['question' => $question['question']])); ModelUtil::transactionBegin(); if ($id) { ModelUtil::update('question', ['id' => $id], $question); $question['id'] = $id; } else { $question['parentId'] = 0; $question['clickCount'] = 0; $question['testCount'] = 0; $question['passCount'] = 0; $question['alias'] = strtolower(Str::random(16)); $question = ModelUtil::insert('question', $question); } if (modstart_config()->getWithEnv('moduleESEnable', false)) { ESUtil::syncQuestions([$question]); } if ($id && ModelUtil::exists('question_analysis', ['questionId' => $id])) { ModelUtil::update('question_analysis', ['questionId' => $question['id']], $questionAnalysis); } else { $questionAnalysis['questionId'] = $question['id']; ModelUtil::insert('question_analysis', $questionAnalysis); } if ($id) { ModelUtil::delete('question_option', ['questionId' => $question['id']]); } foreach ($questionOptions as $questionOption) { $questionOption['questionId'] = $question['id']; ModelUtil::insert('question_option', $questionOption); } if ($id) { ModelUtil::delete('question_answer', ['questionId' => $question['id']]); } foreach ($questionAnswers as $questionAnswer) { $questionAnswer['questionId'] = $question['id']; ModelUtil::insert('question_answer', $questionAnswer); } if ($id) { $ids = ModelUtil::values('question', 'id', ['parentId' => $id]); if (!empty($ids)) { foreach ($ids as $idsId) { ModelUtil::delete('question', ['id' => $idsId]); ModelUtil::delete('question_option', ['questionId' => $idsId]); ModelUtil::delete('question_answer', ['questionId' => $idsId]); ModelUtil::delete('question_analysis', ['questionId' => $idsId]); } } } foreach ($questionItems as $questionItem) { $questionItemAdd = ModelUtil::insert('question', [ 'alias' => strtolower(Str::random(16)), 'parentId' => $question['id'], 'question' => $questionItem['question'], 'type' => $questionItem['type'], 'itemCount' => $questionItem['itemCount'], 'clickCount' => 0, 'testCount' => 0, 'passCount' => 0, ]); switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: foreach ($questionItem['singleChoiceOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::MULTI_CHOICES: foreach ($questionItem['multiChoicesOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::TRUE_FALSE: foreach ($questionItem['trueFalseOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::FILL: foreach ($questionItem['fillAnswer'] as $answer) { ModelUtil::insert('question_answer', [ 'questionId' => $questionItemAdd['id'], 'answer' => $answer['answer'], ]); } break; case QuestionType::TEXT: foreach ($questionItem['textAnswer'] as $answer) { ModelUtil::insert('question_answer', [ 'questionId' => $questionItemAdd['id'], 'answer' => $answer['answer'], ]); } break; } } ModelUtil::transactionCommit(); return Response::send(0, null, null, action('\\' . __CLASS__ . ($input->getBoolean('next') ? '@add' : '@index'))); } $data = [ 'id' => $id, 'type' => QuestionType::SINGLE_CHOICE, 'source' => '', 'question' => '', 'tag' => [], 'analysis' => '', 'singleChoiceOption' => [ ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ], 'multiChoicesOption' => [ ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ], 'trueFalseOption' => [ ['isAnswer' => false, 'option' => '正确'], ['isAnswer' => false, 'option' => '错误'], ], 'fillAnswer' => [ ['answer' => ''], ], 'textAnswer' => [ ['answer' => ''], ], "items" => [ ], ]; if ($id) { $question = ModelUtil::get('question', ['id' => $id]); $data['type'] = $question['type']; $data['source'] = $question['source']; $data['question'] = $question['question']; $data['tag'] = TagUtil::string2Array($question['tag']); foreach ($data['tag'] as &$questionTag) { $questionTag = intval($questionTag); } $questionAnalysis = ModelUtil::get('question_analysis', ['questionId' => $question['id']]); $data['analysis'] = $questionAnalysis['analysis']; switch ($question['type']) { case QuestionType::SINGLE_CHOICE: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['singleChoiceOption'] = $options; break; case QuestionType::MULTI_CHOICES: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['multiChoicesOption'] = $options; break; case QuestionType::TRUE_FALSE: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['trueFalseOption'] = $options; break; case QuestionType::FILL: $data["fillAnswer"] = ModelUtil::model('question_answer')->where(['questionId' => $question['id']])->orderBy('id', 'asc')->get()->toArray(); break; case QuestionType::TEXT: $questionAnswer = ModelUtil::get('question_answer', ['questionId' => $question['id']]); $data['textAnswer'] = [ ['answer' => $questionAnswer['answer']] ]; break; case QuestionType::GROUP: $data['items'] = []; $questionItems = ModelUtil::model('question')->where(['parentId' => $question['id']])->orderBy('id', 'asc')->get()->toArray(); foreach ($questionItems as $questionItem) { $item = []; $item['question'] = $questionItem['question']; $item['type'] = $questionItem['type']; switch ($item['type']) { case QuestionType::SINGLE_CHOICE: $item['singleChoiceOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['singleChoiceOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::MULTI_CHOICES: $item['multiChoicesOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['multiChoicesOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::TRUE_FALSE: $item['trueFalseOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['trueFalseOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::FILL: $item["fillAnswer"] = ModelUtil::model('question_answer')->where(['questionId' => $questionItem['id']])->orderBy('id', 'asc')->get()->toArray(); break; case QuestionType::TEXT: $questionAnswer = ModelUtil::get('question_answer', ['questionId' => $questionItem['id']]); $item['textAnswer'] = [ ['answer' => $questionAnswer['answer']] ]; break; } $data["items"][] = $item; } break; } } $paperUsed = null; if ($id > 0 && ModuleManager::isModuleInstalled('Paper') && $paperQuestion = ModelUtil::get('paper_question', ['questionId' => $id])) { $paperUsed = ModelUtil::get('paper', ['id' => $paperQuestion['paperId']]); } return view('module::Question.View.admin.question.edit', [ 'pageTitle' => '题目编辑', 'data' => $data, 'paperUsed' => $paperUsed, ]); } public function select(AdminDialogPage $page) { $grid = $this->grid(); $grid->disableCUD(); $grid->canBatchSelect(true); CRUDUtil::registerGridResource($grid, '\\' . __CLASS__); if (Request::isPost()) { return $grid->request(); } return $page->pageTitle('题目选择')->body($grid); } public function preview() { $ids = CRUDUtil::ids(); $records = []; foreach ($ids as $id) { $item = []; $questionData = QuestionUtil::getQuestionData($id); if (empty($questionData)) { continue; } $item['id'] = $questionData['question']['id']; $item['html'] = view('module::Question.View.public.questionView', $questionData)->render(); $item['itemCount'] = $questionData['question']['itemCount']; $item['questionData'] = $questionData; $score = []; for ($i = 0; $i < $item['itemCount']; $i++) { $score[] = 5; } $item['score'] = $score; $records[] = $item; } return Response::jsonSuccessData(['records' => $records]); } public function import() { return view('module::Question.View.admin.question.import', [ 'pageTitle' => '题目导入', ]); } }