<?php
 namespace Module\Question\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\Response; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Question\Util\QuestionUtil; class QuestionTagController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('question_tag') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->select('groupId', '标签组')->optionModelTree('question_tag_group'); $builder->text('title', '名称'); $builder->image('cover', '图标'); $builder->textarea('description', '说明'); $builder->display('created_at', L('Created At'))->listable(false); $builder->display('updated_at', L('Updated At'))->listable(false); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->like('title', L('Title')); }) ->canShow(false) ->title('题目标签'); } public function all() { return Response::jsonSuccessData(QuestionUtil::getTags()); } public function map() { $tagGroupMap = ModelUtil::valueMap('question_tag_group', 'id', 'title'); $tagMap = array_build(ModelUtil::all('question_tag'), function ($k, $v) use ($tagGroupMap) { $name = $v['title']; if ($v['groupId']) { if (!empty($tagGroupMap[$v['groupId']])) { $name = $tagGroupMap[$v['groupId']] . '-' . $name; } } return [$name, $v['id']]; }); return Response::jsonSuccessData($tagMap); } }