<?php
 namespace Module\Question\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\HtmlUtil; use Module\Member\Auth\MemberUser; use Module\Question\Util\QuestionCommentUtil; use Module\Question\Util\QuestionUtil; class QuestionCommentController extends Controller { public function lists() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $question = QuestionUtil::getQuestion($input->getTrimString('alias')); if (empty($question)) { return Response::generateError('题目不存在'); } $paginateData = QuestionCommentUtil::paginate($question['id'], $input->getPage(), $input->getPageSize()); return Response::generateSuccessPaginate($input->getPage(), $input->getPageSize(), $paginateData); } public function post() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } if (!MemberUser::id()) { return Response::generateError('没有登录'); } $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); $content = $input->getTrimString('content'); $content = HtmlUtil::filter($content); if (empty($content)) { return Response::generateError('评论内容不能为空'); } $question = QuestionUtil::getQuestion($alias); if (empty($question)) { return Response::generateError('question empty'); } QuestionCommentUtil::post(MemberUser::id(), $question['id'], $content); QuestionCommentUtil::updateQuestionCommentCount($question['id']); return Response::generateSuccess('评论成功'); } public function delete() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $comment = ModelUtil::get('question_comment', $id); if (empty($comment)) { return Response::generateError('评论不存在'); } if ($comment['memberUserId'] != MemberUser::id()) { return Response::generateError('没有权限'); } QuestionCommentUtil::delete($comment['id']); QuestionCommentUtil::updateQuestionCommentCount($comment['questionId']); return Response::generateSuccess(); } }