<?php
 namespace Module\Question\Api\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Str; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\HtmlUtil; use ModStart\Core\Util\TagUtil; use Module\Ad\Util\AdUtil; use Module\Member\Auth\MemberUser; use Module\Member\Auth\MemberVip; use Module\Member\Util\MemberFavoriteUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Question\Constant\QuestionConstant; use Module\Question\Type\QuestionType; use Module\Question\Util\ESUtil; use Module\Question\Util\QuestionMemberVipQuotaUtil; use Module\Question\Util\QuestionUtil; class QuestionController extends Controller { protected function getSearchWhereRaw($selectedTagIds) { $groupMap = QuestionUtil::getTagGroupMap(); $searchTagGroups = []; foreach ($selectedTagIds as $selectedTagsId) { if (empty($groupMap[$selectedTagsId])) { continue; } if (empty($searchTagGroups[$groupMap[$selectedTagsId]])) { $searchTagGroups[$groupMap[$selectedTagsId]] = []; } $searchTagGroups[$groupMap[$selectedTagsId]][] = $selectedTagsId; } if (!empty($searchTagGroups)) { $where = []; foreach ($searchTagGroups as $groupId => $tagIds) { $items = []; foreach ($tagIds as $tagId) { $items[] = "tag like '%:" . intval($tagId) . ":%'"; } $where[] = '( ' . join(' OR ', $items) . ' )'; } return join(' AND ', $where); } return null; } public function parseUrlParm($urlParam) { $questionType = null; $keyword = null; $tagIds = []; foreach (explode('_', $urlParam) as $tagId) { if (Str::startsWith($tagId, 't')) { $questionType = intval(substr($tagId, 1)); continue; } if (Str::startsWith($tagId, 'k')) { $keyword = trim(substr($tagId, 1)); continue; } $tagId = intval($tagId); if (empty($tagId)) { continue; } $tagIds[] = $tagId; } return [ 'type' => $questionType, 'keyword' => $keyword, 'tagIds' => $tagIds, ]; } public function lists($callback = null) { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $searchInput = $input->getJsonAsInput('search'); $pageSize = 10; $maxPage = modstart_config()->getInteger('moduleQuestionMaxPage', 20); $page = min($input->getInteger('page', 1), $maxPage); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['where']['parentId'] = 0; $questionType = $searchInput->getInteger('type'); if ($questionType) { $option['where']['type'] = $questionType; } $tagIds = $searchInput->getArray('tagIds'); if (count($tagIds) > 5) { return Response::generateError('最多只能包含5个标签'); } $option['whereRaw'] = $this->getSearchWhereRaw($tagIds); $keyword = $searchInput->getTrimString('keyword'); if ($keyword) { $option['whereOperate'][] = ['question', 'like', '%' . $keyword . '%']; } if (null !== $callback) { $option = call_user_func($callback, $option); } $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $questions = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); foreach ($questions as $i => $question) { $questions[$i]['_title'] = HtmlUtil::text($question['question'], 100); $questions[$i]['_correctRate'] = $question['testCount'] > 0 ? sprintf('%d%%', $question['passCount'] * 100 / $question['testCount']) : '-'; } return Response::generateSuccessData([ 'total' => $paginateData['total'], 'records' => $questions, 'page' => $page, 'pageSize' => $pageSize, ]); } public function get() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); $param = $input->getTrimString('param'); $questionData = QuestionUtil::getQuestionData(null, $alias); if (empty($questionData)) { return Response::generateError('题目不存在'); } $questionData['question']['tag'] = TagUtil::string2Array($questionData['question']['tag']); $questionData['question']['tag'] = TagUtil::mapInfo($questionData['question']['tag'], QuestionUtil::getTagMap()); QuestionUtil::questionClick($questionData['question']['id']); $previousQuestion = null; $nextQuestion = null; $parsedUrlParam = $this->parseUrlParm($param); $type = $parsedUrlParam['type']; $keyword = $parsedUrlParam['keyword']; $tagIds = $parsedUrlParam['tagIds']; InputPackage::mergeToInputAll($parsedUrlParam, 'search'); InputPackage::mergeToInput('page', 1); InputPackage::mergeToInput('pageSize', 1); $retData = Response::tryGetData($this->lists(function ($option) use ($questionData) { $option['whereOperate'] = array_prepend($option['whereOperate'], null); $option['order'] = ['id', 'asc']; $option['whereOperate'][0] = ['id', '>', $questionData['question']['id']]; return $option; })); if (!empty($retData['records'])) { $previousQuestion = $retData['records'][0]; } $retData = Response::tryGetData($this->lists(function ($option) use ($questionData) { $option['whereOperate'] = array_prepend($option['whereOperate'], null); $option['order'] = ['id', 'desc']; $option['whereOperate'][0] = ['id', '<', $questionData['question']['id']]; return $option; })); if (!empty($retData['records'])) { $nextQuestion = $retData['records'][0]; } $hasFavorite = MemberFavoriteUtil::exists(MemberUser::id(), QuestionConstant::MEMBER_FAVORITE_CATEGORY, $questionData['question']['id']); list($questionData, $questionDataOriginal) = QuestionUtil::filterQuestionData($questionData); return Response::generateSuccessData([ 'questionData' => $questionData, 'previousQuestion' => $previousQuestion, 'nextQuestion' => $nextQuestion, 'param' => $param, 'ads' => AdUtil::listByPositionWithCache('pcQuestionViewRight'), 'hasFavorite' => $hasFavorite ] ); } public function latest() { return $this->lists(); } public function answer() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } $input = InputPackage::buildFromInput(); $alias = $input->getTrimString('alias'); if (!MemberUser::id()) { return Response::generateError('请先登录'); } $questionData = QuestionUtil::getQuestionData(null, $alias); if (empty($questionData)) { return Response::generateError('题目不存在'); } if (MemberVipUtil::isEnable()) { if ($questionData['question']['type'] != QuestionType::GROUP) { $memberVip = MemberVip::get(); if (empty($memberVip)) { return Response::generateError('您的会员不存在，点击立即开通', null, '/member_vip'); } if (QuestionMemberVipQuotaUtil::questionViewCountToday(MemberUser::id()) >= $memberVip['quotaQuestionViewDaily']) { return Response::generateError('您每天最多只能看' . $memberVip['quotaQuestionViewDaily'] . '个题目，立即升级会员', null, '/member_vip'); } QuestionMemberVipQuotaUtil::questionViewPut(MemberUser::id(), $questionData['question']['id']); } else { foreach ($questionData['items'] as $item) { if (!QuestionMemberVipQuotaUtil::questionViewed(MemberUser::id(), $item['question']['id'])) { return Response::generateError('当前题目组的所有问题未查看完成，不能查看题目组解析'); } } } } $input = InputPackage::buildFromInput(); $answer = $input->get('answer'); $answerInfo = QuestionUtil::parseAnswerInfo($questionData, $answer); if ($answerInfo['judge']) { QuestionUtil::increaseQuestionTestCount($questionData['question']['id']); if ($answerInfo['correct']) { QuestionUtil::increaseQuestionPassCount($questionData['question']['id']); } } list($questionData, $questionDataOriginal) = QuestionUtil::filterQuestionData($questionData); $questionData['analysis'] = $questionDataOriginal['analysis']; return Response::generateSuccessData([ 'answer' => $answer, 'questionData' => $questionData, 'answerInfo' => $answerInfo, ]); } public function search() { $input = InputPackage::buildFromInput(); $page = $input->getInteger('page', 1); $pageSize = $input->getInteger('pageSize', 20); $keywords = $input->getTrimString('keywords'); $maxPage = modstart_config()->getInteger('moduleQuestionSearchQuestionMaxPage', 20); $page = min($page, $maxPage); $option = []; if (modstart_config()->getWithEnv('moduleESEnable', false) && $keywords) { $option = []; $option['search'] = [['keywords' => ['like' => $keywords]]]; $esPaginateData = ESUtil::paginateQuestion($page, $pageSize, $option); $paginateData = []; $paginateData['total'] = $esPaginateData['total']; $paginateData['records'] = QuestionUtil::listQuestions(array_map(function ($item) { return $item['id']; }, $esPaginateData['records'])); $records = $paginateData['records']; } else { $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['questionText', 'like', '%' . $keywords . '%']; $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $records = $paginateData['records']; } $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); foreach ($records as $i => $question) { $records[$i]['_title'] = HtmlUtil::text($question['question'], 100); $records[$i]['_correctRate'] = $question['testCount'] > 0 ? sprintf('%d%%', $question['passCount'] * 100 / $question['testCount']) : '-'; } $viewData = []; $viewData['pageTitle'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['page'] = $page; $viewData['pageSize'] = $pageSize; $viewData['total'] = $paginateData['total']; return Response::generateSuccessData($viewData); } }