<?php
 namespace Module\Question\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\HtmlUtil; use ModStart\Core\Util\TagUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; use Module\Member\Util\MemberFavoriteUtil; use Module\Question\Constant\QuestionConstant; use Module\Question\Util\QuestionUtil; class QuestionFavoriteMemberController extends Controller implements MemberLoginCheck { public function submit() { $input = InputPackage::buildFromInput(); $action = $input->getTrimString('action'); $categoryId = $input->getInteger('categoryId'); $category = QuestionConstant::MEMBER_FAVORITE_CATEGORY; switch ($action) { case 'favorite': MemberFavoriteUtil::add(MemberUser::id(), $category, $categoryId); break; case 'unfavorite': MemberFavoriteUtil::delete(MemberUser::id(), $category, $categoryId); break; } return Response::generateSuccess(); } public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $paginateData = MemberFavoriteUtil::paginate(MemberUser::id(), QuestionConstant::MEMBER_FAVORITE_CATEGORY, $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'categoryId', '_question', 'question', 'id'); $tagMap = QuestionUtil::getTagMap(); foreach ($paginateData['records'] as $i => $favoriteQuestion) { $question = $favoriteQuestion['_question']; $question['_title'] = HtmlUtil::text($question['question'], 100); $question['_correctRate'] = $question['testCount'] > 0 ? sprintf('%d%%', $question['passCount'] * 100 / $question['testCount']) : '-'; $question['tag'] = TagUtil::string2Array($question['tag']); $question['tag'] = TagUtil::mapInfo($question['tag'], $tagMap); $paginateData['records'][$i]['_question'] = $question; } return Response::generateSuccessData([ 'page' => $page, 'pageSize' => $pageSize, 'records' => $paginateData['records'], 'total' => $paginateData['total'], ]); } }