<?php
 namespace Module\Question\Util; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Facades\DB; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\HtmlUtil; use ModStart\Core\Util\TagUtil; use ModStart\Module\ModuleManager; use Module\Member\Util\MemberFavoriteUtil; use Module\Question\Constant\QuestionConstant; use Module\Question\Type\QuestionType; class QuestionUtil { const QUESTION_CACHE_PREFIX = 'question:'; public static function isEnable() { return modstart_config('moduleQuestionEnable', false); } public static function disabledResponse() { return Response::generateError('题目功能未开启'); } public static function isQuestionDeletable($questionId) { if (!ModelUtil::exists('question', $questionId)) { return Response::generate(-1, "题目不存在(ID=$questionId)"); } if (ModuleManager::isModuleInstalled('Paper')) { if (ModelUtil::exists('paper_question', ['questionId' => $questionId])) { return Response::generate(-1, "题目已在考卷中不可删除(ID=$questionId)"); } if (ModelUtil::exists('paper_exam_question', ['questionId' => $questionId])) { return Response::generate(-1, "题目已被考试不可删除(ID=$questionId)"); } } return true; } public static function filterQuestionData($questionData) { $questionDataOriginal = $questionData; $questionData = ArrayUtil::keepKeys($questionData, ['question', 'options', 'items']); if (!empty($questionData['items'])) { $questionData['items'] = array_map(function ($item) { if (!empty($item['options'])) { $item['options'] = ArrayUtil::keepItemsKeys($item['options'], ['id', 'option', '_key']); } $item['answer'] = null; $item['analysis'] = null; return $item; }, $questionData['items']); } if (!empty($questionData['options'])) { $questionData['options'] = ArrayUtil::keepItemsKeys($questionData['options'], ['id', 'option', '_key']); } $questionData['answer'] = null; $questionData['analysis'] = null; return [$questionData, $questionDataOriginal]; } public static function deleteQuestion($questionId, $checkChildren = true) { if ($checkChildren) { $children = ModelUtil::all('question', ['parentId' => $questionId]); if (!empty($children)) { foreach ($children as $child) { self::deleteQuestion($child['parentId'], false); } } } ModelUtil::delete('question', ['id' => $questionId]); ModelUtil::delete('question_option', ['questionId' => $questionId]); ModelUtil::delete('question_analysis', ['questionId' => $questionId]); ModelUtil::delete('question_answer', ['questionId' => $questionId]); ModelUtil::delete('question_comment', ['questionId' => $questionId]); if (ModuleManager::isModuleInstalled('Member')) { MemberFavoriteUtil::clean(QuestionConstant::MEMBER_FAVORITE_CATEGORY, $questionId); } } public static function getQuestion($alias) { return ModelUtil::get('question', ['alias' => $alias]); } public static function getQuestionData($questionId, $questionAlias = null) { $data = []; if (null === $questionAlias) { $question = ModelUtil::get('question', ['id' => $questionId]); } else { $question = ModelUtil::get('question', ['alias' => $questionAlias]); } if (empty($question)) { return null; } $data['question'] = $question; $data['analysis'] = ModelUtil::get('question_analysis', ['questionId' => $question['id']]); switch ($question['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $data['options'] = ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']); $data['options'] = array_build($data['options'], function ($k, $v) { $v['_key'] = chr(ord('A') + $k); return [$k, $v]; }); break; case QuestionType::FILL: $data['answers'] = ModelUtil::all('question_answer', ['questionId' => $question['id']], ['*'], ['id', 'asc']); break; case QuestionType::TEXT: $data['answer'] = ModelUtil::get('question_answer', ['questionId' => $question['id']]); break; case QuestionType::GROUP: $questionItems = ModelUtil::all('question', ['parentId' => $question['id']], ['*'], ['id', 'asc']); $data['items'] = []; $itemNumber = 1; foreach ($questionItems as $questionItem) { $item = []; $item['itemNumber'] = $itemNumber; $item['itemCount'] = 1; $item['question'] = $questionItem; switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $item['options'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); $item['options'] = array_build($item['options'], function ($k, $v) { $v['_key'] = chr(ord('A') + $k); return [$k, $v]; }); $itemNumber++; break; case QuestionType::FILL: $item['answers'] = ModelUtil::all('question_answer', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); $item['itemCount'] = count($item['answers']); $itemNumber += $item['itemCount']; break; case QuestionType::TEXT: $item['answer'] = ModelUtil::get('question_answer', ['questionId' => $questionItem['id']]); $itemNumber++; break; } $data['items'][] = $item; } break; } return $data; } public static function questionClick($questionId) { ModelUtil::update('question', ['id' => $questionId], ['clickCount' => DB::raw('clickCount+1')]); } public static function listQuestionTagWithCache($cacheMinutes = 30) { return Cache::remember(self::QUESTION_CACHE_PREFIX . ':questionTag', $cacheMinutes, function () { return ModelUtil::all('question_tag'); }); } public static function listQuestionTagGroupWithCache($cacheMinutes = 30) { return Cache::remember(self::QUESTION_CACHE_PREFIX . ':questionTagGroup', $cacheMinutes, function () { return ModelUtil::all('question_tag_group', [], ['*'], ['sort', 'asc']); }); } public static function getTags() { $questionTags = self::listQuestionTagWithCache(); $questionTagGroups = self::listQuestionTagGroupWithCache(); $groupTags = []; foreach ($questionTagGroups as &$questionTagGroup) { $group = []; $group['groupId'] = $questionTagGroup['id']; $group['groupTitle'] = $questionTagGroup['title']; $tags = []; foreach ($questionTags as &$questionTag) { if ($questionTag['groupId'] == $questionTagGroup['id']) { $tags[] = [ 'id' => $questionTag['id'], 'title' => $questionTag['title'], ]; } } $group['groupTags'] = $tags; $groupTags[] = $group; } return $groupTags; } public static function getTagMap() { $questionTags = ModelUtil::all('question_tag'); $map = []; foreach ($questionTags as $questionTag) { $map[$questionTag['id']] = $questionTag; } return $map; } public static function getTagGroupMap() { $tags = self::getTagMap(); $map = []; foreach ($tags as $tag) { $map[$tag['id']] = $tag['groupId']; } return $map; } public static function listTagsByIds($ids) { if (empty($ids)) { return []; } return ModelUtil::model('question_tag')->whereIn('id', $ids)->get()->toArray(); } public static function paginateQuestion($page, $pageSize, $option = []) { $option['where']['parentId'] = 0; $paginateData = ModelUtil::paginate('question', $page, $pageSize, $option); $tagMap = self::getTagMap(); foreach ($paginateData['records'] as &$item) { $item['tag'] = TagUtil::string2Array($item['tag']); $item['tag'] = TagUtil::mapInfo($item['tag'], $tagMap); } return $paginateData; } public static function listLatestQuestion($limit = 10) { $option = []; $option['order'] = ['id', 'desc']; $paginateData = QuestionUtil::paginateQuestion(1, $limit, $option); return $paginateData['records']; } public static function listQuestions($ids) { if (empty($ids)) { return []; } $questions = ModelUtil::allInWithOrder('question', 'id', $ids); $tagMap = self::getTagMap(); foreach ($questions as &$item) { $item['tag'] = TagUtil::string2Array($item['tag']); $item['tag'] = TagUtil::mapInfo($item['tag'], $tagMap); } return $questions; } public static function increaseQuestionTestCount($questionId) { ModelUtil::model('question')->where(['id' => $questionId])->increment('testCount'); } public static function increaseQuestionPassCount($questionId) { ModelUtil::model('question')->where(['id' => $questionId])->increment('passCount'); } public static function hasContent($text) { $text = trim(HtmlUtil::text($text)); return !empty($text); } public static function parseAnswerInfo($questionData, $userAnswer) { $judge = false; $correct = false; $answer = null; switch ($questionData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: foreach ($questionData['options'] as $index => $option) { if ($option['isAnswer']) { $answer = chr(ord('A') + $index); break; } } if (!empty($answer)) { $judge = true; if ($answer == $userAnswer) { $correct = true; } } break; case QuestionType::MULTI_CHOICES: $judge = true; $answer = []; foreach ($questionData['options'] as $index => $option) { if ($option['isAnswer']) { $answer[] = chr(ord('A') + $index); } } if (json_encode($answer) == json_encode($userAnswer)) { $correct = true; } break; case QuestionType::FILL: $answer = []; foreach ($questionData['answers'] as $item) { $answer[] = $item['answer']; } break; case QuestionType::TEXT: $answer = $questionData['answer']['answer']; break; } return [ 'judge' => $judge, 'correct' => $correct, 'answer' => $answer, ]; } }