@extends($_viewMemberFrame)

@section('pageTitleMain','已收藏题目')

{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}
{!! \ModStart\ModStart::js('vendor/Question/entry/questionView.js') !!}

@section('memberBodyContent')

    <div class="ub-panel">
        <div class="head">
            <div class="title">已收藏题目</div>
        </div>
        <div class="body">
            @if(empty($records))
                <div class="ub-empty">暂无记录</div>
            @endif
            <div class="pb-question-list">
                @foreach($records as $question)
                    <div class="item">
                        <div class="title">
                            <a href="/question/view/{{$question['_question']['alias']}}" target="_blank">
                                [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$question['_question']['type'])}}]
                                {{\ModStart\Core\Util\HtmlUtil::text($question['_question']['question'],200)}}
                            </a>
                        </div>
                        <div class="tags">
                            <div class="right">
                                @if($question['_question']['source'])
                                    <span>来源 {{$question['_question']['source']}}</span>
                                    |
                                @endif
                                <span>正确率 {{$question['_question']['testCount']>0?sprintf('%d%%',$question['_question']['passCount']*100/$question['_question']['testCount']):'-'}}</span>
                                |
                                <span>评论 {{$question['_question']['commentCount'] or 0}}</span>
                                |
                                <span>点击 {{$question['_question']['clickCount']}}</span>
                            </div>
                            <div data-favorite-action>
                                <a href="javascript:;" data-action="favorite" data-category-id="{{$question['_question']['id']}}" style="display:none;">
                                    <i class="uk-icon-heart-o"></i>
                                    点击收藏
                                </a>
                                <a href="javascript:;" data-action="unfavorite" data-category-id="{{$question['_question']['id']}}">
                                    <i class="uk-icon-heart"></i>
                                    取消收藏
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="body">
            <div class="ub-page">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>


@endsection