@extends($_viewFrame)

@section('pageTitle',htmlspecialchars($pageTitle))
@section('pageKeywords',htmlspecialchars($pageKeywords))
@section('pageDescription',htmlspecialchars($pageDescription))

{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a class="active" href="javascript:;">题目</a>
        </div>

        <div class="row">
            <div class="col-md-9">

                @if(!empty($selectedTags) || $type)
                    <div class="ub-nav margin-bottom">
                        <div class="tag-label">筛选</div>
                        <div class="tag-value">
                            @if($type)
                                <span class="tag-item">
                                    {{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$type)}}
                                    <a class="close" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(($keyword?'k'.urlencode($keyword):''),$selectedTagIds)}}">
                                        <i class="iconfont icon-close"></i>
                                    </a>
                                </span>
                            @endif
                            @foreach($selectedTags as $tag)
                                <?php
                                $url = [];
                                if($type){
                                    $url[] = 't'.$type;
                                }
                                if($keyword){
                                    $url[] = 'k'.urlencode($keyword);
                                }
                                ?>
                                <span class="tag-item">
                                    {{$tag['title']}}
                                    <a class="close" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(join('_',$url),$selectedTagIds,$tag['id'])}}">
                                        <i class="iconfont icon-close"></i>
                                    </a>
                                </span>
                            @endforeach
                        </div>
                    </div>
                @endif

                <div class="ub-panel">
                    <div class="head">
                        <div class="title">题目列表</div>
                    </div>
                    <div class="body">
                        @if(empty($questions))
                            <div class="ub-empty">暂无记录</div>
                        @endif
                        <div class="pb-question-list">
                            @foreach($questions as $question)
                                <div class="item">
                                    <div class="title">
                                        <a href="/question/view/{{$question['alias']}}{{$urlParam?'?param='.urlencode($urlParam):''}}">
                                            [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$question['type'])}}]
                                            {{\ModStart\Core\Util\HtmlUtil::text($question['question'],200)}}
                                        </a>
                                    </div>
                                    <div class="tags">
                                        <div class="right">
                                            @if($question['source'])
                                                <span>来源 {{$question['source']}}</span>
                                                |
                                            @endif
                                            <span>正确率 {{$question['testCount']>0?sprintf('%d%%',$question['passCount']*100/$question['testCount']):'-'}}</span>
                                            |
                                            <span>评论 {{$question['commentCount'] or 0}}</span>
                                            |
                                            <span>点击 {{$question['clickCount']}}</span>
                                        </div>
                                        @foreach($question['tag'] as $tag)
                                            <a href="/question/list/{{$tag['id']}}" target="_blank">{{$tag['title']}}</a>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">

                <div class="ub-panel margin-top">
                    <div class="body">
                        <a class="btn btn-block" style="margin:1px 0;" href="/question_tags">专项训练</a>
                    </div>
                </div>

                <div class="ub-panel" style="margin-top:1rem;">
                    <div class="body">
                        <div class="ub-search-block-a mini">
                            <input class="input" type="text" placeholder="搜索 题目" id="keyword" onkeypress="if(event.keyCode===13){window.location.href='/search/question?keywords='+window.api.util.urlencode($(this).val());}" />
                            <a class="search-btn" href="javascript:;" onclick="window.location.href='/question/search?keywords='+window.api.util.urlencode($(this).prev().val());"><span class="uk-icon-search"></span> 搜索</a>
                        </div>
                    </div>
                </div>

                <div class="ub-panel" style="margin-top:1rem;">
                    <div class="body">
                        <div class="ub-nav-category">
                            <a class="group-title" href="javascript:;">题目类型</a>
                            <div class="group-list">
                                <?php
                                $url = [];
                                if($keyword){
                                    $url[] = 'k'.urlencode($keyword);
                                }
                                ?>
                                <a  class="item @if(empty($type)) active @endif" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(join('_',$url),$selectedTagIds)}}">全部</a>
                                @foreach(\Module\Question\Type\QuestionType::getList() as $k=>$v)
                                    <?php
                                    $url = [];
                                    $url[] = 't'.$k;
                                    if($keyword){
                                        $url[] = 'k'.urlencode($keyword);
                                    }
                                    ?>
                                    <a  href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(join('_',$url),$selectedTagIds)}}"
                                        class="item @if($type==$k) active @endif">{{$v}}</a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="ub-panel" style="margin-top:1rem;">
                    <div class="body">
                        <div class="ub-nav-category">
                            @foreach($tags as $tagGroup)
                                <a class="group-title" href="javascript:;">{{$tagGroup['groupTitle']}}</a>
                                <div class="group-list">
                                    @foreach($tagGroup['groupTags'] as $tag)
                                        <?php
                                        $url = [];
                                        if($type){
                                            $url[] = 't'.$type;
                                        }
                                        if($keyword){
                                            $url[] = 'k'.urlencode($keyword);
                                        }
                                        ?>
                                        @if(in_array($tag['id'],$selectedTagIds))
                                            <a class="item active" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(join('_',$url),$selectedTagIds,$tag['id'])}}">{{$tag['title']}}</a>
                                        @else
                                            <a class="item" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin(join('_',$url),array_merge($selectedTagIds,[$tag['id']]))}}">{{$tag['title']}}</a>
                                        @endif
                                    @endforeach
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>


@endsection