@extends($_viewFrame)

@section('pageTitleMain',$pageTitle)
@section('pageKeywords',$pageKeywords)
@section('pageDescription',$pageDescription)

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}

@section('bodyAppend')
    @parent
    <script>
        $(function () {
            $(".pb-question-list .title span").mark({!! json_encode($keywords) !!}.split('').join(' '),{separateWordSearch:true});
        });
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/question">题目</a>
            <a class="active" href="javascript:;">搜索题目 “{{$keywords}}”</a>
        </div>

        <div class="ub-panel" style="margin-top:1rem;">
            <div class="body">
                <div class="ub-search-block-a">
                    <input class="input" type="text" placeholder="搜索 题目" id="keyword" value="{{$keywords or ''}}" onkeypress="if(event.keyCode===13){window.location.href='/question/search?keywords='+window.api.util.urlencode($(this).val());}" />
                    <a class="search-btn" href="javascript:;" onclick="window.location.href='/question/search?keywords='+window.api.util.urlencode($(this).prev().val());"><span class="uk-icon-search"></span> 搜索</a>
                </div>
            </div>
        </div>

        <div class="ub-panel">
            <div class="head">
                <div class="title">搜索结果</div>
            </div>
            <div class="body">
                @if(empty($records))
                    <div class="ub-empty">
                        暂无记录
                    </div>
                @endif
                <div class="pb-question-list">
                    @foreach($records as $question)
                        <div class="item">
                            <div class="title">
                                <a href="/question/view/{{$question['alias']}}">
                                    [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$question['type'])}}]
                                    <span>{{\ModStart\Core\Util\HtmlUtil::text($question['question'],100)}}</span>
                                </a>
                            </div>
                            <div class="tags">
                                <div class="right">
                                    @if($question['source'])
                                        <span>来源 {{$question['source']}}</span>
                                        |
                                    @endif
                                    <span>正确率 {{$question['testCount']>0?sprintf('%d%%',$question['passCount']*100/$question['testCount']):'-'}}</span>
                                    |
                                    <span>评论 {{$question['commentCount'] or 0}}</span>
                                    |
                                    <span>点击 {{$question['clickCount']}}</span>
                                </div>
                                @foreach($question['tag'] as $tag)
                                    <a href="/question/list/{{$tag['id']}}" target="_blank">{{$tag['title']}}</a>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="ub-page">
                    {!! $pageHtml !!}
                </div>
            </div>
        </div>

    </div>

@endsection