@extends($_viewFrame)

@section('pageTitle',\ModStart\Core\Util\HtmlUtil::text($questionData['question']['question']))
@section('pageTitle',\ModStart\Core\Util\HtmlUtil::text($questionData['question']['question']))
@section('pageKeywords',\ModStart\Core\Util\HtmlUtil::text($questionData['question']['question']))
@section('pageDescription',\ModStart\Core\Util\HtmlUtil::text($questionData['question']['question']))

{!! \ModStart\ModStart::js('asset/common/editor.js') !!}
{!! \ModStart\ModStart::css('vendor/Question/style/question.css') !!}
{!! \ModStart\ModStart::js('vendor/Question/entry/questionView.js') !!}
@section('bodyAppend')
    @parent
    <script>
        window.__selectorDialogServer = "{{modstart_web_url('member_data/file_manager')}}";
        window.__data = {
            alias: "{{$questionData['question']['alias']}}",
            memberUserId: {{intval($_memberUserId)}},
            ueditorServer: "{{modstart_web_url('member_data/ueditor')}}"
        }
    </script>
    <script src="@asset('asset/vendor/vue.js')"></script>
    <script src="@asset('asset/vendor/element-ui/index.js')"></script>
    <script src="@asset('vendor/Question/entry/questionComment.js')"></script>
@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/question">题目</a>
            <a class="active" href="javascript:;">{{\ModStart\Core\Util\HtmlUtil::text($questionData['question']['question'],50)}}</a>
        </div>

        <div class="row">
            <div class="col-md-9">
                @if($questionData['question']['type']==\Module\Question\Type\QuestionType::SINGLE_CHOICE)
                    @include('module::Question.View.public.questionWebView.viewSingleChoice')
                @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::MULTI_CHOICES)
                    @include('module::Question.View.public.questionWebView.viewMultiChoices')
                @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TRUE_FALSE)
                    @include('module::Question.View.public.questionWebView.viewTrueFalse')
                @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::FILL)
                    @include('module::Question.View.public.questionWebView.viewFill')
                @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::TEXT)
                    @include('module::Question.View.public.questionWebView.viewText')
                @elseif($questionData['question']['type']==\Module\Question\Type\QuestionType::GROUP)
                    @include('module::Question.View.public.questionWebView.viewGroup')
                @endif
                <div id="appQuestionComment"></div>
            </div>
            <div class="col-md-3">

                <div class="ub-panel pb-question-info">
                    <div class="head">
                        <div class="title">题目信息</div>
                    </div>
                    <div class="body">
                        @if(!empty($questionData['question']['tag']))
                            <div class="tags">
                                @foreach($questionData['question']['tag'] as $tag)
                                    <a href="/question/list/{{$tag['id']}}" target="_blank">{{$tag['title']}}</a>
                                @endforeach
                            </div>
                        @endif
                        <div class="attr">
                            <a href="javascript:;">正确率 {{$questionData['question']['testCount']>0?sprintf('%d%%',$questionData['question']['passCount']*100/$questionData['question']['testCount']):'-'}}</a>
                            &nbsp;
                            |
                            &nbsp;
                            <a href="javascript:;">评论 {{$questionData['question']['commentCount'] or 0}}</a>
                            &nbsp;
                            |
                            &nbsp;
                            <a href="javascript:;">点击 {{$questionData['question']['clickCount']}}</a>
                        </div>
                    </div>
                </div>

                <div class="ub-panel pb-question-action" style="margin-top:1rem;">
                    <div class="body">
                        <div class="row">
                            <div class="col-md-12" data-favorite-action>
                                <a class="action" href="javascript:;" data-action="favorite" data-category-id="{{$questionData['question']['id']}}" @if($hasFavorite) style="display:none;" @endif>
                                    <i class="iconfont icon-heart-alt"></i>
                                    <div class="text">收藏</div>
                                </a>
                                <a class="action active" href="javascript:;" data-action="unfavorite" data-category-id="{{$questionData['question']['id']}}" @if(!$hasFavorite) style="display:none;" @endif>
                                    <i class="iconfont icon-heart"></i>
                                    <div class="text">已收藏</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                @if($previousQuestion || $nextQuestion)
                    <div class="ub-list" style="margin-top:1rem;">
                        <div class="body">
                            @if($previousQuestion)
                                <a class="item-c" href="/question/view/{{$previousQuestion['alias']}}{{$param?'?param='.urlencode($param):''}}">
                                    上一题：
                                    [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$previousQuestion['type'])}}]
                                    {{\ModStart\Core\Util\HtmlUtil::text($previousQuestion['question'],100)}}
                                </a>
                            @endif
                            @if($nextQuestion)
                                <a class="item-c" href="/question/view/{{$nextQuestion['alias']}}{{$param?'?param='.urlencode($param):''}}">
                                    下一题：
                                    [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$nextQuestion['type'])}}]
                                    {{\ModStart\Core\Util\HtmlUtil::text($nextQuestion['question'],100)}}
                                </a>
                            @endif
                        </div>
                    </div>
                @endif

                @if(!empty($ads))
                    <div class="ub-panel" style="margin-top:1rem;">
                        <div class="body">
                            @foreach($ads as $ad)
                                @if($ad['link'])
                                    <a class="item" href="{{$ad['link']}}" target="_blank">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </a>
                                @else
                                    <div class="item">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>

@endsection