<?php
 namespace Module\Question\Web\Controller; use Illuminate\Support\Facades\View; use ModStart\App\Web\Layout\WebConfigBuilder; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\PageHtmlUtil; use ModStart\Form\Form; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Question\Util\QuestionUtil; class QuestionController extends ModuleBaseController { private $api; public function __construct() { $this->api = app(\Module\Question\Api\Controller\QuestionController::class); } public function index() { return Response::redirect(modstart_web_url('question/list')); } public function lists($tags = '') { $urlParam = $tags; $parsedUrlParam = $this->api->parseUrlParm($urlParam); $type = $parsedUrlParam['type']; $keyword = $parsedUrlParam['keyword']; $tagIds = $parsedUrlParam['tagIds']; InputPackage::mergeToInput('search', json_encode($parsedUrlParam)); $selectedTags = QuestionUtil::listTagsByIds($tagIds); $paginateData = Response::tryGetData($this->api->lists()); $pageTitle = []; if ($keyword) { $pageTitle[] = '搜索"' . htmlspecialchars($keyword) . '"'; } if (!empty($selectedTags)) { foreach ($selectedTags as $tag) { $pageTitle[] = $tag['title'] . '题库'; } } $pageTitle[] = modstart_config('siteName'); $pageKeywords = join(' ', $pageTitle); $pageTitle[] = '第' . $paginateData['page'] . '页'; $pageTitle = join(' ', $pageTitle); $pageDescription = $pageTitle; $pageHtml = PageHtmlUtil::render($paginateData['total'], $paginateData['pageSize'], $paginateData['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); return $this->view('question.list', [ 'tags' => QuestionUtil::getTags(), 'selectedTagIds' => $tagIds, 'selectedTags' => $selectedTags, 'keyword' => $keyword, 'type' => $type, 'urlParam' => $urlParam, 'questions' => $paginateData['records'], 'pageTitle' => $pageTitle, 'pageKeywords' => $pageKeywords, 'pageDescription' => $pageDescription, 'pageHtml' => $pageHtml, ]); } public function views($alias) { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } InputPackage::mergeToInput('alias', $alias); $data = Response::tryGetData($this->api->get()); return $this->view('question.view', $data); } public function answer($alias) { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } InputPackage::mergeToInput('alias', $alias); if (!MemberUser::id()) { return Response::json(-1, '登录后才能查看答案', null, '/login?redirect=' . urlencode(Request::headerGet('Referer'))); } $data = Response::tryGetData($this->api->answer()); return Response::json(0, 'ok', [ 'html' => View::make('module::Question.View.public.questionPart.answer', $data)->render(), ]); } public function tags() { if (!QuestionUtil::isEnable()) { return QuestionUtil::disabledResponse(); } return $this->view('question.tags', [ 'tags' => QuestionUtil::getTags() ]); } public function search() { $result = Response::tryGetData($this->api->search()); $result['pageHtml'] = PageHtmlUtil::render($result['total'], $result['pageSize'], $result['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); return $this->view('question.search', $result); } }