<?php
 namespace Module\VipArticle\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Type\TypeUtil; use ModStart\Field\AbstractField; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Member\Util\MemberCmsUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\Type\OrderStatus; use Module\VipArticle\Type\VipArticleOrderStatus; use Module\VipArticle\Util\VipArticleUtil; class VipArticleOrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('vip_article_order') ->field(function ($builder) { $builder->id('id', 'ID'); $builder->datetime('created_at', '创建时间'); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return MemberCmsUtil::showFromId($item->memberUserId); }); $builder->display('articleId', '文章')->hookRendering(function (AbstractField $field, $item, $index) { return VipArticleUtil::showFromId($item->articleId); }); $builder->display('payFee', '支付金额'); $builder->type('status', '状态')->type(VipArticleOrderStatus::class); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->eq('vipId', 'VIP')->select(MemberVipUtil::mapTitle()); $filter->eq('status', '状态')->select([ OrderStatus::WAIT_PAY => TypeUtil::name(OrderStatus::class, OrderStatus::WAIT_PAY), OrderStatus::COMPLETED => TypeUtil::name(OrderStatus::class, OrderStatus::COMPLETED), ]); }) ->disableCUD()->canShow(false) ->title('付费内容订单'); } }