<?php
 namespace Module\VipArticle\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\HtmlUtil; use Module\Member\Auth\MemberUser; use Module\PayCenter\Traits\PayCenterPerformTrait; use Module\VipArticle\Constant\PayConstant; use Module\VipArticle\Type\VipArticleOrderStatus; use Module\VipArticle\Util\VipArticleUtil; class VipArticleController extends Controller { use PayCenterPerformTrait; public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = $input->getPageSize(); $categoryId = $input->getInteger('categoryId'); $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('vip_article', $page, $pageSize, $option); $categories = ModelUtil::model('vip_article_category')->orderBy('sort', 'asc')->get()->toArray(); $vipArticles = $paginateData['records']; foreach ($vipArticles as &$new) { $info = HtmlUtil::extractTextAndImages($new['content']); $new['summary'] = $info['text']; } $data = []; $data['vipArticles'] = $vipArticles; $data['categoryId'] = $categoryId; $data['categories'] = $categories; $data['page'] = $page; $data['pageSize'] = $pageSize; $data['total'] = $paginateData['total']; return Response::generateSuccessData($data); } public function get() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $vipArticle = ModelUtil::get('vip_article', ['id' => $id]); if (empty($vipArticle)) { return Response::generate(-1, 'vip article not found'); } $vipArticle['_category'] = ModelUtil::get('vip_article_category', ['id' => $vipArticle['categoryId']]); $vipArticleLatest = ModelUtil::model('vip_article')->orderBy('id', 'desc')->limit(6)->get()->toArray(); $dataView = []; $dataView['vipArticle'] = $vipArticle; $dataView['vipArticleLatest'] = $vipArticleLatest; $dataView['vipArticleBought'] = VipArticleUtil::hasBought(MemberUser::id(), $vipArticle['id']); return Response::generateSuccessData($dataView); } public function buy() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $vipArticle = ModelUtil::get('vip_article', ['id' => $id]); if (empty($vipArticle)) { return Response::generate(-1, 'vip article not found'); } if (!MemberUser::id()) { return Response::generate(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $money = $vipArticle['fee']; if ($money < 0.01) { return Response::generate(-1, '支付金额为空'); } $vipArticleOrder = ModelUtil::insert('vip_article_order', [ 'status' => VipArticleOrderStatus::WAIT_PAY, 'memberUserId' => MemberUser::id(), 'articleId' => $vipArticle['id'], 'payFee' => $money, ]); return $this->performSubmitOrder( PayConstant::VIP_ARTICLE, $vipArticleOrder['id'], $vipArticleOrder['payFee'], '购买付费内容「' . $vipArticle['title'] . '」' ); } public function search() { $input = InputPackage::buildFromInput(); $page = $input->getPage(); $pageSize = $input->getPageSize(); $keywords = $input->getTrimString('keywords'); $maxPage = modstart_config()->getInteger('moduleVipArticleSearchMaxPage', 20); $page = min($page, $maxPage); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['title', 'like', '%' . $keywords . '%']; $paginateData = ModelUtil::paginate('vip_article', $page, $pageSize, $option); $records = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); $viewData = []; $viewData['pageTitle'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['page'] = $page; $viewData['pageSize'] = $pageSize; $viewData['total'] = $paginateData['total']; return Response::generateSuccessData($viewData); } }