@extends($_viewFrame)

@section('pageTitleMain','付费内容')

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a class="active" href="javascript:;">付费内容</a>
        </div>

        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            @if($categoryId)
                                @foreach($categories as $category)
                                    @if($category['id']==$categoryId)
                                        {{$category['name']}}
                                    @endif
                                @endforeach
                            @else
                                全部
                            @endif
                        </div>
                    </div>
                    <div class="body">
                        <div class="ub-list-items" style="padding:0.5rem;">
                            @foreach($vipArticles as $vipArticle)
                                <div class="item-d">
                                    <a class="title" href="/vip_article/{{$vipArticle['id']}}">{{$vipArticle['title']}}</a>
                                    <div class="attr">
                                        <i class="iconfont icon-time"></i>
                                        <span>{{($vipArticle['updated_at'])}}</span>
                                    </div>
                                    <div class="summary">
                                        {{\ModStart\Core\Util\HtmlUtil::text($vipArticle['previewContent'],200)}}
                                    </div>
                                    <div class="action ub-text-right">
                                        <a class="more" href="/vip_article/{{$vipArticle['id']}}">
                                            [阅读全文]
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                            @if(empty($vipArticles))
                                <div class="ub-empty">暂无记录</div>
                            @endif
                        </div>
                        <div class="ub-page">
                            {!! $pageHtml !!}
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">

                <div class="ub-panel margin-top">
                    <div class="body">
                        <div class="ub-search-block-a mini">
                            <input class="input" type="text" placeholder="搜索 付费内容" id="keyword" onkeypress="if(event.keyCode===13){window.location.href='/search/vip_article?keywords='+window.api.util.urlencode($(this).val());}" />
                            <a class="search-btn" href="javascript:;" onclick="window.location.href='/vip_article/search?keywords='+window.api.util.urlencode($(this).prev().val());"><span class="uk-icon-search"></span> 搜索</a>
                        </div>
                    </div>
                </div>

                <div class="ub-menu simple">
                    <a class="title @if(!$categoryId) active @endif" href="/vip_article">全部</a>
                    @foreach($categories as $category)
                        <a class="title @if($category['id']==$categoryId) active @endif" href="/vip_article?categoryId={{$category['id']}}">{{$category['name']}}</a>
                    @endforeach
                </div>

            </div>
        </div>

    </div>

@endsection





