@extends($_viewFrame)

@section('pageTitle',$pageTitle)
@section('pageKeywords',$pageKeywords)
@section('pageDescription',$pageDescription)

{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}

@section('bodyAppend')
    @parent
    <script>
        $(function () {
            $(".ub-list-items .title").mark({!! json_encode($keywords) !!}.split('').join(' '),{separateWordSearch:true});
        });
    </script>
@endsection

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/vip_article">付费内容</a>
            <a class="active" href="javascript:;">搜索付费内容 “{{$keywords}}”</a>
        </div>

        <div class="ub-panel" style="margin-top:1rem;">
            <div class="body">
                <div class="ub-search-block-a">
                    <input class="input" type="text" placeholder="搜索 付费内容" id="keyword" value="{{$keywords or ''}}" onkeypress="if(event.keyCode===13){window.location.href='/vip_article/search?keywords='+window.api.util.urlencode($(this).val());}" />
                    <a class="search-btn" href="javascript:;" onclick="window.location.href='/vip_article/search?keywords='+window.api.util.urlencode($(this).prev().val());"><span class="uk-icon-search"></span> 搜索</a>
                </div>
            </div>
        </div>

        <div class="ub-panel">
            <div class="head">
                <div class="title">搜索结果</div>
            </div>
            <div class="body">
                <div class="ub-list-items" style="padding:0.5rem;">
                    @foreach($records as $vipArticle)
                        <div class="item-d">
                            <a class="title" href="/vip_article/{{$vipArticle['id']}}">{{$vipArticle['title']}}</a>
                            <div class="attr">
                                <i class="iconfont icon-time"></i>
                                <span>{{($vipArticle['updated_at'])}}</span>
                            </div>
                            <div class="summary">
                                {{\ModStart\Core\Util\HtmlUtil::text($vipArticle['previewContent'],200)}}
                            </div>
                            <div class="action ub-text-right">
                                <a class="more" href="/vip_article/{{$vipArticle['id']}}">
                                    [阅读全文]
                                </a>
                            </div>
                        </div>
                    @endforeach
                    @if(empty($records))
                        <div class="ub-empty">暂无记录</div>
                    @endif
                    <div class="ub-page">
                        {!! $pageHtml !!}
                    </div>
                </div>
            </div>
        </div>

    </div>


@endsection