@extends($_viewFrame)

@section('pageTitleMain',htmlspecialchars($vipArticle['title']))

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="/">首页</a>
            <a href="/vip_article">付费内容</a>
            <a class="active" href="javascript:;">{{$vipArticle['title']}}</a>
        </div>


        <div class="row">
            <div class="col-md-9">

                <div class="ub-panel margin-top" style="padding:1rem;">
                    <div class="body">
                        <div class="ub-article">
                            <h1>{{$vipArticle['title']}}</h1>
                            <div class="attr">
                                时间：{{($vipArticle['created_at'])}}
                                分类：{{$vipArticle['_category']['name']}}
                            </div>
                            <div class="margin-top">
                                @if($vipArticleBought || (!$vipArticle['fee']>=0.01))
                                    @if($vipArticle['fee']>=0.01)
                                        <div class="ub-alert ub-alert-success ub-text-center">您已经购买此付费内容</div>
                                    @endif
                                    <div class="content ub-html">
                                        {!! \ModStart\Core\Util\HtmlUtil::replaceImageSrcToLazyLoad($vipArticle['content'],'data-src',true) !!}
                                    </div>
                                @else
                                    <div class="content ub-html">
                                        {!! \ModStart\Core\Util\HtmlUtil::replaceImageSrcToLazyLoad($vipArticle['previewContent'],'data-src',true) !!}
                                    </div>
                                    <div class="ub-alert ub-alert-warning ub-text-center">
                                        @if($_memberUserId)
                                            <a href="javascript:;" data-ajax-request-loading data-ajax-request="/api/vip_article/buy?id={{$vipArticle['id']}}&redirect={{urlencode(\ModStart\Core\Input\Request::currentPageUrl())}}" >支付 ￥{{$vipArticle['fee']}} 查看全文</a>
                                        @else
                                            <a href="/login?redirect={{urlencode('/vip_article/'.$vipArticle['id'])}}">支付 ￥{{$vipArticle['fee']}} 查看全文</a>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">

                <div class="ub-list margin-top">
                    <div class="head">
                        <div class="title">
                            最新内容
                        </div>
                    </div>
                    <div class="body">
                        @foreach($vipArticleLatest as $record)
                            <a class="item-c" href="/vip_article/{{$record['id']}}">{{$record['title']}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection





