@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))

@section('bodyContent')

    <div class="ub-search-block">
        <div class="title">
            海量题库供您搜索
        </div>
        <div class="form">
            <form action="/question/search" method="get">
                <div class="box">
                    <input type="text" name="keywords" class="form form-lg" placeholder="搜索 题目">
                    <button type="submit" class="btn btn-lg"><i class="iconfont icon-search1"></i> 搜索</button>
                </div>
            </form>
        </div>
    </div>

    <div class="ub-container margin-top">
        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">标签</div>
                    </div>
                    <div class="body">
                        <div class="ub-nav-category">
                            @foreach(\Module\Question\Util\QuestionUtil::getTags() as $tagGroup)
                                <a class="group-title" href="javascript:;">{{$tagGroup['groupTitle']}}</a>
                                <div class="group-list">
                                    @foreach($tagGroup['groupTags'] as $tag)
                                        <a class="item" href="/question/list/{{\ModStart\Core\Util\TagUtil::urlJoin('',[$tag['id']])}}">{{$tag['title']}}</a>
                                    @endforeach
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @include('module::Partner.View.pc.public.partner',['position'=>'pcHome'])
            </div>
            <div class="col-md-3">
                @include('module::Banner.View.pc.public.banner',['position'=>'pcHome'])

                <div class="ub-panel ub-list margin-top">
                    <div class="head">
                        <div class="title">最新题目</div>
                    </div>
                    <div class="body">
                        @foreach(\Module\Question\Util\QuestionUtil::listLatestQuestion() as $question)
                            <a class="item-c" href="/question/view/{{$question['alias']}}">
                                [{{\ModStart\Core\Type\TypeUtil::name(\Module\Question\Type\QuestionType::class,$question['type'])}}]
                                {{\ModStart\Core\Util\HtmlUtil::text($question['question'],100)}}
                            </a>
                        @endforeach
                    </div>
                </div>

                <div class="ub-panel ub-list margin-top">
                    <div class="head">
                        <div class="title">最近资讯</div>
                    </div>
                    <div class="body">
                        @foreach(\Module\News\Util\NewsUtil::listLatest() as $new)
                            <a class="item-c" href="/news/{{$new['id']}}">
                                {{$new['title']}}
                            </a>
                        @endforeach
                    </div>
                </div>

            </div>
        </div>
    </div>

    @if(0)
    <div class="main-container">


        <div class="pb pb-partner">
            <div class="head">
                <h2>合作伙伴</h2>
            </div>
            <div class="body">
                <div class="row">
                    @foreach($partners as $partner)
                        <div class="uk-width-1-6">
                            <a class="item" href="{{$partner['link']}}" target="_blank" title="{{$partner['title']}}">
                                <div class="cover" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($partner['logo'])}})"></div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

    </div>
    @endif

@endsection
