<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Migrate20171224 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $events = \TechOnline\Laravel\Dao\ModelUtil::all('event');
        \TechOnline\Laravel\Dao\ModelUtil::decodeRecordsJson($events, 'applyInfo');
        foreach ($events as $event) {
            if (empty($event['applyInfo'])) {
                continue;
            }
            foreach ($event['applyInfo'] as $index => $item) {
                if ($index >= 5) {
                    break;
                }
                switch ($item['type']) {
                    case 'text':
                        \TechOnline\Laravel\Dao\ModelUtil::update('event', ['id' => $event['id']], [
                            'fieldCustom' . ($index + 1) => json_encode([
                                'type' => 'Text',
                                'title' => $item['name'],
                                'data' => [],
                            ])
                        ]);
                        break;
                    case 'select':
                        $option = [];
                        foreach (explode("\n", $item['option']) as $line) {
                            $line = trim($line);
                            if (empty($line)) {
                                continue;
                            }
                            $option [] = $line;
                        }
                        \TechOnline\Laravel\Dao\ModelUtil::update('event', ['id' => $event['id']], [
                            'fieldCustom' . ($index + 1) => json_encode([
                                'type' => 'Radio',
                                'title' => $item['name'],
                                'data' => [
                                    'option' => $option
                                ],
                            ])
                        ]);
                        break;
                }
            }
            \TechOnline\Laravel\Dao\ModelUtil::update('event', ['id' => $event['id']], [
                'applyInfo' => null,
            ]);
        }

        $eventOrders = \TechOnline\Laravel\Dao\ModelUtil::all('event_order');
        \TechOnline\Laravel\Dao\ModelUtil::decodeRecordsJson($eventOrders, 'applyInfo');
        foreach ($eventOrders as $eventOrder) {
            if (empty($eventOrder['eventId'])) {
                continue;
            }
            /*
            const WAIT_PAY = 1;
            const WAIT_SIGN_IN = 2;
            const EXPIRED = 3;
            const COMPLETED = 4;
            const ABSENT = 5;
            */
            $orderStatus = $eventOrder['status'];
            $status = \App\Types\EventOrderItemStatus::WAIT_SIGN_IN;
            if ($eventOrder['status'] == 2) {
                \TechOnline\Laravel\Dao\ModelUtil::update('event_order', ['id' => $eventOrder['id']], [
                    'status' => \App\Types\EventOrderStatus::COMPLETED,
                ]);
                $orderStatus = \App\Types\EventOrderStatus::COMPLETED;
                $status = \App\Types\EventOrderItemStatus::WAIT_SIGN_IN;
            }
            if ($eventOrder['status'] == 5) {
                \TechOnline\Laravel\Dao\ModelUtil::update('event_order', ['id' => $eventOrder['id']], [
                    'status' => \App\Types\EventOrderStatus::COMPLETED,
                ]);
                $orderStatus = \App\Types\EventOrderStatus::COMPLETED;
                $status = \App\Types\EventOrderItemStatus::ABSENT;
            }

            $update = [
                'memberUserId' => $eventOrder['memberUserId'],
                'orderId' => $eventOrder['id'],
                'eventId' => $eventOrder['eventId'],
                'checkCode' => \TechOnline\Utils\RandomUtil::number(10),
                'orderStatus' => $orderStatus,
                'status' => $status,
            ];

            if (!empty($eventOrder['applyInfo'])) {
                foreach ($eventOrder['applyInfo'] as $index => $item) {
                    if ($index >= 5) {
                        break;
                    }
                    $update['fieldCustom' . ($index + 1)] = $item['value'];
                }
            }

            \TechOnline\Laravel\Dao\ModelUtil::insert('event_order_item', $update);

            \TechOnline\Laravel\Dao\ModelUtil::update('event_order', ['id' => $eventOrder['id']], [
                'eventId' => null,
                'applyInfo' => null,
            ]);
        }

        Schema::table('event', function (Blueprint $table) {
            $table->dropColumn('applyInfo');
        });

        Schema::table('event_order', function (Blueprint $table) {
            $table->dropColumn('applyInfo');
            $table->dropColumn('eventId');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
