@extends('theme.default.m.frame')

@section('pageTitleMain',$event['title'])
@section('pageKeywords',$event['title'])
@section('pageDescription',$event['summary'])

@section('footer')
    <div style="height:60px;"></div>
@endsection

@section('bodyScript')
    <script src="@assets('assets/m/event.js')"></script>
@endsection

@section('bodyContent')

    <div class="pb-event-basic">
        <div class="images">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    <a href="javascript:;" class="swiper-slide" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($event['cover'])}});"></a>
                    @foreach($event['photos'] as $photo)
                        <a  href="javascript:;" class="swiper-slide" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($photo)}});"></a>
                    @endforeach
                </div>
                <div class="swiper-pagination swiper-pagination-white"></div>
                <div class="swiper-button-next swiper-button-white"></div>
                <div class="swiper-button-prev swiper-button-white"></div>
            </div>
        </div>
        <h1>{{$event['title']}}</h1>
        <div class="info">
            <div class="attr">
                <div class="name">
                    时间：
                </div>
                <div class="value">
                    {{\Carbon\Carbon::parse($event['time'])->format('Y-m-d H:i')}}
                </div>
            </div>
            @if($event['applyTimeLimit'])
                <div class="attr">
                    <div class="name">
                        报名开始：
                    </div>
                    <div class="value">
                        {{\Carbon\Carbon::parse($event['applyStartTime'])->format('Y-m-d H:i')}}
                    </div>
                </div>
                <div class="attr">
                    <div class="name">
                        报名截止：
                    </div>
                    <div class="value">
                        {{\Carbon\Carbon::parse($event['applyEndTime'])->format('Y-m-d H:i')}}
                    </div>
                </div>
            @endif
            @if($event['applyNumberLimit'])
                <div class="attr">
                    <div class="name">
                        报名限制：
                    </div>
                    <div class="value">
                        {{$event['applyNumberMax']}}人
                    </div>
                </div>
            @endif
            @foreach($event['param'] as $item)
                <div class="attr">
                    <div class="name">
                        {{$item['name']}}：
                    </div>
                    <div class="value">
                        {{$item['value']}}
                    </div>
                </div>
            @endforeach
            <div class="attr">
                <div class="name">
                    费用：
                </div>
                <div class="value">
                    @if($event['price']>0)
                        <div class="price">￥{{$event['price']}}元</div>
                    @else
                        <div class="price">免费</div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="pb pb-event-detail">
        <div class="head">详细描述</div>
        <div class="body">
            <div class="content html-container">
                {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($event['content'],'data-src',true) !!}
            </div>
        </div>
    </div>

    <div class="pb-event-action">
        @if($event['applyTimeLimit'] && time()<strtotime($event['applyStartTime']))
            <div class="disabled">报名未开始</div>
        @elseif($event['applyTimeLimit'] && time()>strtotime($event['applyEndTime']))
            <div class="disabled">报名已截止</div>
        @elseif($event['status']==\App\Types\EventStatus::NOT_START)
            <div class="disabled">报名未开始</div>
        @elseif($event['status']==\App\Types\EventStatus::APPLYING)
            @if($_memberUserId)
                <a class="submit" href="javascript:;" data-button-submit-dialog>立即报名</a>
            @else
                <a class="submit" href="/login?redirect={{urlencode('/event/'.$event['id'])}}">立即报名</a>
            @endif
        @elseif($event['status']==\App\Types\EventStatus::APPLY_EXPIRED)
            <div class="disabled">已过期</div>
        @elseif($event['status']==\App\Types\EventStatus::FINISHED)
            <div class="disabled">已结束</div>
        @endif
    </div>

    @if($event['applyText'])
        <div class="pb pb-event-apply-text">
            <div class="head">报名须知</div>
            <div class="body" style="overflow:auto;">
                <div class="html-container">
                    {!! $event['applyText'] !!}
                </div>
            </div>
        </div>
    @endif

    <div class="pb-event-submit-dialog">
        <div class="mask">
            <div class="content">
                <div class="title">
                    <a class="close" href="javascript:;" data-button-submit-dialog-close><i class="iconfont">&#xe60f;</i></a>
                    <h2>报名确认</h2>
                </div>
                <form action="/event/{{$event['id']}}/submit" class="uk-form" method="post" data-ajax-form>
                    @if(!empty($event['_fieldCustom']))
                        <div class="apply-field">
                            <?php
                            echo (new \TechSoft\Laravel\EXField\EXField())->render([
                                'fieldCustom1'=>@json_decode($event['fieldCustom1'],true),
                                'fieldCustom2'=>@json_decode($event['fieldCustom2'],true),
                                'fieldCustom3'=>@json_decode($event['fieldCustom3'],true),
                                'fieldCustom4'=>@json_decode($event['fieldCustom4'],true),
                                'fieldCustom5'=>@json_decode($event['fieldCustom5'],true)
                                ]);
                            ?>
                        </div>
                    @endif
                    <div class="action">
                        <button type="submit">确认报名</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection