<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteFavIco'),'default_favicon.ico')}}" />
    <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
    <meta name="keywords" content="@yield('pageKeywords',\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription'))">
    <title>@section('pageTitle')@yield('pageTitleMain') · {{\TechSoft\Laravel\Config\ConfigUtil::get('siteName')}}@show</title>
    <link href="@assets('assets/mui/css/mui.css')" rel="stylesheet"/>
    <link href="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('theme/'.\TechSoft\Laravel\Config\ConfigUtil::get('siteTemplate','default').'/m/css/style.css')}}" rel="stylesheet"/>
    <script src="@assets('assets/init.js')"></script>
    @if(\TechOnline\Laravel\Util\AgentUtil::isWechat())
        <script src="//res.wx.qq.com/open/js/jweixin-1.0.0.js"></script>
    @endif
    @section('headAppend')@show
    {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
</head>
<body>
@section('body')

@section('header')
    @if(\TechSoft\Laravel\Agent\UserAgentUtil::source()!=\TechSoft\Laravel\Agent\UserAgentUtil::SOURCE_APP && !\TechOnline\Laravel\Util\AgentUtil::isWechat())
        <header class="mui-bar mui-bar-nav">
            @section('headerLeft')
                <a class="mui-action-back mui-pull-left"><i class="mui-icon mui-icon-left-nav"></i></a>
            @show
            <h1 class="mui-title">
                @yield('pageTitleMain','<img src="'.\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'),'/placeholder/160x50').'" class="logo" />')
            </h1>
            @section('headerRight')
                {{--<a class="mui-icon mui-icon-search mui-pull-right" href="javascript:;" onclick="$('.pb-search-bar').show();$('body,html').animate({scrollTop:0});"></a>--}}
            @show
        </header>
    @endif
@show

<div class="mui-content">

    @section('bodyContent')
    @show

    @section('footer')

        <div style="height:60px;"></div>

        <nav class="mui-bar mui-bar-tab">
            <a class="mui-tab-item @if($base_request_path=='/') mui-active @endif" href="/">
                <span class="mui-icon iconfont">&#xe9bb;</span>
                <span class="mui-tab-label">首页</span>
            </a>
            <a class="mui-tab-item @if(\Illuminate\Support\Str::startsWith($base_request_path,'/category') || \Illuminate\Support\Str::startsWith($base_request_path,'/event')) mui-active @endif" href="/category">
                <span class="mui-icon iconfont">&#xe650;</span>
                <span class="mui-tab-label">课程</span>
            </a>
            <a class="mui-tab-item @if(\Illuminate\Support\Str::startsWith($base_request_path,'/member')) mui-active @endif" href="/member">
                <span class="mui-icon iconfont">&#xe68c;</span>
                <span class="mui-tab-label">我的</span>
            </a>
        </nav>

    @show

</div>
@section('bodyScript')
    <script src="@assets('assets/m/basic.js')"></script>
@show
@section('bodyWechatScript')
    @if(\TechOnline\Laravel\Util\AgentUtil::isWechat() && \TechSoft\Laravel\Config\ConfigUtil::get('shareWechatMobileEnable',false))
        <script>
            wx.config(<?php echo \TechSoft\Laravel\Wechat\WechatAppUtil::shareApp()->js->config(['onMenuShareTimeline', 'onMenuShareAppMessage'],false); ?>);
            wx.ready(function () {
                if(typeof __WxShare=='undefined'){
                    window.__WxShare = {};
                    window.__WxShare.title = window.document.title;
                    window.__WxShare.desc = $('meta[name=description]').attr('content');
                    window.__WxShare.link = window.location.href;
                    window.__WxShare.imgUrl = <?php echo json_encode(\TechSoft\Laravel\Assets\AssetsUtil::fixFull(\TechSoft\Laravel\Config\ConfigUtil::get('shareWechatMobileImage'))); ?>;
                }
                wx.onMenuShareAppMessage({
                    title: __WxShare.title,
                    desc:__WxShare.desc,
                    link: __WxShare.link,
                    imgUrl: __WxShare.imgUrl,
                    type: 'link',
                    dataUrl: '',
                    success: function () {},
                    cancel: function () {}
                });
                wx.onMenuShareTimeline({
                    title: __WxShare.title,
                    desc:__WxShare.desc,
                    link: __WxShare.link,
                    imgUrl: __WxShare.imgUrl,
                    success: function () {},
                    cancel: function () {}
                });
            });
        </script>
    @endif
@show
@section('bodyAppend')@show
@show
{!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounterBody') !!}
</body>
</html>