@extends('theme.default.m.frame')

@section('bodyScript')
    <script src="@assets('assets/m/home.js')"></script>
@endsection

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('pageTitleMain',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('pageKeywords',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords')))
@section('pageDescription',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription')))
@section('headerLeft')@endsection

@section('bodyContent')

    <div class="pb-home-search">
        <form action="/search" method="get">
            <div class="mui-input-row mui-search">
                <input type="search" name="keyword" class="mui-input-clear" placeholder="输入关键词搜索">
            </div>
        </form>
    </div>

    <div class="pb-home-banner swiper-container">
        <div class="swiper-wrapper">
            @if(empty($banners))
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
            @else
                @foreach($banners as $banner)
                    <a class="swiper-slide"
                       style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($banner['image'])}});"
                       @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                @endforeach
            @endif
        </div>
        <div class="swiper-pagination"></div>
    </div>

    @foreach($eventCategories as $eventCategory)
        <div class="pb pb-event-list">
            <div class="head">{{$eventCategory['title']}}</div>
            <div class="body">
                @foreach($eventCategory['_events'] as $event)
                    <a href="/event/{{$event['id']}}" class="item">
                        <div class="cover" data-src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($event['cover'])}}"></div>
                        <div class="title">
                            @if($event['status']==\App\Types\EventStatus::APPLYING)
                                [正在报名]
                            @else
                                [{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\EventStatus::class,$event['status'])}}]
                            @endif
                            {{$event['title']}}
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    @endforeach

@endsection






































