@extends($_frameLayoutView)

@section('pageTitleMain','支付订单')
@section('footer')@endsection

@section('bodyScript')
    @if(\TechSoft\Laravel\Pay\PayUtil::isWechatMobileEnable())
        <script src="http://res.wx.qq.com/open/js/jweixin-1.1.0.js"></script>
        <script>
            wx.config(<?php echo \TechSoft\Laravel\Pay\Services\PayOrderUtil::getWechatMobileApp()->js->config(array('chooseWXPay'), false) ?>);
        </script>
    @endif
    <script>
        var __app = {
            autoClickPayType:<?php echo json_encode(\Illuminate\Support\Facades\Session::pull('autoClickPayType',null)); ?>
        };
    </script>
    <script src="@assets('assets/m/memberOrderPay.js')"></script>
@endsection

@section('bodyContent')

    <div class="pb-member-order-pay">

        <ul class="mui-table-view">
            <li class="mui-table-view-cell">
                <div class="name">订单号</div>
                <div class="value">{{$order['sn']}}</div>
            </li>
            <li class="mui-table-view-cell">
                <div class="name">金额</div>
                <div class="value">￥{{$order['payFee']}} 元</div>
            </li>
        </ul>

        <div class="pay-list">

            @if(\TechSoft\Laravel\Pay\PayUtil::isAlipayEnable())
                <a href="javascript:;" data-type="{{\TechSoft\Laravel\Pay\Types\PayType::ALIPAY}}">
                    <span class="check iconfont">&#xe61f;</span>
                    <img src="@assets('theme/default/pc/img/alipay.jpg')"/>
                    支付宝
                </a>
            @endif

            @if(\TechSoft\Laravel\Pay\PayUtil::isWechatMobileEnable())
                <a href="javascript:;" data-type="{{\TechSoft\Laravel\Pay\Types\PayType::WECHAT_MOBILE}}">
                    <span class="check iconfont">&#xe61f;</span>
                    <img src="@assets('theme/default/pc/img/wechat.jpg')"/>
                    微信支付
                </a>
            @endif

            @if(\TechSoft\Laravel\Pay\PayUtil::isOfflinePayEnable())
                <a href="javascript:;" data-type="{{\TechSoft\Laravel\Pay\Types\PayType::OFFLINE_PAY}}">
                    <span class="check iconfont">&#xe61f;</span>
                    <img src="@assets('assets/lib/img/pay/offline_pay.png')"/>
                    货到付款
                </a>
            @endif

        </div>

    </div>

    <div class="pb-member-order-pay-submit">
        <a class="mui-btn mui-btn-block mui-btn-primary" href="javascript:;" data-pay-submit>确定支付</a>
    </div>

@endsection