<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'zh_cn', branch 'MOODLE_32_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = '添加屏幕截图';
$string['advertise'] = '为此课程打广告，引别人加入';
$string['advertised'] = '广告';
$string['advertiseon'] = '在{$a}为此课程打广告';
$string['advertiseonhub'] = '在中心服务器上为此课程做广告';
$string['advertiseonmoodleorg'] = '在moodle.org为此课程打广告';
$string['advertisepublication_help'] = '在社群中心服务器上广告您的课程，让更多的人能发现它，并来这里加入。';
$string['all'] = '全部';
$string['allowglobalsearch'] = '发布此中心服务器，并允许全局搜索所有课程';
$string['allowpublicsearch'] = '发布此中心服务器，让用户加入';
$string['audience'] = '受众';
$string['audienceadmins'] = 'Moodle管理员';
$string['audienceeducators'] = '教师';
$string['audience_help'] = '选择此课程受众目标的类型。';
$string['audiencestudents'] = '学生';
$string['badurlformat'] = '错误的网页地址格式';
$string['cannotsearchcommunity'] = '对不起，您没有浏览本页面所需的权限';
$string['community'] = '社群';
$string['communityremoved'] = '课程链接已从您的列表删除';
$string['confirmregistration'] = '确认注册';
$string['contactable'] = '公开联系方式';
$string['contactable_help'] = '设为是，中心服务器会显示您的email地址。';
$string['contactemail'] = '联系email';
$string['contactname'] = '联系人';
$string['contactphone'] = '电话';
$string['contactphone_help'] = '电话号码只有中心服务器管理员能看到，不会公开显示。';
$string['continue'] = '继续';
$string['contributornames'] = '其它贡献人';
$string['contributornames_help'] = '您可以在此列出所有对此课程有贡献的人的名字。';
$string['coursemap'] = '课程地图';
$string['coursename'] = '名称';
$string['courseprivate'] = '私人的';
$string['coursepublic'] = '公开的';
$string['coursepublished'] = '此课程已经成功发布在“{$a}”。';
$string['courseshortname'] = '简称';
$string['courseshortname_help'] = '输入您课程的简称。它可以与其它课程重名。';
$string['coursesnumber'] = '课程数（{$a}）';
$string['courseunpublished'] = '{$a->courseshortname}课程不再继续在{$a->hubname}发布。';
$string['courseurl'] = '课程网址';
$string['courseurl_help'] = '您课程的网址。此网址会在搜索结果中显示为链接。';
$string['creatorname'] = '创建人';
$string['creatorname_help'] = '创建人是此课程的创建者。';
$string['creatornotes'] = '创建人备注';
$string['creatornotes_help'] = '创建人备注是给教师的指导，告诉他们如何使用此课程。';
$string['deletescreenshots'] = '删除这些屏幕截图';
$string['deletescreenshots_help'] = '删除所有已上传的屏幕截图。';
$string['demourl'] = '演示网页地址';
$string['demourl_help'] = '输入您课程的演示URL。缺省会填入您课程的URL。演示URL会在搜索结果中显示为链接。';
$string['description'] = '描述';
$string['description_help'] = '描述会被显示在中心服务器的课程列表中。';
$string['detectednotexistingpublication'] = '{$a->hubname}列出了一个已不存在的课程。提醒服务器管理员应该删除发布编号{$a->id}。';
$string['downloadable'] = '可下载';
$string['educationallevel'] = '教育级别';
$string['educationallevel_help'] = '选择此课程最适合的教育级别。';
$string['edulevelassociation'] = '机构';
$string['edulevelcorporate'] = '全体';
$string['edulevelgovernment'] = '政府';
$string['edulevelother'] = '其它';
$string['edulevelprimary'] = '初等教育';
$string['edulevelsecondary'] = '中等教育';
$string['eduleveltertiary'] = '高等教育';
$string['emailalert'] = 'Email通知';
$string['emailalert_help'] = '如果启用该项，你将会收到来自中心服务器管理员的安全问题和重要消息的邮件。';
$string['enrollable'] = '可以选课';
$string['errorbadimageheightwidth'] = '该图片最大大小应为{$a->width} X {$a->height}';
$string['errorcourseinfo'] = '从中心服务器({$a})读取课程元数据时发生错误。请稍后再重新加载本页面，尝试获取课程元数据。您也可以使用以下缺省的元数据来完成注册过程。';
$string['errorcoursepublish'] = '发布课程的时候遇到一个问题 ({$a}). 请稍后再试。 ';
$string['errorcoursewronglypublished'] = '中心服务器返回了一个发布错误，请稍后再试。';
$string['errorcron'] = '注册更新时发生错误"{$a->hubname}"({$a->errormessage})';
$string['errorcronnoxmlrpc'] = '为更新注册，须使XML-RPC有效。';
$string['errorhublisting'] = '从Moodle.org获取中心服务器列表时出错，请稍后再试。（{$a}）';
$string['errorlangnotrecognized'] = 'Moodle无法识别提供的语言编码。请联系 {$a}';
$string['errorregistration'] = '注册时发生错误，请稍候再试。({$a})';
$string['errorunpublishcourses'] = '由于一个意外错误，无法从中心服务器删除课程。请稍候再试（建议如此）或者联系中心服务器管理员。';
$string['existingscreenshotnumber'] = '{$a}有截图。当中心服务器管理员激活了您的课程时，您将可以在该网页上看到这些截图。';
$string['existingscreenshots'] = '已有截图';
$string['forceunregister'] = '确定，清除注册数据';
$string['forceunregisterconfirmation'] = '您的网站不能访问{$a}。该中心服务器可能临时关闭。除非您确定您想要在本地删除注册，否则请稍候再试。';
$string['geolocation'] = '地理位置';
$string['geolocation_help'] = '将来，我们可能会提供基于位置的搜索。如果您想指定您课程的位置，在此输入经纬度坐标（例如：-31.947884,115.871285）。可以用谷歌地图找到坐标。';
$string['hub'] = '中心服务器';
$string['imageurl'] = '图片地址';
$string['imageurl_help'] = '此图片会显示在中心服务器上。图片必须随时可以从中心服务器访问。图片的最大尺寸是{$a->width} X {$a->height}';
$string['information'] = '信息';
$string['language'] = '语言';
$string['language_help'] = '此课程的主要语言。';
$string['lasttimechecked'] = '上次检查时间';
$string['licence'] = '授权协议';
$string['licence_help'] = '选择用哪种许可证发布您的课程。';
$string['logourl'] = '标志的网页地址';
$string['modulenumberaverage'] = '课程模块数平均值（{$a}）';
$string['moodleorg'] = 'Moodle.org';
$string['mustselectsubject'] = '您必须选择一个主题';
$string['name'] = '名称';
$string['name_help'] = '此名称会显示在课程列表中。';
$string['neverchecked'] = '从未检查';
$string['next'] = '下一步';
$string['no'] = '不';
$string['nocheckstatusfromunreghub'] = '本网站未在此中心服务器注册，所以无法检查状态。';
$string['nohubselected'] = '未选定中心服务器';
$string['none'] = '无';
$string['nosearch'] = '不发布中心服务器或课程';
$string['notregisteredonhub'] = '再您可以开课之前，需要您的管理员至少注册一个中心服务器。联系您的站点管理员。';
$string['notregisteredonmoodleorg'] = '您的管理员需要在 moodle.org 注册此网站。';
$string['operation'] = '动作';
$string['orenterprivatehub'] = '也可以输入一个私有中心服务器的网址：';
$string['participantnumberaverage'] = '课程成员数平均值（{$a}）';
$string['postaladdress'] = '通信地址';
$string['postaladdress_help'] = '本站，或者代表本站的实体的通信地址。';
$string['postsnumber'] = '帖子数（{$a}）';
$string['previousregistrationdeleted'] = '已从{$a}删除早前的注册。您可以重新开始注册过程。谢谢。';
$string['prioritise'] = '优先级';
$string['privacy'] = '隐私';
$string['privacy_help'] = '中心服务器可能会显示已注册网站的列表。如果这样，那么您可以选择是否想出现在列表中。';
$string['private'] = '私有的';
$string['privatehuburl'] = '私有中心服务器网址';
$string['publicationinfo'] = '课程发布信息';
$string['publichub'] = '公共中心服务器';
$string['publishcourse'] = '发布“{$a}”';
$string['publishcourseon'] = '发布到{$a}';
$string['publishedon'] = '已发布在';
$string['publisheremail'] = '发布人email';
$string['publisheremail_help'] = '中心服务器管理员会通过发布人email通知发布人关于课程状态的各种变化。';
$string['publishername'] = '发布人';
$string['publishername_help'] = '发布人可以此课程的官方发布者，可以是个人，也可以是一个组织。除非您是替其他人发布，否则通常此人都是您自己。';
$string['publishon'] = '发布到';
$string['publishonspecifichub'] = '发布到另一个中心服务器';
$string['questionsnumber'] = '题目数（{$a}）';
$string['readvertiseon'] = '更新在{$a}的广告信息';
$string['registeredcourses'] = '已注册课程';
$string['registeredmoodleorg'] = 'Moodle.org（{$a}）';
$string['registeredon'] = '已经注册了的中心服务器';
$string['registeredsites'] = '已注册网站';
$string['registermoochtips'] = '要注册 Moodle.org Open Community Hub (MOOCH)，您的网站必须在 Moodle.org 注册。';
$string['registersite'] = '在{$a}注册';
$string['registerwith'] = '在中心服务器注册';
$string['registrationconfirmed'] = '网站注册已确认';
$string['registrationconfirmedon'] = '您已在中心服务器{$a}注册。您现在可以通过课程管理菜单中的“发布”链接向它发布课程。';
$string['registrationinfo'] = '注册信息';
$string['registrationupdated'] = '注册已更新。';
$string['registrationupdatedfailed'] = '注册更新失败。';
$string['removefromhub'] = '从中心服务器删除';
$string['renewregistration'] = '更新注册';
$string['resourcesnumber'] = '资源数（{$a}）';
$string['restartregistration'] = '重新开始注册';
$string['roleassignmentsnumber'] = '角色分配数（{$a}）';
$string['screenshots'] = '屏幕截图';
$string['screenshots_help'] = '课程所有截图都会在搜索结果中显示。';
$string['search'] = '搜索';
$string['selecthub'] = '选择中心服务器';
$string['selecthubforadvertise'] = '选择打广告的中心服务器';
$string['selecthubforsharing'] = '选上传的中心服务器';
$string['selecthubinfo'] = '社群中心是一个课程目录服务器。您只能在本Moodle网站注册过的中心服务器上发布您的课程。如果您想要的中心服务器没列在下面，请联系您的网站管理员。';
$string['sendfollowinginfo'] = '更多信息';
$string['sendfollowinginfo_help'] = '以下信息只会用来做整体统计，不会被公开。';
$string['sendingcourse'] = '正在发送课程';
$string['sendingsize'] = '课程文件（{$a->total}Mb）正在上传，请等待……';
$string['sent'] = '...结束';
$string['settings'] = '设置';
$string['settingsupdated'] = '设置已更新。';
$string['share'] = '共享此课程，供他人下载';
$string['shared'] = '共享';
$string['shareon'] = '上传此课程到{$a}';
$string['shareonhub'] = '上传此课程到中心服务器';
$string['sharepublication_help'] = '上传此课程到社群中心服务器后，别人就可以下载它，并在自己的Moodle网站上安装它。';
$string['siteadmin'] = '管理员';
$string['siteadmin_help'] = '管理员的全名';
$string['sitecountry'] = '国家';
$string['sitecountry_help'] = '您的组织所在的国家。';
$string['sitecreated'] = '网站已创建';
$string['sitedesc'] = '描述';
$string['sitedesc_help'] = '您网站的描述会显示在网站列表中。请只使用纯文本。';
$string['siteemail'] = 'Email地址';
$string['siteemail_help'] = '您需要提供一个email地址，以便中心服务器管理员在需要的时候联系您。它还有一些其它用途。建议输入一个与职位有关的地址（例如：sitemanager@example.com），而不是直接发给个人。';
$string['sitegeolocation'] = '地理坐标';
$string['sitegeolocation_help'] = '将来，我们可能会在中心服务器提供基于位置的搜索功能。如果您想标明网站的地址，请在此输入经度/纬度值（例如：-31.947884,115.871285）。一种找到坐标的方法是使用Google Maps。';
$string['sitelang'] = '语言';
$string['sitelang_help'] = '您网站的语言会显示在网站列表中。';
$string['sitename'] = '名称';
$string['sitename_help'] = '如果中心服务器允许，网站的名字会显示在网站列表中。';
$string['sitephone'] = '电话';
$string['sitephone_help'] = '只有中心服务器管理员能看到您的电话号码。';
$string['siteprivacy'] = '隐私';
$string['siteprivacylinked'] = '公开发布网站名及链接';
$string['siteprivacynotpublished'] = '请不要公开发布此网站';
$string['siteprivacypublished'] = '只公开发布网站名';
$string['siteregconfcomment'] = '您的网站需要在 {$a} 被最终确认（为了避免 {$a} 上的垃圾）';
$string['siteregistrationcontact'] = '联系表单';
$string['siteregistrationcontact_help'] = '如果您允许，其他人可以通过中心服务器提供的联系表单联系您。他们绝对不会看到您的email地址。';
$string['siteregistrationemail'] = 'Email通知';
$string['siteregistrationemail_help'] = '如果启用，中心服务器管理员会通过email通知您一些重要消息，比如安全问题。';
$string['siteregistrationupdated'] = '网站注册已更新';
$string['siterelease'] = 'Moodle发行版';
$string['siterelease_help'] = '本站使用的Moodle发行版本号。';
$string['siteupdatedcron'] = '“{$a}”已更新网站注册';
$string['siteupdatesend'] = '在中心服务器更新注册结束。';
$string['siteupdatesstart'] = '开始向中心服务器更新注册…';
$string['siteurl'] = '网站的网页地址';
$string['siteurl_help'] = '本站的网址。如果允许其它人看到网站地址，那么会使用此URL。';
$string['siteversion'] = 'Moodle版本';
$string['siteversion_help'] = '本站的Moodle版本号。';
$string['specifichubregistrationdetail'] = '您也可以在其它moodle社群中注册您的网站。';
$string['statistics'] = '保密统计';
$string['status'] = '中心服务器列出';
$string['statuspublished'] = '已列出';
$string['statusunpublished'] = '未列出';
$string['subject'] = '主题';
$string['subject_help'] = '选择此课程涉及的主要专业领域。';
$string['tags'] = '标签';
$string['tags_help'] = '用来进一步给你的课程分类的标签。请使用简单、有意义的词，并用逗号分开。例如：数学,代数,几何';
$string['trustme'] = '信任';
$string['type'] = '广告/共享';
$string['unknownstatus'] = '未知';
$string['unlistedurl'] = '未列出的中心服务器URL';
$string['unprioritise'] = '无优先级';
$string['unpublish'] = '取消发布';
$string['unpublishalladvertisedcourses'] = '删除所有正在中心服务器做广告的课程';
$string['unpublishalluploadedcourses'] = '删除所有上传到中心服务器的课程';
$string['unpublishconfirmation'] = '您确信要从中心服务器“{$a->hubname}”删除课程“{$a->courseshortname}”吗';
$string['unpublishcourse'] = '取消发布{$a}';
$string['unregister'] = '取消注册';
$string['unregisterconfirmation'] = '您将要从中心服务器 {$a} 取消此网站的注册。如果您断开连接，您将不能管理留在那里的课程。您确信要取消注册吗？';
$string['unregisterfrom'] = '取消在{$a}的注册';
$string['unregistrationerror'] = '从中心服务器取消注册时发生错误：{$a}';
$string['untrustme'] = '不信任';
$string['update'] = '更新';
$string['updatesite'] = '在{$a}更新注册信息';
$string['updatestatus'] = '现在检查。';
$string['uploaded'] = '已上传';
$string['url'] = '中心服务器URL';
$string['urlalreadyregistered'] = '您的网站好像已经在此中心服务器注册过了，也就是说出了些问题。请联系中心服务器管理员重置您的注册，然后再试试。';
$string['usersnumber'] = '用户数（{$a}）';
$string['warning'] = '警告';
$string['wrongtoken'] = '注册因未知原因（网络问题？）失败。请重试。';
$string['wrongurlformat'] = '错误的 URL 格式';
$string['xmlrpcdisabledcommunity'] = '本服务器未开启 XML-RPC扩展功能，你不能搜索或下载课程。';
$string['xmlrpcdisabledpublish'] = '本服务器未开启 XML-RPC扩展功能，你不能发布课程或管理已发布的课程。';
$string['xmlrpcdisabledregistration'] = '此服务器未启用XML-RPC扩展。在启用之前，您不能取消或更新您的注册。';
