<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   bigbluebuttonbn
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = '你有即將開始的視訊會議';
$string['bbbduetimeoverstartingtime'] = '這一活動的到期時間必須早於開始時間';
$string['bbbdurationwarning'] = '這一次會議的最長時間是 %duration%分鐘';
$string['bbbrecordwarning'] = '這一次會議可以被錄製';
$string['bigbluebuttonbn'] = 'BigBlueButton視訊會議';
$string['bigbluebuttonbn:addinstance'] = '新增一個會議';
$string['bigbluebuttonbn:join'] = '加入一個會議';
$string['bigbluebuttonbn:managerecordings'] = '管理錄影';
$string['bigbluebuttonbn:moderate'] = '主持會議';
$string['config_extended_capabilities'] = '擴展功能的配置';
$string['config_extended_capabilities_description'] = '擴展功能的配置，若視訊會議伺服器有提供這些功能';
$string['config_extended_feature_recordingready_enabled'] = '已啟用"可錄製時發出通知信"';
$string['config_extended_feature_recordingready_enabled_description'] = '當可錄製功能被啟用時，發出通知';
$string['config_extended_feature_uidelegation_enabled'] = '已啟用操作介面';
$string['config_extended_feature_uidelegation_enabled_description'] = '這一設定啟用或關閉對於視訊會議伺服器的操作介面';
$string['config_feature_importrecordings'] = '"匯入錄製檔"功能的設定';
$string['config_feature_importrecordings_description'] = '這些設定只適用於特定功能';
$string['config_feature_importrecordings_enabled'] = '已啟用"匯入錄製檔"';
$string['config_feature_importrecordings_enabled_description'] = '當這個和錄製功能被啟用後，就可以從不同的課程匯入錄製檔到一個活動中。';
$string['config_feature_importrecordings_from_deleted_activities_enabled'] = '已啟用"從已刪除的活動匯入錄製檔"';
$string['config_feature_preuploadpresentation'] = '"預先上傳簡報"功能的配置';
$string['config_feature_preuploadpresentation_enabled'] = '已啟用預先上傳簡報';
$string['config_feature_preuploadpresentation_enabled_description'] = '當新增或更新這教室或會議時，在操作介面上預設是已啟用"預先上傳簡報"的功能';
$string['config_feature_recording'] = '"錄影"功能的配置';
$string['config_feature_recording_default'] = '預設會啟用錄影功能';
$string['config_feature_recording_default_description'] = '若啟用，你所建立的視訊會議將會有錄影的功能';
$string['config_feature_recording_description'] = '這些設定只適用於特定功能';
$string['config_feature_recording_editable'] = '錄影功能可以被編輯';
$string['config_feature_recording_editable_description'] = '若勾選，在操作介面上會包含一個可以開啟或關閉錄影功能的選項';
$string['config_feature_recording_icons_enabled'] = '已啟用錄影檔管理';
$string['config_feature_recording_icons_enabled_description'] = '若啟用，錄影檔管理面板會顯示小圖示來做公佈、取消公布和刪除檔案的動作。';
$string['config_feature_recordingtagging'] = '"錄影檔加標籤"功能的配置';
$string['config_feature_recordingtagging_default'] = '預設會啟用"錄影檔加標籤"';
$string['config_feature_recordingtagging_description'] = '這些設定只適用於特定功能';
$string['config_feature_recordingtagging_editable'] = '"錄影檔加標籤"可以被編輯';
$string['config_feature_recordingtagging_editable_description'] = '當新增或更新這教室或會議時，預設上是"錄影檔加標籤"可被編輯';
$string['config_feature_sendnotifications'] = '"送出通知"功能的配置';
$string['config_feature_sendnotifications_description'] = '這些設定會啟用或關閉操作介面的選項，且也界定這些選項的預設值。';
$string['config_feature_sendnotifications_enabled'] = '已啟用送出通知';
$string['config_feature_sendnotifications_enabled_description'] = '當新增或更新這教室或會議時，預設上是在操作介面上啟用送出通知功能';
$string['config_feature_userlimit'] = '"用戶人數限制"功能的配置';
$string['config_feature_userlimit_default'] = '"用戶人數限制"已預設為啟用';
$string['config_feature_userlimit_default_description'] = '當添加一個教室或會議時，預設的可同時參與的人數。若這數字設為0，即表示沒有人數限制。';
$string['config_feature_userlimit_description'] = '這些設定會啟用或關閉操作介面的選項，且也界定這些選項的預設值。';
$string['config_feature_userlimit_editable'] = '"用戶人數限制"功能可以被編輯';
$string['config_feature_userlimit_editable_description'] = '當新增或更新這教室或會議時，預設上是可以編輯"用戶人數限制"';
$string['config_feature_voicebridge'] = '"電話連線"功能的配置';
$string['config_feature_voicebridge_description'] = '這些設定會啟用或關閉操作介面的選項，且也界定這些選項的預設值。';
$string['config_feature_voicebridge_editable'] = '會議的電話連線號碼可以被編輯';
$string['config_feature_waitformoderator'] = '"等待主持人"功能的配置';
$string['config_feature_waitformoderator_cache_ttl'] = '等待主持人快取存活時間(秒)';
$string['config_feature_waitformoderator_cache_ttl_description'] = '為了支援人數眾多的客戶，這插件使用了快取。這一參數界定在下一個請求送到會議伺服器之前，快取保留在記憶體的時間長短。';
$string['config_feature_waitformoderator_default'] = '"等待主持人"功能預設為已啟用';
$string['config_feature_waitformoderator_default_description'] = '當添加一個新討論室或會議時，"等待主持人"功能會預設為已啟用';
$string['config_feature_waitformoderator_description'] = '這些設定只適用於特定功能';
$string['config_feature_waitformoderator_editable'] = '"等待主持人"功能可以被編輯';
$string['config_feature_waitformoderator_editable_description'] = '當添加或更新教室或會議時，預設上，"等待主持人"的值是可以被編輯';
$string['config_general'] = '一般配置';
$string['config_general_description'] = '這些設定是<b>永遠</b>被使用';
$string['config_permission'] = '權限配置';
$string['config_permission_description'] = '這些設定定義了建立的教室或會議的預設權限';
$string['config_permission_moderator_default'] = '預設的主持人';
$string['config_permission_moderator_default_description'] = '當添加一個新教室或會議時，預設會使用的規則';
$string['config_scheduled'] = '"排定的會議"的配置';
$string['config_scheduled_description'] = '這些設定界定了"排定的會議"的預設運作方式';
$string['config_scheduled_duration_compensation'] = '拖延時間(分鐘)';
$string['config_scheduled_duration_compensation_description'] = '在計算時間長短時，在排定的結束時間之後所增加的分鐘數';
$string['config_scheduled_duration_enabled'] = '已啟用計算時間長短';
$string['config_scheduled_duration_enabled_description'] = '安排的會議的時間長短是依據開始和結束時間來計算';
$string['config_scheduled_pre_opening'] = '在開始時間之前多久可以進入(分鐘)';
$string['config_scheduled_pre_opening_description'] = '在排定的開始時間之前的幾分鐘可以進入這一會議';
$string['config_server_url'] = '視訊會議伺服器網址';
$string['config_server_url_description'] = '你的視訊會議伺服器的網址必須以 /bigbluebutton/做結尾。(這一預設的網址是blindside 網路所提供視訊會議伺服器，它可供你進行測試)';
$string['config_shared_secret'] = '視訊會議共用密碼';
$string['config_shared_secret_description'] = '你的視訊會議伺服器的密碼。(這預設的密碼是由 Blindside 網路公司所提供的網路視訊會議伺服器專用的密碼，你可用它來進行測試)';
$string['config_warning_curl_not_installed'] = '若要使用這功能，需要PHP已經安裝並啟用CURL擴展。只有這一條件具備，才能使用這些設定。';
$string['email_body_notification_meeting_by'] = '由';
$string['email_body_notification_meeting_description'] = '說明';
$string['email_body_notification_meeting_details'] = '細節';
$string['email_body_notification_meeting_end_date'] = '結束時間';
$string['email_body_notification_meeting_has_been'] = '已經有';
$string['email_body_notification_meeting_start_date'] = '開始時間';
$string['email_body_notification_meeting_title'] = '標題';
$string['email_body_recording_ready_for'] = '錄製給';
$string['email_body_recording_ready_is_ready'] = '已準備好';
$string['email_footer_sent_by'] = '這自動通知的訊息是來自：';
$string['email_footer_sent_from'] = '從這課程';
$string['email_title_notification_has_been'] = '已經';
$string['event_activity_created'] = '已建立同步視訊會議活動';
$string['event_activity_deleted'] = '已刪除同步視訊會議活動';
$string['event_activity_modified'] = '已更改同步視訊會議活動';
$string['event_activity_viewed'] = '已檢視同步視訊會議活動';
$string['event_activity_viewed_all'] = '已檢視同步視訊會議活動管理';
$string['event_meeting_created'] = '已建立同步視訊會議';
$string['event_meeting_ended'] = '已強制結束同步視訊會議';
$string['event_meeting_joined'] = '已加入同步視訊會議';
$string['event_meeting_left'] = '已離開同步視訊會議';
$string['event_recording_deleted'] = '已刪除錄影檔';
$string['event_recording_imported'] = '已匯入錄影檔';
$string['event_recording_published'] = '已發佈錄影檔';
$string['event_recording_unpublished'] = '未發佈錄影檔';
$string['general_error_unable_connect'] = '無法連結。請檢查視訊會議伺服器的網址，並檢查該伺服器是否正在運作中';
$string['index_confirm_end'] = '你希望結束這虛擬教室嗎？';
$string['index_disabled'] = '已關閉';
$string['index_enabled'] = '已啟用';
$string['index_ending'] = '虛擬教室正在結束...請等待';
$string['index_error_checksum'] = '檢查時發生錯誤。請確定你輸入的添加碼';
$string['index_error_forciblyended'] = '無法加入這一會議，因為已經被手動地結束';
$string['index_error_unable_display'] = '無法顯示這視訊會議。請檢查視訊會議伺服器的網址，並檢查這伺服器是否正在運作中';
$string['index_heading'] = '同步視訊會議室';
$string['index_heading_actions'] = '行動';
$string['index_heading_group'] = '群組';
$string['index_heading_moderator'] = '主持人';
$string['index_heading_name'] = '房間';
$string['index_heading_recording'] = '錄影紀錄';
$string['index_heading_users'] = '用戶';
$string['index_heading_viewer'] = '觀眾';
$string['mod_form_block_general'] = '一般設定';
$string['mod_form_block_participants'] = '參與人員';
$string['mod_form_block_presentation'] = '簡報內容';
$string['mod_form_block_record'] = '錄製的設定';
$string['mod_form_block_schedule'] = '會議的時間安排';
$string['mod_form_field_closingtime'] = '關閉的時間';
$string['mod_form_field_conference_name'] = '會議名稱';
$string['mod_form_field_duration'] = '長度';
$string['mod_form_field_duration_help'] = '設定會議時間的長度，可讓會議錄製檔結束之前，維持會議持續運作。';
$string['mod_form_field_intro'] = '說明';
$string['mod_form_field_intro_help'] = '這會議室或會議的簡短描述';
$string['mod_form_field_name'] = '虛擬教室名稱';
$string['mod_form_field_notification'] = '傳送提醒通知';
$string['mod_form_field_notification_created_help'] = '送出一通知給有選課的用戶，讓他們知道這一活動已經被建立';
$string['mod_form_field_notification_help'] = '送出一通知給有選課的用戶，讓他們知道這一活動已經被建立或更改';
$string['mod_form_field_notification_modified_help'] = '送出一通知給有選課的用戶，讓他們知道這一活動已經被更改';
$string['mod_form_field_notification_msg_at'] = '在';
$string['mod_form_field_notification_msg_created'] = '已建立';
$string['mod_form_field_notification_msg_modified'] = '已修改';
$string['mod_form_field_openingtime'] = '開放參加';
$string['mod_form_field_participant_add'] = '增加參與人員';
$string['mod_form_field_participant_bbb_role_moderator'] = '主持人';
$string['mod_form_field_participant_bbb_role_viewer'] = '觀眾';
$string['mod_form_field_participant_list'] = '參加人員名單';
$string['mod_form_field_participant_list_action_add'] = '加入';
$string['mod_form_field_participant_list_action_remove'] = '移除';
$string['mod_form_field_participant_list_text_as'] = '為';
$string['mod_form_field_participant_list_type_all'] = '課程全部人員';
$string['mod_form_field_participant_list_type_owner'] = '擁有人';
$string['mod_form_field_participant_list_type_role'] = '角色';
$string['mod_form_field_participant_list_type_user'] = '用戶';
$string['mod_form_field_predefinedprofile'] = '預先設定的會議資料表';
$string['mod_form_field_predefinedprofile_help'] = '預先設定的會議資料表';
$string['mod_form_field_record'] = '活動可以錄影';
$string['mod_form_field_recordingtagging'] = '啟用標記介面';
$string['mod_form_field_room_name'] = '會議室名稱';
$string['mod_form_field_userlimit'] = '用戶限制';
$string['mod_form_field_userlimit_help'] = '一個會議最高可多少人參加。若限制設為0，表示無人數限制。';
$string['mod_form_field_voicebridge'] = '電話連線代號[####]';
$string['mod_form_field_voicebridge_format_error'] = '格式錯誤。你必須輸入一個 從 1 到 9999 之間的數目字。';
$string['mod_form_field_voicebridge_help'] = '電話連線代號是指參與者要使用撥號方式進入聲音會議所要輸入的號碼。你必須輸入一個 從 1 到 9999 之間的數目字。若你輸入0，固定的連接號碼將會被忽略，而視訊會議系統將會產生一個以7開頭的四位數隨機號碼。';
$string['mod_form_field_voicebridge_notunique_error'] = '不是獨一無二的數值。這數字已經被其他房間或會議所使用。';
$string['mod_form_field_wait'] = '等候主持人';
$string['mod_form_field_wait_help'] = '觀眾必須等待，直到一個主持人進入這視訊會議';
$string['mod_form_field_welcome'] = '歡迎訊息';
$string['mod_form_field_welcome_default'] = '<br>歡迎來到<b>%%CONFNAME%%</b>!<br><br>要了解此視訊會議系統如何運作，請看我們的 <a href="event:http://www.bigbluebutton.org/content/videos"><u>教學影片</u></a>。<br><br>若您想要加入以聲音進行對話，請點選(在左上角)耳機圖示。 <b>請您戴上耳機以免干擾到別人。</b>';
$string['mod_form_field_welcome_help'] = '取代視訊會議伺服器預設的歡迎詞。這歡迎詞可以包括一些變數，如 (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%)。它們在顯示時會自動被替換掉，且也可加上html 標籤，像是 <b>...</b> 或 <i></i>';
$string['modulename'] = '同步視訊會議';
$string['modulename_help'] = 'BigBlueButton 是用於遠距教育的一種開放源碼的網路會議系統。而
BigBlueButtonBN 可讓你經由 Moodle 的連結建立一個及時、線上的虛擬教室。

使用BigBlueButtonBN你可以指定標題、說明、行事曆項目 (設定可加入會議的起迄時間)、群組，和有關此線上會議錄影的細節。

稍後要觀看錄影檔，請加上一個 RecordingsBN 資源到這一課程。';
$string['modulenameplural'] = '同步視訊會議';
$string['pluginadministration'] = '同步視訊會議管理';
$string['pluginname'] = '同步視訊會議';
$string['predefined_profile_classroom'] = '教室';
$string['predefined_profile_collaborationroom'] = '合作工作室';
$string['predefined_profile_conferenceroom'] = '會議室';
$string['predefined_profile_default'] = '預設';
$string['predefined_profile_scheduledsession'] = '排定的會議';
$string['serverhost'] = '伺服器名稱';
$string['view_conference_action_end'] = '結束活動';
$string['view_conference_action_join'] = '參加活動';
$string['view_error_bigbluebutton'] = '視訊會議回應錯誤訊息。{$a}';
$string['view_error_create'] = '這視訊會議伺服器回應一個錯誤訊息，這會議不能夠建立。';
$string['view_error_import_no_courses'] = '沒有課程可供尋找錄影檔';
$string['view_error_import_no_recordings'] = '這一課程沒有錄影檔可供匯入';
$string['view_error_max_concurrent'] = '已經達到可同時參與會議的最高人數';
$string['view_error_no_group'] = '這兒沒有配置群組。請在加入會議之前設定群組。';
$string['view_error_no_group_student'] = '你沒有加入一個群組，請聯絡你的教師或管理員。';
$string['view_error_no_group_teacher'] = '這裡還沒有配置群組。請設定群組或聯絡管理員。';
$string['view_error_unable_join'] = '無法加入會議。請檢查BigBlueButton 伺服器的網址，並檢查它是否在運作中。';
$string['view_error_unable_join_student'] = '無法連結到視訊會議伺服器。請聯絡你的教師或網站管理員。';
$string['view_error_unable_join_teacher'] = '無法連結到視訊會議伺服器。請聯絡網站管理員。';
$string['view_error_url_missing_parameters'] = '這一網址上少了一些參數';
$string['view_error_userlimit_reached'] = '已經達到這會議的最大人數限制';
$string['view_groups_selection'] = '選擇你要加入的群組，並加以確認';
$string['view_groups_selection_join'] = '參加';
$string['view_groups_selection_warning'] = '這是一個為各群組開設的會議室，如果您有參加多個群組，請先確認您選擇了正確的。';
$string['view_login_moderator'] = '登入為主持人...';
$string['view_login_viewer'] = '登入為觀眾...';
$string['view_message_conference_has_ended'] = '會議已經結束。';
$string['view_message_conference_in_progress'] = '會議進行中';
$string['view_message_conference_not_started'] = '會議尚未開始。';
$string['view_message_conference_room_ready'] = '這個會議室已經準備好，您現在可以立刻參加活動。';
$string['view_message_conference_wait_for_moderator'] = '等候主持人才能進入。';
$string['view_message_finished'] = '這活動結束了。';
$string['view_message_has_joined'] = '已經加入';
$string['view_message_have_joined'] = '已經加入';
$string['view_message_hour'] = '時';
$string['view_message_hours'] = '時';
$string['view_message_minute'] = '分';
$string['view_message_minutes'] = '分';
$string['view_message_moderator'] = '主持人';
$string['view_message_moderators'] = '主持人';
$string['view_message_norecordings'] = '這個視訊會議目前沒有錄影紀錄。';
$string['view_message_notavailableyet'] = '這活動還不能參加。';
$string['view_message_room_closed'] = '這一討論室已經關閉';
$string['view_message_room_open'] = '這一討論室是開起的';
$string['view_message_room_ready'] = '這一討論室以準備好';
$string['view_message_session_has_user'] = '這裡有';
$string['view_message_session_has_users'] = '這裡有';
$string['view_message_session_no_users'] = '這裡沒有用戶在此議程中';
$string['view_message_session_running_for'] = '這議程已經進行了';
$string['view_message_session_started_at'] = '活動開始於';
$string['view_message_tab_close'] = '這一分頁/視窗必須手動地關閉';
$string['view_message_user'] = '用戶';
$string['view_message_users'] = '用戶';
$string['view_message_viewer'] = '觀眾';
$string['view_message_viewers'] = '觀眾';
$string['view_noguests'] = '同步視訊會議未開放給訪客參加';
$string['view_nojoin'] = '你不具備有能加入這議程的角色';
$string['view_recording'] = '錄影檔';
$string['view_recording_actionbar'] = '工具列';
$string['view_recording_activity'] = '活動';
$string['view_recording_button_import'] = '匯入錄製連結';
$string['view_recording_button_return'] = '回去';
$string['view_recording_course'] = '課程';
$string['view_recording_date'] = '時間';
$string['view_recording_delete_confirmation'] = '你確定要刪除這一{$a}？';
$string['view_recording_delete_confirmation_warning_p'] = '這一錄影檔有{$a}個連結連接到它，他們存在不同的課程或活動上。若這錄影檔被刪除，這些連結也將被移除。';
$string['view_recording_delete_confirmation_warning_s'] = '這一錄影檔有{$a}個連結連接到它，他們存在不同的課程或活動上。若這錄影檔被刪除，這些連結也將被移除。';
$string['view_recording_description'] = '說明';
$string['view_recording_duration'] = '長度';
$string['view_recording_duration_min'] = '分';
$string['view_recording_format_presentation'] = '簡報';
$string['view_recording_format_video'] = '影片';
$string['view_recording_import_confirmation'] = '是確定要匯入這一錄製嗎？';
$string['view_recording_length'] = '長度';
$string['view_recording_link_warning'] = '這是一個連結，它指向一個在別的課程或活動中所建立的錄製檔。';
$string['view_recording_list_actionbar'] = '工具列';
$string['view_recording_list_actionbar_delete'] = '刪除';
$string['view_recording_list_actionbar_deleting'] = '刪除中';
$string['view_recording_list_actionbar_hide'] = '隱藏';
$string['view_recording_list_actionbar_processing'] = '處理中';
$string['view_recording_list_actionbar_publish'] = '公布';
$string['view_recording_list_actionbar_publishing'] = '公布中';
$string['view_recording_list_actionbar_show'] = '顯示';
$string['view_recording_list_actionbar_unpublish'] = '取消公布';
$string['view_recording_list_actionbar_unpublishing'] = '取消公布';
$string['view_recording_list_activity'] = '活動';
$string['view_recording_list_course'] = '課程';
$string['view_recording_list_date'] = '時間';
$string['view_recording_list_description'] = '說明';
$string['view_recording_list_duration'] = '長度';
$string['view_recording_list_recording'] = '錄影紀錄';
$string['view_recording_modal_button'] = '套用';
$string['view_recording_modal_title'] = '設定錄影的參數';
$string['view_recording_name'] = '名稱';
$string['view_recording_publish_link_error'] = '這一連結無法重新公布，因為實體的錄影檔已被取消公布';
$string['view_recording_recording'] = '錄影紀錄';
$string['view_recording_tags'] = '標籤';
$string['view_recording_unpublish_confirmation'] = '你確定要將這{$a}取消公布？';
$string['view_recording_unpublish_confirmation_warning_p'] = '這一錄影檔有{$a}個連結連接到它，他們存在不同的課程或活動上。若這紀錄檔取消公布，這些連結也將被取消公布。';
$string['view_recording_unpublish_confirmation_warning_s'] = '這一錄影檔有{$a}個連結連接到它，他們存在不同的課程或活動上。若這紀錄檔取消公布，這些連結也將被取消公布。';
$string['view_section_title_presentation'] = '簡報檔';
$string['view_section_title_recordings'] = '錄影紀錄';
