<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'booking', language 'zh_tw', branch 'MOODLE_31_STABLE'
 *
 * @package   booking
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycompleted'] = '活動已完成';
$string['activitycompletionsuccess'] = '活動已完成-所選使用者被標記';
$string['addcategory'] = '編輯目錄';
$string['addeditbooking'] = '編輯劃位';
$string['additionalfields'] = '額外使用者屬性欄位';
$string['addmorebookings'] = '新增更多座位/席次';
$string['addnewbookingoption'] = '增加新劃位選項';
$string['addnewcategory'] = '新增目錄';
$string['addnewinstitution'] = '新增機構';
$string['addnewoptiondates'] = '新增議程';
$string['addnewtagtemplate'] = '新增標籤範本';
$string['address'] = '地址';
$string['addteachers'] = '新增老師';
$string['addtocalendar'] = '加入行事曆';
$string['addtogroup'] = '自動以群組內使用者選課';
$string['addtogroup_help'] = '自動以群組內使用者選課-群組將自動建立名稱"劃位名-選項名"';
$string['advancedoptions'] = '進階選項';
$string['agreetobookingpolicy'] = '我已閱讀並同意劃位規則';
$string['allbookingoptions'] = '下載所有劃位選項的使用者';
$string['allchangessave'] = '已存所有變更';
$string['allmailssend'] = '所有郵件清單已寄送至使用者完成';
$string['allowdelete'] = '允許自行取消劃位';
$string['allowupdate'] = '允許劃位被更新';
$string['answer'] = '回覆';
$string['answered'] = '已回覆';
$string['associatedcourse'] = '被關連的課程';
$string['attachedfiles'] = '附加檔案';
$string['attachical'] = '掛載ical事件';
$string['attachicaldesc'] = '若開啟郵件通過將包括ical事件';
$string['autoenrol'] = '使用者自動選課';
$string['autoenrol_help'] = '若勾選,當使用者從課程中選課或取消，將被關連至相關的課程';
$string['availability'] = '仍可劃位';
$string['available'] = '仍有空位';
$string['backtoresponses'] = '<< 退至回應';
$string['banusernames'] = '欲阻擋之使用者名';
$string['banusernames_help'] = '限制哪類免費郵件域名不能使用，以逗號隔開，如要阻擋gmail及yahoo使用者可輸入:gmail.com, yahoo.com';
$string['banusernameswarning'] = '您的使用者被擋無法劃位';
$string['booked'] = '已劃位';
$string['bookedpast'] = '已劃位(課程完成)';
$string['bookedtext'] = '劃位確認';
$string['bookedtext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中。
<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{startdate}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['bookedusers'] = '已劃位使用者';
$string['booking'] = '劃位';
$string['booking:addinstance'] = '新增劃位';
$string['bookingattachment'] = '附件';
$string['bookingcategory'] = '目錄';
$string['booking:choose'] = '劃位';
$string['bookingclose'] = '直到';
$string['booking:communicate'] = '可溝通';
$string['bookingdeleted'] = '你的劃位已被取消';
$string['booking:deleteresponses'] = '刪除回應';
$string['booking:downloadresponses'] = '下載回應';
$string['bookingduration'] = '期間';
$string['bookingfull'] = '已無空位';
$string['bookingfulldidntregister'] = '選項已滿,無法傳給所有使用者';
$string['bookingmanagererror'] = '輸入使用者名稱不正確,可能不存在或有一個以上相同的使用者名稱';
$string['bookingmeanwhilefull'] = '最位空位已被佔。';
$string['bookingname'] = '劃位名稱';
$string['bookingopen'] = '開放';
$string['bookingoptionsmenu'] = '劃位選項';
$string['bookingorganizatorname'] = '創建者名';
$string['bookingpoints'] = '課程點數';
$string['bookingpolicy'] = '劃位規則';
$string['bookingpollurl'] = '問卷調查連結';
$string['bookingpollurlteachers'] = '講師問卷連結';
$string['booking:rate'] = '評比被選的劃位選項';
$string['booking:readresponses'] = '讀取回應';
$string['bookingsaved'] = '你的劃位已儲存.現在可以繼續其他課程的劃位';
$string['booking:sendpollurl'] = '傳送問卷調查連結';
$string['booking:sendpollurltoteachers'] = '傳送講師問卷連結';
$string['booking:subscribeusers'] = '為其他使用者建立劃位';
$string['bookingtags'] = '標籤';
$string['bookingtext'] = '劃位說明';
$string['booking:updatebooking'] = '管理劃位選項';
$string['booking:viewallratings'] = '檢視個人的所有評比';
$string['booking:viewanyrating'] = '檢視來自所有人的總評比';
$string['booking:viewrating'] = '檢視來自自已的總評比';
$string['booknow'] = '馬上登記';
$string['bookotherusers'] = '登記其他使用者';
$string['booktootherbooking'] = '登記使用者至其他劃位';
$string['btnbooknowname'] = '"馬上登記"的按鈕名稱';
$string['btncacname'] = '"確認活動完成"的按鈕名稱';
$string['btncancelname'] = '"取消劃位"的按鈕名稱';
$string['cancancelbook'] = '當開始時允許使用取消或預約劃位';
$string['cancel'] = '取消';
$string['cancelbooking'] = '取消劃位';
$string['categories'] = '目錄';
$string['category'] = '目錄';
$string['categoryname'] = '目錄名';
$string['choosecourse'] = '選擇課程';
$string['closed'] = '劃位已關閉';
$string['completed'] = '完成';
$string['conectedbooking'] = '取消劃位';
$string['conectedbooking_help'] = '哪些劃位的使用者會核可，可定義哪些選項及多少使用者你會核可。';
$string['confirmactivitycompletion'] = '確認活動完成';
$string['confirmationmessage'] = '您的劃位已被登記


劃位狀態: {$a->status}
參與人員:   {$a->participant}
課程名稱:   {$a->title}
開課日期: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
檢視您所有劃位的課程，點選連結: {$a->bookinglink}
相關課程可以在此找到，點選連結: {$a->courselink}';
$string['confirmationmessagesettings'] = '確認郵件設定';
$string['confirmationmessagewaitinglist'] = '您好 {$a->participant},

您的劃位請求已被登記

劃位狀態: {$a->status}
參與人員:   {$a->participant}
課程名稱:   {$a->title}
開課日期: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
檢視您所有劃位的課程，點選連結: {$a->bookinglink}';
$string['confirmationsubject'] = '{$a->title} 劃位確認';
$string['confirmationsubjectbookingmanager'] = '{$a->participant} 新劃位';
$string['confirmationsubjectwaitinglist'] = '{$a->title} 創位狀態';
$string['confirmationsubjectwaitinglistmanager'] = '{$a->title} 創位狀態';
$string['confirmbookingoffollowing'] = '請確認下列課程的劃位';
$string['confirmdeletebookingoption'] = '是否刪除劃位選項';
$string['copyonlythisbookingurl'] = '複製劃位的URL';
$string['copypollurl'] = '複製問卷調查URL';
$string['copytoclipboard'] = '複製至剪貼簿:Ctrl+C,Enter';
$string['coursedate'] = '日期';
$string['courseendtime'] = '課程結束時間';
$string['coursestarttime'] = '課程開始時間';
$string['createdby'] = 'Booking module created by edulabs.org';
$string['csvfile'] = 'CSV檔';
$string['csvfile_help'] = 'CSV檔必須包括僅一個欄位名:機構名';
$string['customlabels'] = '客製化標簽';
$string['dateerror'] = '錯誤的日期在行 {$a}:';
$string['datenotset'] = '日期未設置';
$string['dateparseformat'] = '日期解析格式';
$string['dateparseformat_help'] = 'Please, use date format like specified in CSV file. Help with <a href="http://php.net/manual/en/function.date.php">this</a> resource for options.';
$string['days'] = '{$a} 日';
$string['daystonotify'] = '會議開始前多少日須通知參與人員?';
$string['daystonotify_help'] = '若設置於0則停用此功能';
$string['defaultbookingoption'] = '預設劃位選項';
$string['defaultdateformat'] = 'j.n.Y H:i:s';
$string['delete'] = '刪除';
$string['deletebooking'] = '您是否真要解除訂閱下列課程? <br /><br /> <b>{$a} </b>';
$string['deletebookingoption'] = '刪除劃位選項';
$string['deletecategory'] = '刪除';
$string['deletedbookingmessage'] = '下列課程中刪除劃位: {$a->title}

使用者名稱: {$a->participant}
課程名稱: {$a->title}
開課期間: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
課程連結: {$a->courselink}
劃位連結: {$a->bookinglink}';
$string['deletedbookingsubject'] = '刪除劃位: {$a->title} by {$a->participant}';
$string['deletedbookingusermessage'] = '您好 {$a->participant},

您查詢的課程 {$a->title} ({$a->startdate} {$a->starttime}) 已取消';
$string['deletedbookingusersubject'] = '創位課程 {$a->title} 已取消';
$string['deletedrule'] = '規則已刪除成功';
$string['deletedtext'] = '取消劃位訊息';
$string['deletedtext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中。


<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['deleterule'] = '刪除';
$string['deletesubcategory'] = '請缺刪除本目錄中的子目錄';
$string['deleteuserfrombooking'] = '是否要刪除劃位的使用者';
$string['disablebookingusers'] = '使用者停用劃位-隱藏馬上登記按鈕';
$string['donotselectcourse'] = '無選擇課程';
$string['download'] = '下載';
$string['downloadallresponses'] = '下載所有劃位選項的所有回應';
$string['downloadusersforthisoptionods'] = '下載使用者為 .ods';
$string['downloadusersforthisoptionxls'] = '下載使用者為 .xls';
$string['duplicatebooking'] = '劃位選項重覆';
$string['editcategory'] = '編輯';
$string['editinstitutions'] = '編輯機構';
$string['editotherbooking'] = '其他劃位規則';
$string['editrule'] = '編輯';
$string['edittag'] = '編輯';
$string['editteachers'] = '編輯';
$string['enablecompletion'] = '在劃位選項回應中啟用手動活動完成';
$string['enablecompletiongroup'] = '手動活動完成';
$string['endtimenotset'] = '結束日期未設置';
$string['entervalidurl'] = '請輸入正確的URL';
$string['error:failedtosendconfirmation'] = '下列使用者未收到確認郵件

劃位狀態: {$a->status}
參與人員:   {$a->participant}
課程名稱:   {$a->title}
開課期間: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
劃位連結: {$a->bookinglink}
相關課程: {$a->courselink}';
$string['eventbooking_cancelled'] = '劃位已取消';
$string['eventbookingoption_booked'] = '劃位選項已登記';
$string['eventduration'] = '會議期間';
$string['eventpoints'] = '點數';
$string['eventreport_viewed'] = '報表檢視';
$string['eventtype'] = '會議類型';
$string['eventuserprofilefields_updated'] = '使用者資料已更新';
$string['excelfile'] = '活動完成的CSV檔';
$string['existingsubscribers'] = '現有訂閱';
$string['expired'] = '抱歉,活動結束於 {$a} 無法使用';
$string['fillinatleastoneoption'] = '需至少提供二個可能的答案';
$string['forcourse'] = '課程';
$string['full'] = '完整';
$string['fullname'] = '全名';
$string['generaterecnum'] = '產生號碼';
$string['generaterecnumareyousure'] = '將產生新號碼並且強制刪除舊有的';
$string['generaterecnumnotification'] = '新號碼已成功產生';
$string['goenrol'] = '前往登記劃位';
$string['gotobooking'] = '<< 劃位';
$string['gotop'] = '前往最頂';
$string['groupname'] = '群組名稱';
$string['havetologin'] = '傳送劃位資訊前須登入本網站';
$string['hours'] = '{$a} 小時';
$string['howmanyusers'] = '多少使用者可以登記';
$string['importcsvbookingoption'] = '用劃位選項匯入CSV';
$string['importcsvtitle'] = '匯入CSV';
$string['importexcelbutton'] = '匯入活動完成';
$string['importexceltitle'] = '匯入活動完成';
$string['importfinished'] = '匯入完成';
$string['infonobookingoption'] = '為新增第一個劃位選項請使用區域';
$string['institution'] = '機構';
$string['institutionname'] = '機構名稱';
$string['institutions'] = '機構';
$string['lblacceptingfrom'] = '"確認來自..."標籤名稱';
$string['lblbooking'] = '"劃位"標籤名稱';
$string['lblbooktootherbooking'] = '"登記使用者到其他劃位"按鈕名稱';
$string['lblinstitution'] = '"機構"標籤名稱';
$string['lbllocation'] = '"地點"標籤名稱';
$string['lblname'] = '"名稱"標籤名稱';
$string['lblnumofusers'] = '"使用者數量"標籤名稱';
$string['lblsputtname'] = '"寄問卷調查給講師"標籤名稱';
$string['lblsurname'] = '"姓"標籤名稱';
$string['lblteachname'] = '"講師"標籤名稱';
$string['leftandrightdate'] = '{$a->leftdate} 到 {$a->righttdate}';
$string['limit'] = '限制';
$string['limitanswers'] = '參與人員的限制人數';
$string['limitanswers_help'] = '若你變更此選項並且有已劃位的人員，你可以移除他們無須通知';
$string['location'] = '地點';
$string['mailconfirmationsent'] = '將儘速收到確認郵件';
$string['managebooking'] = '管理';
$string['maxoverbooking'] = '最大數,置於候選列表的數量';
$string['maxparticipantsnumber'] = '最大數,參與人員的數量';
$string['maxperuser'] = '最大數,每使用者可同時劃位數';
$string['maxperuser_help'] = '個人在活動中一次能夠劃位的最大數量。會議時間結束後，無法再進行限制計算。';
$string['maxperuserwarning'] = '目前有 {$a->count}/{$a->limit} 最多劃位數';
$string['messagesend'] = '訊息已傳送成功';
$string['messagesubject'] = '主題';
$string['messagetext'] = '訊息';
$string['minutes'] = '{$a} 分鐘';
$string['modulename'] = '劃位';
$string['modulenameplural'] = '劃位';
$string['mustchooseone'] = '儲存前須選取一個選項, 無資訊被儲存。';
$string['mustfilloutuserinfobeforebooking'] = '處理劃位表單前，請完成個人劃位資訊';
$string['myoptions'] = '我的選項 ({$a})';
$string['no'] = '否';
$string['nobookingselected'] = '無劃位選項被選取';
$string['nocourse'] = '劃位選項沒有課程被選取';
$string['nodateset'] = '課程日期未設置';
$string['noguestchoose'] = '抱歉,訪客不允許輸入資料';
$string['noresultsviewable'] = '結果目前無法被檢視';
$string['norighttobook'] = '您的使用者角色無法劃位，請登入您的帳號或連絡管理員授予權限或';
$string['nosubscribers'] = '沒有講師被指派';
$string['notbooked'] = '還未被劃位';
$string['notconectedbooking'] = '無連接';
$string['noteacherfound'] = '無講師被找到在行 {$a}:';
$string['notificationsubject'] = '即將上架的課程...';
$string['notificationtext'] = '活動完成顯示的通知內容';
$string['notificationtext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['notificationtextmessage'] = '課程即將開始:

課程名稱:   {$a->title}
開課期間: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}';
$string['notificationtextsubject'] = '關於課程開始的資訊';
$string['notifyemail'] = '開始前通知';
$string['notifyemaildefaultmessage'] = 'Your booking has been registered
您的劃位已經被登記


劃位狀態: {$a->status}
參與人員:   {$a->participant}
課程名稱:   {$a->title}
開課期間: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
檢視您所有劃位的課程，點選連結: {$a->bookinglink}
相關課程可以在此找到，點選連結: {$a->courselink}';
$string['notifyemail_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['notopenyet'] = '抱歉,此活動未可用直到 {$a}';
$string['nouserfound'] = '找不到使用者';
$string['nousers'] = '無使用者';
$string['numgenerator'] = '啟用錄製,號碼產生?';
$string['numrec'] = '錄製,號碼.';
$string['onlythisbookingurl'] = '連結到此劃位的URL';
$string['onwaitinglist'] = '於候選列表中';
$string['optiondates'] = '多重日期議程';
$string['optiondatessucesfullydelete'] = '議程時間被已刪除';
$string['optiondatessucesfullysaved'] = '議程時間已儲存';
$string['optiondatestime'] = '議程時間';
$string['optionid'] = 'Option ID';
$string['optionmenu'] = '此劃位選項';
$string['organizatorname'] = '創立者名稱';
$string['otherbookingaddrule'] = '增加新規則　';
$string['otherbookinglimit'] = '限制';
$string['otherbookinglimit_help'] = '多少使用者可從選項中被同意，若值為0,可同意無上限的使用者。';
$string['otherbookingnumber'] = '使用者數量';
$string['otherbookingoptions'] = '同意從...';
$string['otherbookingsucesfullysaved'] = '規則已儲存';
$string['paginationnum'] = '記錄的N.-分頁';
$string['pdfdate'] = '劃位日期:';
$string['pdflocation'] = '地點：';
$string['pdfroom'] = '教室：';
$string['pdfsignature'] = '簽名';
$string['pdfstudentname'] = '學生姓名';
$string['pdftodaydate'] = '日期：';
$string['placesavailable'] = '空位可選: {$a->available} of {$a->maxanswers}';
$string['pluginadministration'] = '劃位管理';
$string['pluginname'] = '劃位';
$string['pollstrftimedate'] = '%Y-%m-%d';
$string['pollurl'] = '問卷調查URL';
$string['pollurl_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['pollurlteachers'] = '講師問卷URL';
$string['pollurlteachers_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['pollurlteacherstext'] = '講師傳送問卷調查URL';
$string['pollurlteacherstext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['pollurlteacherstextmessage'] = '請參與此次的問卷

問卷網址 {pollurlteachers}';
$string['pollurlteacherstextsubject'] = '請參與此次的問卷';
$string['pollurltext'] = '傳送問卷調查URL';
$string['pollurltext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['pollurltextmessage'] = '請參與此次的問卷

問卷網址 {pollurl}';
$string['pollurltextsubject'] = '請參與此次的問卷';
$string['potentialsubscribers'] = '潛在用戶';
$string['question'] = '問題';
$string['ratingsuccess'] = '評比已更新成功';
$string['removeafterminutes'] = 'N分鐘後移除活動完成';
$string['removeresponses'] = '移除所有回應';
$string['reset'] = '重置';
$string['responses'] = '回應';
$string['responsesto'] = '回應到 {$a}';
$string['rootcategory'] = 'Root';
$string['savenewoptiondates'] = '儲存';
$string['savenewtagtemplate'] = '儲存';
$string['searchtag'] = '搜尋標籤';
$string['select'] = '選擇';
$string['selectatleastoneuser'] = '請至少選取一個使用者';
$string['selectcategory'] = '選擇目錄';
$string['selectoptionid'] = '請選取選項';
$string['selectoptioninotherbooking'] = '選項';
$string['sendconfirmmail'] = '寄送確認信';
$string['sendconfirmmailtobookingmanger'] = '寄送確認件給劃位管理者';
$string['sendcustommessage'] = '寄送自訂訊息';
$string['sendmailtobooker'] = '登記其他使用者頁:寄送郵件給使用者(Book other users page: Send mail to user who books instead to users who are booked)';
$string['sendmailtobooker_help'] = 'Activate this option in order to send booking confirmation mails to the user who books other users instead to users, who have been added to a booking option. This is only relevant for bookings made on the page "book other users".';
$string['sendpollurltoteachers'] = '寄送問卷調查URL';
$string['sendreminderemail'] = '寄送提醒郵件';
$string['sendreminderemailsuccess'] = '通知信已成功寄出';
$string['showactive'] = '活動劃位';
$string['showallbookings'] = '所有劃位';
$string['showhelpfullnavigationlinks'] = '顯示導覽連結.';
$string['showhelpfullnavigationlinks_helt'] = '顯示"前往登記劃位"及"前往頂部"連結';
$string['showinapi'] = '顯示API:';
$string['showmybookings'] = '我的劃位 ({$a})';
$string['showonlymyinstitutions'] = '我的機構';
$string['sign_in_sheet_download'] = '下載登入表格';
$string['spaceleft'] = '席次開放';
$string['spacesleft'] = '席次開放';
$string['startendtimeknown'] = '課程開始及結束時間已知悉';
$string['starttimenotset'] = '開始日期未設置';
$string['statuschangebookedmessage'] = '您好 {$a->participant},

您的劃位請求已被登記

劃位狀態: {$a->status}
參與人員:   {$a->participant}
課程名稱:   {$a->title}
開課日期: {$a->startdate} {$a->starttime} - {$a->enddate} {$a->endtime}
檢視您所有劃位的課程，點選連結: {$a->bookinglink}';
$string['statuschangebookedsubject'] = '{$a->title} 劃位狀態已變更';
$string['statuschangetext'] = '狀態變更訊息';
$string['statuschangetext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中。

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['submitandaddnew'] = '儲存後新增';
$string['subscribersto'] = '\'{$a} 講師　';
$string['subscribetocourse'] = '使用者報名課程(Enrol users in the course)';
$string['subscribeuser'] = '在下列課程中進行選課';
$string['sucesfulldeleted'] = '目錄已刪除';
$string['sucesfulldeletedinstitution'] = '機構已刪除';
$string['tagsucesfullysaved'] = '標籤已刪除';
$string['tagtag'] = '標籤';
$string['tagtemplates'] = '標籤範本';
$string['tagtext'] = '文字內容';
$string['taken'] = '拿取';
$string['teachers'] = '講師:';
$string['timecloseoption'] = '限制劃位選項的可用性直到確認日期';
$string['timecreated'] = '時間已建立';
$string['timerestrict'] = 'estrict answering to this time period: This is deprecated and will be removed. Please use "Restrict Access" settings for making the booking activity available for a certain period';
$string['to'] = '到';
$string['toomuchusersbooked'] = '可創位使用者的最大數量: {$a}';
$string['topic'] = '議題';
$string['unlimited'] = '無限制';
$string['updatebooking'] = '編輯劃位選項';
$string['usedinbooking'] = '不可刪除目錄,因劃位功能正在使用';
$string['userdownload'] = '下載使用者';
$string['userid'] = 'UserID';
$string['userleave'] = '使用者離開劃位功能';
$string['userleavebookedmessage'] = '您好 {$a->participant},

您已成功從 {$a->title} 取消訂閱';
$string['userleavebookedsubject'] = '您已成功從 {$a->title} 取消訂閱';
$string['userleave_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中。

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['usernameofbookingmanager'] = '劃位管理者的Username';
$string['usernameofbookingmanager_help'] = 'Username of the user who will be displayed in the "From" field of the confirmation notifications. If the option "Send confirmation email to booking manager" is enabled, this is the user who receives a copy of the confirmation notifications.';
$string['userrssucesfullenroled'] = '所以使用者已成功選課';
$string['users'] = '<< 管理回應';
$string['userssucesfullybooked'] = '所有使用者已成功登記到其他劃位';
$string['viewallresponses'] = '管理 {$a} 回應';
$string['waitinglist'] = '候選列表';
$string['waitinglisttaken'] = '在候選列表中';
$string['waitinglistusers'] = '使用者在候選列表中';
$string['waitingplacesavailable'] = '候選列表中席次可選: {$a->maxoverbooking} 的 {$a->overbookingavailable}';
$string['waitingtext'] = '候選列表確認';
$string['waitingtext_help'] = '若為空白將使用站台預設文字。你能夠使用下列任何文字變數在文字段落中。

<ul>
<li>{status}-狀態</li>
<li>{participant}-參與者}</li>
<li>{title}-標題</li>
<li>{duration}-期間</li>
<li>{starttime}-開始時間</li>
<li>{endtime}-結束時間</li>
<li>{startdate}-開始日期</li>
<li>{enddate}-{結束日期</li>
<li>{courselink}-課程連結</li>
<li>{bookinglink}-選課連結</li>
<li>{pollurl}-問卷調查連結</li>
<li>{pollurlteachers}-講師問卷連結</li>
<li>{location}-地點</li>
<li>{institution}-機構</li>
<li>{address}-地址</li>
<li>{eventtype}-會議項型</li>
<li>{teacher}-講師</li>
<li>{teacherN}-講師N - N講師編號 ex. {講師1}</li>
<li>{pollstartdate}</li>
<li>{qr_id} - 插入QR Code使用user id</li>
<li>{qr_username} - 插入QR Code使用user id</li>
<li>{times} - 議程時間</li>
</ul>';
$string['waitspaceavailable'] = '候選列表可用';
$string['week'] = '周';
$string['withselected'] = '被選使用者：';
$string['wrongdataallfields'] = '請填寫完成欄位';
$string['wrongfile'] = '錯誤檔案！';
$string['yes'] = '是的';
$string['yourselection'] = '你的選取';
