<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = '加入螢幕快照';
$string['advertise'] = '刊登此課程，提供大家參加';
$string['advertised'] = '刊登';
$string['advertiseon'] = '在{$a}刊登此課程';
$string['advertiseonhub'] = '在課程集散中心刊登此課程';
$string['advertiseonmoodleorg'] = '在moodle.org刊登此課程';
$string['advertisepublication_help'] = '在社群課程集散中心刊登您的課程，讓更多的人能發現它，並進來參加課程。';
$string['all'] = '全部';
$string['allowglobalsearch'] = '公佈這課程集散中心，並允許全站搜尋所有課程';
$string['allowpublicsearch'] = '公佈這課程集散中心，讓大家可以參加。';
$string['audience'] = '對象';
$string['audienceadmins'] = 'Moodle管理員';
$string['audienceeducators'] = '教育工作者';
$string['audience_help'] = '為這課程選擇目標觀眾';
$string['audiencestudents'] = '學生';
$string['badgesnumber'] = '獎章數目';
$string['badurlformat'] = '錯誤的網址格式';
$string['cannotsearchcommunity'] = '對不起，您沒有瀏覽本頁面所需的權限';
$string['community'] = '社群';
$string['communityremoved'] = '課程連結已從您的列表刪除';
$string['confirmregistration'] = '確認註冊';
$string['contactable'] = '公開聯絡方式';
$string['contactable_help'] = '若設為"是"，課程集散中心將顯示您的電子郵件信箱。';
$string['contactemail'] = '聯絡人電子郵件信箱';
$string['contactname'] = '聯絡人姓名';
$string['contactphone'] = '電話';
$string['contactphone_help'] = '電話號碼只會顯示給集散中心管理員看，而不會公開顯示。';
$string['continue'] = '繼續';
$string['contributornames'] = '其他貢獻者';
$string['contributornames_help'] = '您可以在此列出所有對此課程有貢獻的人的名字。';
$string['coursemap'] = '課程地圖';
$string['coursename'] = '名稱';
$string['courseprivate'] = '私人的';
$string['coursepublic'] = '公開的';
$string['coursepublished'] = '此課程已經成功發佈在“{$a}”。';
$string['courseshortname'] = '簡稱';
$string['courseshortname_help'] = '輸入您課程的簡稱，它不需要是獨一無二的。';
$string['coursesnumber'] = '課程數（{$a}）';
$string['courseunpublished'] = '這課程 {$a->courseshortname}已經不再繼續發佈在 {$a->hubname}。';
$string['courseurl'] = '課程網址';
$string['courseurl_help'] = '您課程的網址。此網址會在搜尋結果中顯示為連結。';
$string['creatorname'] = '建立者';
$string['creatorname_help'] = '建立者是建立此課程的人。';
$string['creatornotes'] = '建立者的備註';
$string['creatornotes_help'] = '建立者的備註是用來告訴教師們如何使用這一課程。';
$string['deletescreenshots'] = '刪除這些螢幕快照';
$string['deletescreenshots_help'] = '刪除所有已上傳的螢幕快照。';
$string['demourl'] = '示範網站網址';
$string['demourl_help'] = '輸入您課程示範網站的網址。預設上，它就是您的課程網址。這網址會以鏈結形式出現在搜尋結果上。';
$string['description'] = '說明';
$string['description_help'] = '這課程說明將會顯示在課程集散中心的課程清單上。';
$string['detectednotexistingpublication'] = '{$a->hubname} 會列出已經不存在的課程。提醒集散中心管理員說這發佈編號{$a->id}的課程應該被移除。';
$string['downloadable'] = '可下載的';
$string['educationallevel'] = '教育程度';
$string['educationallevel_help'] = '選擇此課程最適合的教育程度。';
$string['edulevelassociation'] = '學會';
$string['edulevelcorporate'] = '公司';
$string['edulevelgovernment'] = '政府';
$string['edulevelother'] = '其他';
$string['edulevelprimary'] = '初等教育';
$string['edulevelsecondary'] = '中等教育';
$string['eduleveltertiary'] = '高等教育';
$string['emailalert'] = '電子郵件通知';
$string['emailalert_help'] = '如果啟用該項，您將會收到來自中心伺服器管理員的安全問題和重要消息的郵件。';
$string['enrollable'] = '可選課的';
$string['errorbadimageheightwidth'] = '錯誤! 圖片最大不可超過{$a->width} X {$a->height}';
$string['errorcourseinfo'] = '錯誤! 從課程集散中心擷取課程後設資料(metadata)時發生錯誤。請稍後重新讀取此頁再試一次，或者您可以用下列預設的後設資料繼續這一註冊過程。';
$string['errorcoursepublish'] = '錯誤! 這課程在發佈時發生錯誤。請稍後再試。';
$string['errorcoursewronglypublished'] = '錯誤! 經從集散中心收到一個發佈的錯誤。請稍後再試。';
$string['errorcron'] = '錯誤! 在"{$a->hubname}" 更新註冊時發生錯誤。({$a->errormessage})';
$string['errorcronnoxmlrpc'] = '錯誤! XML-RPC必須啟用才能更新這註冊。';
$string['errorhublisting'] = '錯誤! 當從Moodle.org擷取集散中心清單時，發生錯誤，請稍後再試。({$a})';
$string['errorlangnotrecognized'] = 'Moolde無法識別提供的語言編碼。請聯絡{$a}';
$string['errorregistration'] = '註冊時發生錯誤，請稍候再試。({$a})';
$string['errorunpublishcourses'] = '錯誤! 由於不知原因的錯誤，這個在集散中心的課程無法被刪除。請稍後再試(建議)或聯絡集散中心管理員。';
$string['existingscreenshotnumber'] = '有{$a}張螢幕快照。一旦集散中心管理員啟用您的課程，您將可在此頁看到這些螢幕快照。';
$string['existingscreenshots'] = '目前的螢幕快照';
$string['forceunregister'] = '是的，清除註冊資料';
$string['forceunregisterconfirmation'] = '您的網站無法聯絡上{$a}。這集散中心可能暫時當機。除非您確定您要繼續在本地端移除註冊，否則請取消，稍後再試。';
$string['geolocation'] = '地理位置';
$string['geolocation_help'] = '在未來我們可能會提供以所在位置為基礎的搜尋。若你要指名你的課程所在位置，請使用經緯度數值(例如，-31.947884,115.871285)。你可以用Google Map找到這些數值。';
$string['hub'] = '課程集散中心';
$string['imageurl'] = '圖片網址';
$string['imageurl_help'] = '這圖片將會顯示在課程集散中心，他必須任何時候都可被集散中心所用，它的大小不可超過{$a->width} X {$a->height}。';
$string['information'] = '資訊';
$string['issuedbadgesnumber'] = '已頒發之獎章數目';
$string['language'] = '語言';
$string['language_help'] = '這課程的主要語言';
$string['lasttimechecked'] = '上次檢查時間';
$string['licence'] = '授權方式';
$string['licence_help'] = '您要以什麼授權方式下散佈你的課程';
$string['logourl'] = 'Logo網址';
$string['modulenumberaverage'] = '課程模組的平均數：({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['mustselectsubject'] = '您必須選擇一個科目';
$string['name'] = '名稱';
$string['name_help'] = '此名稱會顯示在課程列表中。';
$string['neverchecked'] = '從未檢查';
$string['next'] = '下一步';
$string['no'] = '不';
$string['nocheckstatusfromunreghub'] = '這網站沒有在集散中心註冊，因此無法檢查狀態';
$string['nohubselected'] = '沒有選擇課程集散中心';
$string['none'] = '無';
$string['nosearch'] = '不發佈課程集散中心或課程';
$string['notregisteredonhub'] = '在您可以發佈課程之前，您的管理員需要至少向一個課程集散中心註冊。請聯繫您的網站管理員。';
$string['notregisteredonmoodleorg'] = '您的管理員需要在 moodle.org 註冊此網站。';
$string['operation'] = '動作';
$string['orenterprivatehub'] = '也可以輸入一個私人的課程集散中心的網址：';
$string['participantnumberaverage'] = '課程成員數平均值（{$a}）';
$string['postaladdress'] = '郵政地址';
$string['postaladdress_help'] = '本站郵政地址，或者代表本站實體的通信地址。';
$string['postsnumber'] = '貼文數({$a})';
$string['previousregistrationdeleted'] = '先前的註冊已經從{$a}刪除，您可以重新開始註冊程序。謝謝。';
$string['prioritise'] = '優先';
$string['privacy'] = '隱私';
$string['privacy_help'] = '課程集散中心可能會顯示註冊網站的清單。若它有顯示，那您可以選擇是否要出現在這清單上。';
$string['private'] = '私人的';
$string['privatehuburl'] = '私人的課程集散中心網址';
$string['publicationinfo'] = '課程發佈資訊';
$string['publichub'] = '公開的課程集散中心';
$string['publishcourse'] = '發佈{$a}';
$string['publishcourseon'] = '發佈在{$a}';
$string['publishedon'] = '已經發佈在';
$string['publisheremail'] = '發佈者電子郵件';
$string['publisheremail_help'] = '發佈者電子郵件可讓課程集散中心管理員提醒出版者，有關發佈課程的狀態的任何改變。';
$string['publishername'] = '發佈者';
$string['publishername_help'] = '發佈者是指正式擁有這課程版權的個人或組織。除非您是替其他人發佈，否則通常此人就是您自己。';
$string['publishon'] = '發佈到';
$string['publishonspecifichub'] = '發佈到另一課程集散中心';
$string['questionsnumber'] = '試題數({$a})';
$string['readvertiseon'] = '更新在{$a}的刊登資訊';
$string['registeredcourses'] = '已註冊的課程';
$string['registeredmoodleorg'] = 'Moodle.org（{$a}）';
$string['registeredon'] = '您在那些課程集散中心註冊您的網站';
$string['registeredsites'] = '已註冊的網站';
$string['registermoochtips'] = '請先在Moodle.org 註冊您的網站，以取得安全性警告，並使用我們的課程分享平台Moodle.net。';
$string['registersite'] = '在{$a}註冊';
$string['registerwith'] = '在課程集散中心註冊';
$string['registrationconfirmed'] = '網站註冊已經確認';
$string['registrationconfirmedon'] = '謝謝您註冊你的網站，註冊資訊將會透過"網站註冊"排程工作保持更新。';
$string['registrationinfo'] = '註冊資訊';
$string['registrationupdated'] = '註冊已經被更新。';
$string['registrationupdatedfailed'] = '註冊更新失敗。';
$string['removefromhub'] = '從課程集散中心移除';
$string['renewregistration'] = '更新註冊';
$string['resourcesnumber'] = '資源數（{$a}）';
$string['restartregistration'] = '重新註冊';
$string['roleassignmentsnumber'] = '角色指派數({$a})';
$string['screenshots'] = '螢幕快照';
$string['screenshots_help'] = '任何螢幕快照將會顯示在搜尋結果中。';
$string['search'] = '搜尋';
$string['selecthub'] = '選擇課程集散中心';
$string['selecthubforadvertise'] = '選擇課程集散中心刊登';
$string['selecthubforsharing'] = '選擇課程集散中心來上傳';
$string['selecthubinfo'] = '社群課程集散中心是可以列出課程的伺服器。您要在某一課程集散中心發佈您的課程之前，您的Moodle網站要先在它那兒註冊。
若您想要的課程集散中心沒列在下面，請聯絡您的網站管理員。';
$string['sendfollowinginfo'] = '更多資訊';
$string['sendfollowinginfo_help'] = '以下資訊將被發送貢獻到整體統計。它不會被公開到任何網站。';
$string['sendingcourse'] = '正在發送課程';
$string['sendingsize'] = '請稍候，這課程正在上傳({$a->total}Mb)...';
$string['sent'] = '....完成';
$string['settings'] = '設定';
$string['settingsupdated'] = '設定已更新。';
$string['share'] = '分享此課程，提供大家下載';
$string['shared'] = '共享的';
$string['shareon'] = '上傳此課程到{$a}';
$string['shareonhub'] = '上傳此課程到課程集散中心';
$string['sharepublication_help'] = '上傳此課程到社群課程集散中心，讓大家可以下載它，並將它安裝到他們自己的 Moodle 網站上。';
$string['siteadmin'] = '網站管理員';
$string['siteadmin_help'] = '網站管理員的全名';
$string['sitecountry'] = '國家';
$string['sitecountry_help'] = '您的組織所在的國家。';
$string['sitecreated'] = '網站已經建立';
$string['sitedesc'] = '說明';
$string['sitedesc_help'] = '這些說明文字將會出現在網站清單上。請只使用純文字格式。';
$string['siteemail'] = '電子郵件信箱';
$string['siteemail_help'] = '您必須提供電子郵件信箱，讓課程集散中心管理員在需要時連絡您。它不會用於其他用途。建議您使用職務專用的email(例如， sitemanager@example.com)，而不要直接送給個人。';
$string['sitegeolocation'] = '地理位置';
$string['sitegeolocation_help'] = '在未來我們可能會提供以所在位置為基礎的搜尋。若要指名您的課程所在位置，請使用經緯度數值(例如，-31.947884,115.871285)。您可以用Google Map找到這些數值。';
$string['sitelang'] = '語言';
$string['sitelang_help'] = '您網站的主要語言，將會顯示在網站清單上';
$string['sitename'] = '名稱';
$string['sitename_help'] = '若課程集散中心允許，這名稱將會出現在網站清單上。';
$string['sitephone'] = '電話';
$string['sitephone_help'] = '只有課程集散中心管理員能看到您的電話號碼。';
$string['siteprivacy'] = '隱私';
$string['siteprivacylinked'] = '公佈網站名稱及連結';
$string['siteprivacynotpublished'] = '請不要公佈此網站';
$string['siteprivacypublished'] = '只公佈網站名稱';
$string['siteregconfcomment'] = '您的網站需要在{$a}做最後確認(為了防止{$a}上的垃圾廣告)';
$string['siteregistrationcontact'] = '聯絡表單';
$string['siteregistrationcontact_help'] = '如果您允許，其他人可以通過課程集散中心提供的聯絡表單與您聯繫。但他們絕對不會看到您的電子郵件信箱位址。';
$string['siteregistrationemail'] = '電子郵件';
$string['siteregistrationemail_help'] = '若啟用，課程集散中心管理員會以電子郵件通知您重要消息，例如安全問題。';
$string['siteregistrationupdated'] = '網站註冊已經更新';
$string['siterelease'] = 'Moodle發行版本';
$string['siterelease_help'] = '本站使用的Moodle發行版號。';
$string['siteupdatedcron'] = '“{$a}”已更新網站註冊';
$string['siteupdatesend'] = '在課程集散中心已完成更新註冊資料。';
$string['siteupdatesstart'] = '開始向課程集散中心更新註冊.....';
$string['siteurl'] = '網站網址';
$string['siteurl_help'] = '這一網站的網址。若隱私設定為允許人們看見網站位址，那這網址將被看見。';
$string['siteversion'] = 'Moodle版本';
$string['siteversion_help'] = '本站的Moodle版本';
$string['specifichubregistrationdetail'] = '您也可以將其他社群課程集散中心登錄到您的網站。';
$string['statistics'] = '統計的隱私';
$string['status'] = '課程集散中心清單';
$string['statuspublished'] = '已經公佈列出';
$string['statusunpublished'] = '尚未公佈列出';
$string['subject'] = '科目';
$string['subject_help'] = '選擇這一課程所屬的主要學科領域。';
$string['tags'] = '標籤';
$string['tags_help'] = '標籤有助於將課程歸類，並容易被找到。請使用簡單、有意義的字，並以逗點隔開。例如： 數學,代數,幾何';
$string['trustme'] = '信任';
$string['type'] = '刊登/分享';
$string['unknownstatus'] = '未知';
$string['unlistedurl'] = '未列出的課程集散中心網址';
$string['unprioritise'] = '無優先的';
$string['unpublish'] = '取消發佈';
$string['unpublishalladvertisedcourses'] = '移除所有正刊登在課程集散中心的課程';
$string['unpublishalluploadedcourses'] = '移除所有已上傳到課程集散中心的課程';
$string['unpublishconfirmation'] = '您真的要從課程集散中心“{$a->hubname}”刪除課程“{$a->courseshortname}”嗎';
$string['unpublishcourse'] = '取消發佈{$a}';
$string['unregister'] = '取消註冊';
$string['unregisterconfirmation'] = '您即將從課程集散中心{$a}取消這網站的註冊。如果您切斷連接，您將不能管理留在那裡的課程。您確信要取消註冊嗎？';
$string['unregisterfrom'] = '取消在{$a}的註冊';
$string['unregistrationerror'] = '從課程集散中心取消註冊時發生錯誤：{$a}';
$string['untrustme'] = '不信任';
$string['update'] = '更新';
$string['updatesite'] = '在{$a}更新註冊資料';
$string['updatestatus'] = '現在檢查。';
$string['uploaded'] = '已上傳';
$string['url'] = '課程集散中心網址';
$string['urlalreadyregistered'] = '您的網站似乎已經在此課程集散中心註冊過，這表示出了差錯。請聯絡課程集散中心管理員重設您的註冊資料，這樣您才可以從新再試一次。';
$string['usersnumber'] = '用戶數（{$a}）';
$string['warning'] = '警告';
$string['wrongtoken'] = '因為某種未知原因（網路問題？）註冊已經失敗。請稍後再試一次。';
$string['wrongurlformat'] = '錯誤的網址格式';
$string['xmlrpcdisabledcommunity'] = '這伺服器的XML-RPC延伸套件沒有啟用，所以您無法搜尋和下載課程。';
$string['xmlrpcdisabledpublish'] = '這伺服器的XML-RPC延伸套件沒有啟用，所以您無法發佈課程或管理已經發佈的課程。';
$string['xmlrpcdisabledregistration'] = '這伺服器的XML-RPC延伸套件沒有啟用，所以您無法取消註冊或更新您的註冊資料。';
